<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bounces', function (Blueprint $table) {
            // Change password column from VARCHAR(255) to TEXT to handle longer encrypted passwords
            $table->text('password')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bounces', function (Blueprint $table) {
            // Revert back to VARCHAR(255) - this might cause data loss if passwords are longer
            $table->string('password', 255)->nullable()->change();
        });
    }
};
