<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Change email_subject column from varchar to text in broadcasts table
        Schema::table('broadcasts', function (Blueprint $table) {
            $table->text('email_subject')->change();
        });

        // Change email_subject column from varchar to text in schedule_campaign_stats table
        Schema::table('schedule_campaign_stats', function (Blueprint $table) {
            $table->text('email_subject')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert email_subject column back to varchar in broadcasts table
        Schema::table('broadcasts', function (Blueprint $table) {
            $table->string('email_subject')->change();
        });

        // Revert email_subject column back to varchar in schedule_campaign_stats table
        Schema::table('schedule_campaign_stats', function (Blueprint $table) {
            $table->string('email_subject')->change();
        });
    }
};

