<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
  
class UserTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): Void
    {
        $user = User::create([
            'name' => 'Team Relayzo', 
            'email' => 'team@relayzo.com',
            'password' => bcrypt('123456'),
            'contact_customize_listing' => json_encode(['custom_field_ids' => ["0"]])
        ]);
        
        $role = Role::create(['name' => 'Admin']);
         
        $permissions = Permission::pluck('id','id')->all();
       
        $role->syncPermissions($permissions);
         
        $user->assignRole([$role->id]);
    }
}
