<?php
return [
  'webhook_help_heading' => 'Verarbeitungsberichte für die Zustellung von ',

  'gmail_setup_help' => "
    <ol>
      <li><b>SMTP-Server:</b> smtp.gmail.com</li>
      <li><b>SMTP-Port:</b> 465 (SSL), 587 (TLS)</li>
      <li><b>Verschlüsselung:</b> SSL/TLS</li>
      <li><b>Benutzername:</b> Ihre vollständige Gmail-Adresse (z. B. ihrname@gmail.com)</li>
      <li><b>Passwort:</b> Ihr Gmail-App-Passwort (siehe unten)</li>
    </ol>
    <h5>Wichtig: Verwenden Sie ein App-Passwort</h5>
    <p>Google erlaubt keine weniger sicheren Apps mehr. Sie müssen:</p>
    <ol>
      <li>Die 2-Schritt-Verifizierung für Ihr Gmail-Konto aktivieren.</li>
      <li>Gehen Sie zu <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>App-Passwörter</a>.</li>
      <li>Ein App-Passwort generieren (z. B. für \"Mail\" und \"Andere (Benutzerdefinierter Name)\").</li>
      <li>Verwenden Sie dieses 16-stellige Passwort als Ihr SMTP-Passwort.</li>
    </ol>",

    'microsoft_setup_help' => "
    <ol>
      <li><b>SMTP-Server:</b> smtp.office365.com</li>
      <li><b>SMTP-Port:</b> 587</li>
      <li><b>Verschlüsselung:</b> TLS</li>
      <li><b>Benutzername:</b> Ihre vollständige Microsoft-E-Mail-Adresse (z. B. sie@ihrdomain.com)</li>
      <li><b>Passwort:</b> Ihr Microsoft-Konto-Passwort oder App-Passwort (siehe unten)</li>
    </ol>
    <h5>Wenn Sie MFA (Mehrfaktor-Authentifizierung) verwenden</h5>
    <p>Sie müssen ein App-Passwort verwenden:</p>
    <ol>
      <li>Gehen Sie zu <a href='https://security.microsoft.com' target='_blank' class='link-info'>Microsoft-Sicherheit</a>.</li>
      <li>Unter \"<b>Sicherheitsinformationen</b>\" > \"<b>Methoden hinzufügen</b>\" > wählen Sie App-Passwort.</li>
      <li>Generieren Sie das Passwort und verwenden Sie es in Ihrer SMTP-Konfiguration.</li>
    </ol>",


  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>Melden Sie sich</a> bei Ihrem Mailgun-Konto an</li>
      <li>Gehen Sie zu <b>Senden >> Webhooks</b></li>
      <li>Klicken Sie auf <b>'Webhook hinzufügen'</b></li>
      <li>Wählen Sie den <b>'Ereignistyp'</b> (Permanenter Fehler, Temporärer Fehler, Spam-Beschwerden)</li>
      <li>Kopieren Sie die 'Webhook-URL' und fügen Sie sie in das 'URL'-Feld ein</li>
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>Melden Sie sich</a> bei Ihrem SparkPost-Konto an</li>
      <li>Klicken Sie auf <b>Webhooks</b></li>
      <li>Geben Sie den Namen des Webhooks ein</li>
      <li>Kopieren Sie die <b>'Webhook-URL'</b> und fügen Sie sie in die <b>'Ziel-URL'</b> ein</li>
      <li>Wählen Sie die Ereignisse <b>Bounce</b>, <b>Spam-Beschwerden</b></li>
      <li>Wählen Sie <b>'Authentifizierungstyp'</b> als <b>Basic Auth</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>Melden Sie sich</a> bei Ihrem SendGrid-Konto an</li>
      <li>Gehen Sie zu <b>Einstellungen >> Mail-Einstellungen</b></li>
      <li>Aktivieren Sie den Ereignis-Webhook, wählen Sie alle Aktionen aus und fügen Sie die 'Webhook-URL' ein</li>
    </ol>",

    'webhook_help_amazon_ses' => "
    <b>Konfigurieren Sie Amazon SES, um Bounce-/Beschwerdeinformationen an Amazon SNS zu senden</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>Melden Sie sich</a> in der Amazon SES-Konsole an</li>
      <li>Klicken Sie auf <strong>Konfigurationssätze</strong></li>
      <li>Klicken Sie auf die Schaltfläche <strong>'Konfigurationssatz erstellen'</strong> und definieren Sie einen Namen, z. B. <strong>Relayzo-Reports</strong>. (<strong>Hinweis:</strong> Dieser Konfigurationssatzname wird später in Relayzo verwendet)</li>
      <li>Klicken Sie auf den kürzlich erstellten Konfigurationssatz</li>
      <li>Wählen Sie unter <strong>'Ziel hinzufügen'</strong> die Option <strong>SNS</strong> aus dem Dropdown-Menü</li>
      <li>Geben Sie einen Namen ein, z. B. <strong>RelayzoSNS</strong>, und wählen Sie die Ereignistypen aus, die Sie verarbeiten möchten.
      <ul>
        <li>Ablehnung</li>
        <li>Rückläufer (Bounce)</li>
        <li>Beschwerde</li>
        <li>Rendering-Fehler</li>
      </ul>
      </li>
      <li>Wählen Sie im Dropdown-Menü <strong>'SNS-Thema erstellen'</strong></li>
      <li>Definieren Sie einen <strong>Themennamen</strong>, z. B. <strong>Relayzo-SNS-Topic</strong>, und eine <strong>Anzeigenamen</strong></li>
      <li>Klicken Sie auf <strong>Speichern</strong></li>
    </ol>
    <br>
    <b>Ein Thema und eine Abonnement in Amazon SNS erstellen</b>
    <ol>
      <li>Gehen Sie jetzt zu <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon Simple Notification Service (SNS)</a></li>
      <li><strong>Wechseln</strong> Sie zu Themen</li>
      <li>Klicken Sie auf das <strong>kürzlich erstellte</strong> Thema</li>
      <li>Klicken Sie auf die Schaltfläche <strong>'Abonnement erstellen'</strong></li>
      <li>Verwenden Sie das richtige Protokoll, z. B. <strong>HTTP oder HTTPS</strong></li>
      <li>Geben Sie für <b>Endpunkt</b> die Webhook-URL ein: <strong>APP_URL/callback/amazon</strong>, die in Relayzo angezeigt wird.</li>
      <li>Wählen Sie <b>Abonnement erstellen</b>.</li>
      <li>Wählen Sie das erstellte Abonnement aus, z. B. <b>Relayzo-SNS</b>, und klicken Sie auf <b>Bestätigung anfordern</b></li>
      <li><b>Öffnen</b> Sie eine Datei von <b> <a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>Kopieren</b> Sie den gesamten Inhalt der Datei</li>
      <li><b>Fügen</b> Sie ihn in die Browser-URL in einem neuen Fenster ein. Sobald Sie die bestätigte Nachricht im <strong>XML-Format</strong> sehen, war die Bestätigung erfolgreich!</li>
    </ol>

    <h6>Sie sind jetzt bereit. Kopieren Sie nun den <strong>Konfigurationssatz-Namen</strong>, den Sie kürzlich erstellt haben, z. B. <strong>Relayzo-Reports</strong>, und fügen Sie ihn in <strong>Konfigurationssatz-Name</strong> ein.<h6>",

    'schedule_speed' => 'Verwalten Sie die Versandgeschwindigkeit dieses Triggers. Im Fall von "Unbegrenzt" versucht das System, so schnell wie möglich zu senden, indem es die verfügbaren Ressourcen nutzt.',

    'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>Melden Sie sich an</a> bei Ihrem ElasticEmail-Konto</li>
      <li>Gehen Sie zu <strong>Einstellungen → Webhooks</strong> im Elastic Email-Dashboard.</li>
      <li>Klicken Sie auf <strong>'Webhook verwalten'</strong></li>
      <li>Webhook-Name: z. B. Relayzo Events</li>
      <li>Kopieren Sie die <b>'Webhook-URL'</b> und fügen Sie sie in das Feld <b>'URL'</b> ein</li>
      <li>Ereignisse: Wählen Sie die gewünschten aus (Bounce, Beschwerde usw.)</li>
      <li>Datenformat: Wählen Sie POST (application/json)</li>
    </ol>",

    'webhook_help_postal' => "
    <ol>
      <li>Melden Sie sich in der Postal-Weboberfläche an</li>
      <li>Gehen Sie zu <b>Organisation > Mailserver</b></li>
      <li>Gehen Sie zu <b>Webhooks</b></li>
      <li>Klicken Sie auf <b>Webhook erstellen</b></li>
    </ol>
    <h6>Füllen Sie das Webhook-Formular aus:</h6>
    <ol>
      <li><b>Name:</b> Relayzo Bounce Handler</li>
      <li><b>URL:</b> Kopieren Sie die <b>'Webhook-URL'</b> und fügen Sie sie in das Feld <b>'URL'</b> ein</li>
      <li><b>Aktiviert:</b> Ja – Anfragen an diesen Webhook senden</li>
      <li><b>Ereignisse:</b> Wählen Sie die Ereignisse aus, auf die Sie hören möchten: <b>MessageDeliveryFailed</b>, <b>MessageBounced</b></li>
      <li>Klicken Sie auf <b>Webhook erstellen</b></li>
    </ol>",


];
