<?php
return [
  'webhook_help_heading' => 'Process Delivery Reports for ',

  'gmail_setup_help' => "
    <ol>
      <li><b>SMTP Server:</b> smtp.gmail.com</li>
      <li><b>SMTP Port:</b> 465 (SSL), 587 (TLS)</li>
      <li><b>Encryption:</b> SSL/TLS</li>
      <li><b>Username:</b> Your full Gmail address (e.g. yourname@gmail.com)</li>
      <li><b>Password:</b> Your Gmail App Password (see below)</li>
    </ol>
    <h5>Important: Use an App Password</h5>
    <p>Google does not allow less secure apps anymore. You must:</p>
    <ol>
      <li>Enable 2-Step Verification on your Gmail account.</li>
      <li>Go to <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>App Passwords</a>.</li>
      <li>Generate an app password (e.g., for \"Mail\" and \"Other (Custom name)\").</li>
      <li>Use that 16-character password as your SMTP password.</li>
    </ol>",

    'microsoft_setup_help' => "
    <ol>
      <li><b>SMTP Server:</b> smtp.office365.com</li>
      <li><b>SMTP Port:</b> 587</li>
      <li><b>Encryption:</b> TLS</li>
      <li><b>Username:</b> Your full Microsoft email (e.g., you@yourdomain.com)</li>
      <li><b>Password:</b> Your Microsoft account password or App Password (see below)</li>
    </ol>
    <h5>If You Use MFA (Multi-Factor Authentication)</h5>
    <p>You must use an App Password:</p>
    <ol>
      <li>Go to <a href='https://security.microsoft.com' target='_blank' class='link-info'>Microsoft Security.</a>.</li>
      <li>Under \"<b>Security info</b>\" > \"<b>Add method</b>\" > choose App password.</li>
      <li>Generate and use that password in your SMTP setup.</li>
    </ol>",

  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>Login</a> to your Mailgun account</li>
      <li>Navigate to <b>Send >> Webhooks</b></li>
      <li>Click <b>'Add Webhook'</b></li>
      <li>Select the <b>'Event Type'</b> (Permanent Failure, Temporary Failure, Spam Complaints)</li>
      <li>Copy the 'Webhook URL' and paste into the 'URL'</li>
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>Login</a> to your Sparkpost account</li>
      <li>Click on  <b> Webhooks</b></li>
      <li>Enter the name of Webhook</li>
      <li>Copy the <b>'Webhook URL'</b> and paste into the <b>'Target URL'</b></li>
      <li>Select Events <b>Bounce</b>, <b>Spam Complaints</b></li>
      <li>Select <b>'Authentication Type'</b> to <b>Baisc Auth</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>Login</a> to your SendGrid account</li>
      <li>Navigate to <b>Settings >> Mail Settings</b></li>
      <li>Turn on Event Webhook, select all actions and insert the 'Webhook URL'</li>
    </ol>",

    'webhook_help_amazon_ses' => "
    <b>Configure Amazon SES to send bounce/complaint information to Amazon SNS</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>Login</a> to Amazon SES console</li>
      <li>Click on <strong>Configuration Sets</strong></li>
      <li>Click on the <strong>'Create Configuration Set'</strong> button and define a name e.g <strong>Relayzo-Reports</strong>. (<strong>Note:</strong> This configuration set name will be used later within Relayzo)</li>
      <li>Click on the recently created Configuration Set</li>
      <li>In <strong>'Add Destination'</strong> and choose <strong>SNS</strong> from the dropdown</li>
      <li>Write a name e.g<strong> RelayzoSNS</strong> and select the event types you want to process. 
      <ul>
        <li>Reject</li>
        <li>Bounce</li>
        <li>Complaint</li>
        <li>Rendering Failure</li>
      </ul>
      </li>
      <li>From the Topic dropdown, select <strong>'Create SNS Topic'</strong></li>
      <li>Define a <strong>Topic Name</strong> e.g <strong>Relayzo-SNS-Topic</strong> and <strong>Display Name</strong></li>
      <li>Press <strong>Save</strong></li>
    </ol>
    <br>
    <b>Create a topic and subscription in Amazon SNS</b>
    <ol>
      <li>Now Navigate to <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon Simple Notification Service (SNS)</a></li>
      <li><strong>Navigate</strong> to Topics</li>
      <li>Click on the <strong>recently created</strong> topic</li>
      <li>Click on <strong>'Create Subscription</strong> button</li>
      <li>Use the correct protocol i.e <strong>HTTP or HTTPS</strong></li>
      <li>For <b>Endpoint</b>, enter the Webhook URL: <strong>APP_URL/callback/amazon</strong> showing within Relayzo.</li>
      <li>Choose <b>Create subscription</b>.</li>
      <li>Select created subscription <b>eg. Relayzo-SNS</b> click <b>Request Confirmation</b></li>
      <li><b>Open</b> a file from <b> <a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>Copy</b> all contents from the file</li>
      <li><b>Paste</b> it to browser URL in new window, Once you see the confirmed message in <strong>XML format</strong>, it means the confirmation was successful!</li>
    </ol>

    <h6>You are all set now. Now copy the <strong>Configuration Set Name</strong> e.g <strong>Relayzo-Reports</strong> you created recently and
    paste it to <strong>Configuration Set Name</strong>.<h6>",

    'schedule_speed' => 'Manage the sending speed of this trigger. In case of "Unlimited", system attempts to send as much as it can in the short possible time span, utilizing the available resources.',

    'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>Login</a> to your ElasticEmail account</li>
      <li>Go to <strong>Settings → Webhooks</strong> in your Elastic Email dashboard.</li>
      <li>Click <strong>'Manage Webhook' </strong></li>
      <li>Webhook Name: e.g., Relayzo Events</li>
      <li>Copy the <b>'Webhook URL'</b> and paste into the <b>'URL'</b></li>
      <li>Events: choose the ones you want (bounce, complaint, etc.)</li>
      <li>Data Format: choose POST (application/json)</li>
    </ol>",

    'webhook_help_postal' => "
    <ol>
      <li>Log in to your Postal web interface</li>
      <li>Go to the <b>Organization > Mail Server</b></li>
      <li>Go to <b>Webhooks</b></li>
      <li>Click <b>Create Webhook</b></li>
    </ol>
    <h6>Fill the webhook form:</h6>
    <ol>
      <li><b>Name:</b> Relayzo Bounce Handler</b></li>
      <li><b>URL:</b> Copy the <b>'Webhook URL'</b> and paste into the <b>'URL'</b></li>
      <li><b>Enabled:</b> Yes - send requests to this weebhook</b></li>
      <li><b>Events:</b> Check the events you want to listen to: <b>MessageDeliveryFailed</b>, <b>MessageBounced</b></li>
      <li>Click <b>Create Webhook</b></li>
    </ol>",


];