<?php
return [
  'webhook_help_heading' => 'Procesar informes de entrega para ',

  'gmail_setup_help' => "
    <ol>
      <li><b>Servidor SMTP:</b> smtp.gmail.com</li>
      <li><b>Puerto SMTP:</b> 465 (SSL), 587 (TLS)</li>
      <li><b>Encriptación:</b> SSL/TLS</li>
      <li><b>Nombre de usuario:</b> Tu dirección de Gmail completa (por ejemplo, tunombre@gmail.com)</li>
      <li><b>Contraseña:</b> Tu contraseña de aplicación de Gmail (ver abajo)</li>
    </ol>
    <h5>Importante: Usa una contraseña de aplicación</h5>
    <p>Google ya no permite aplicaciones menos seguras. Debes:</p>
    <ol>
      <li>Activar la verificación en 2 pasos en tu cuenta de Gmail.</li>
      <li>Ve a <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>Contraseñas de aplicaciones</a>.</li>
      <li>Generar una contraseña de aplicación (por ejemplo, para \"Mail\" y \"Otro (nombre personalizado)\").</li>
      <li>Usar esa contraseña de 16 caracteres como tu contraseña SMTP.</li>
    </ol>",

    'microsoft_setup_help' => "
    <ol>
      <li><b>Servidor SMTP:</b> smtp.office365.com</li>
      <li><b>Puerto SMTP:</b> 587</li>
      <li><b>Encriptación:</b> TLS</li>
      <li><b>Nombre de usuario:</b> Tu dirección de correo de Microsoft completa (por ejemplo, tu@tudominio.com)</li>
      <li><b>Contraseña:</b> Tu contraseña de cuenta de Microsoft o contraseña de aplicación (ver abajo)</li>
    </ol>
    <h5>Si usas MFA (Autenticación multifactor)</h5>
    <p>Debes usar una contraseña de aplicación:</p>
    <ol>
      <li>Ve a <a href='https://security.microsoft.com' target='_blank' class='link-info'>Seguridad de Microsoft</a>.</li>
      <li>Bajo \"<b>Información de seguridad</b>\" > \"<b>Agregar método</b>\" > selecciona Contraseña de aplicación.</li>
      <li>Genera la contraseña y úsala en tu configuración SMTP.</li>
    </ol>",


  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>Inicia sesión</a> en tu cuenta de Mailgun</li>
      <li>Ve a <b>Enviar >> Webhooks</b></li>
      <li>Haz clic en <b>'Agregar Webhook'</b></li>
      <li>Selecciona el <b>'Tipo de evento'</b> (Fallo permanente, Fallo temporal, Quejas de spam)</li>
      <li>Copia la 'URL del Webhook' y pégala en el campo 'URL'</li>
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>Inicia sesión</a> en tu cuenta de SparkPost</li>
      <li>Haz clic en <b>Webhooks</b></li>
      <li>Ingresa un nombre para el Webhook</li>
      <li>Copia la <b>'URL del Webhook'</b> y pégala en el campo <b>'URL de destino'</b></li>
      <li>Selecciona los eventos <b>Rebote</b> y <b>Quejas de spam</b></li>
      <li>Configura el <b>'Tipo de autenticación'</b> como <b>Autenticación básica</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>Inicia sesión</a> en tu cuenta de SendGrid</li>
      <li>Ve a <b>Configuración >> Configuración de correo</b></li>
      <li>Activa el Webhook de eventos, selecciona todas las acciones e ingresa la 'URL del Webhook'</li>
    </ol>",

  'webhook_help_amazon_ses' => "
    <b>Configurar Amazon SES para enviar información de rebotes/quejas a Amazon SNS</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>Inicia sesión</a> en la consola de Amazon SES</li>
      <li>Haz clic en <strong>Conjuntos de configuración</strong></li>
      <li>Haz clic en el botón <strong>'Crear conjunto de configuración'</strong> y define un nombre, por ejemplo, <strong>Relayzo-Reports</strong>. (<strong>Nota:</strong> Este nombre se usará más tarde en Relayzo)</li>
      <li>Selecciona el conjunto de configuración recién creado</li>
      <li>En <strong>'Agregar destino'</strong>, elige <strong>SNS</strong> del menú desplegable</li>
      <li>Ingresa un nombre, por ejemplo, <strong>RelayzoSNS</strong>, y selecciona los tipos de eventos que deseas procesar:
      <ul>
        <li>Rechazo</li>
        <li>Rebote</li>
        <li>Queja</li>
        <li>Fallo de renderizado</li>
      </ul>
      </li>
      <li>En el menú desplegable de Tema, selecciona <strong>'Crear tema SNS'</strong></li>
      <li>Define un <strong>Nombre del tema</strong>, por ejemplo, <strong>Relayzo-SNS-Topic</strong>, y un <strong>Nombre para mostrar</strong></li>
      <li>Presiona <strong>Guardar</strong></li>
    </ol>
    <br>
    <b>Crear un tema y una suscripción en Amazon SNS</b>
    <ol>
      <li>Ahora, ve a <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon Simple Notification Service (SNS)</a></li>
      <li>Dirígete a la sección <strong>Temas</strong></li>
      <li>Haz clic en el <strong>tema recién creado</strong></li>
      <li>Haz clic en el botón <strong>'Crear suscripción'</strong></li>
      <li>Selecciona el protocolo correcto, es decir, <strong>HTTP o HTTPS</strong></li>
      <li>Para el <b>Punto de conexión</b>, ingresa la URL del Webhook: <strong>APP_URL/callback/amazon</strong> mostrada en Relayzo</li>
      <li>Haz clic en <b>Crear suscripción</b></li>
      <li>Selecciona la suscripción creada, <b>por ejemplo, Relayzo-SNS</b>, y haz clic en <b>Solicitar confirmación</b></li>
      <li><b>Abre</b> el archivo desde <b><a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>Copia</b> todo el contenido del archivo</li>
      <li><b>Pégalo</b> en la barra de direcciones del navegador en una nueva ventana. Una vez que veas el mensaje de confirmación en <strong>formato XML</strong>, significa que la confirmación fue exitosa</li>
    </ol>

    <h6>¡Todo está listo! Ahora copia el <strong>Nombre del conjunto de configuración</strong>, por ejemplo, <strong>Relayzo-Reports</strong>, que creaste recientemente y pégalo en el campo <strong>Nombre del conjunto de configuración</strong>.</h6>",

  'schedule_speed' => 'Administra la velocidad de envío de este disparador. En caso de "Ilimitado", el sistema intentará enviar la mayor cantidad posible en el menor tiempo disponible, utilizando los recursos disponibles.',

  'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>Inicia sesión</a> en tu cuenta de ElasticEmail</li>
      <li>Ve a <strong>Configuración → Webhooks</strong> en el panel de Elastic Email.</li>
      <li>Haz clic en <strong>'Administrar Webhook'</strong></li>
      <li>Nombre del Webhook: por ejemplo, Relayzo Events</li>
      <li>Copia la <b>'URL del Webhook'</b> y pégala en el campo <b>'URL'</b></li>
      <li>Eventos: selecciona los que desees (rebote, queja, etc.)</li>
      <li>Formato de datos: selecciona POST (application/json)</li>
    </ol>",

    'webhook_help_postal' => "
    <ol>
      <li>Inicia sesión en la interfaz web de Postal</li>
      <li>Ve a <b>Organización > Servidor de Correo</b></li>
      <li>Haz clic en <b>Webhooks</b></li>
      <li>Haz clic en <b>Crear Webhook</b></li>
    </ol>
    <h6>Completa el formulario del webhook:</h6>
    <ol>
      <li><b>Nombre:</b> Relayzo Bounce Handler</li>
      <li><b>URL:</b> Copia la <b>'URL del Webhook'</b> y pégala en el campo <b>'URL'</b></li>
      <li><b>Habilitado:</b> Sí – enviar solicitudes a este webhook</li>
      <li><b>Eventos:</b> Marca los eventos que deseas escuchar: <b>MessageDeliveryFailed</b>, <b>MessageBounced</b></li>
      <li>Haz clic en <b>Crear Webhook</b></li>
    </ol>",



];
