<?php
return [
  'webhook_help_heading' => 'Traiter les rapports de livraison pour ',

  'gmail_setup_help' => "
    <ol>
      <li><b>Serveur SMTP :</b> smtp.gmail.com</li>
      <li><b>Port SMTP :</b> 465 (SSL), 587 (TLS)</li>
      <li><b>Chiffrement :</b> SSL/TLS</li>
      <li><b>Nom d'utilisateur :</b> Votre adresse Gmail complète (ex. : votrenom@gmail.com)</li>
      <li><b>Mot de passe :</b> Votre mot de passe d'application Gmail (voir ci-dessous)</li>
    </ol>
    <h5>Important : Utilisez un mot de passe d'application</h5>
    <p>Google ne permet plus les applications moins sécurisées. Vous devez :</p>
    <ol>
      <li>Activer la vérification en 2 étapes sur votre compte Gmail.</li>
      <li>Allez sur <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>Mots de passe d'application</a>.</li>
      <li>Générez un mot de passe d'application (par exemple, pour \"Mail\" et \"Autre (nom personnalisé)\").</li>
      <li>Utilisez ce mot de passe à 16 caractères comme mot de passe SMTP.</li>
    </ol>",

    'microsoft_setup_help' => "
    <ol>
      <li><b>Serveur SMTP :</b> smtp.office365.com</li>
      <li><b>Port SMTP :</b> 587</li>
      <li><b>Chiffrement :</b> TLS</li>
      <li><b>Nom d'utilisateur :</b> Votre adresse e-mail Microsoft complète (ex. : vous@votredomaine.com)</li>
      <li><b>Mot de passe :</b> Votre mot de passe de compte Microsoft ou mot de passe d'application (voir ci-dessous)</li>
    </ol>
    <h5>Si vous utilisez l'authentification multi-facteurs (MFA)</h5>
    <p>Vous devez utiliser un mot de passe d'application :</p>
    <ol>
      <li>Allez sur <a href='https://security.microsoft.com' target='_blank' class='link-info'>Sécurité Microsoft</a>.</li>
      <li>Sous \"<b>Informations de sécurité</b>\" > \"<b>Ajouter une méthode</b>\" > choisissez Mot de passe d'application.</li>
      <li>Générez le mot de passe et utilisez-le dans votre configuration SMTP.</li>
    </ol>",


  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>Connectez-vous</a> à votre compte Mailgun</li>
      <li>Accédez à <b>Envoyer >> Webhooks</b></li>
      <li>Cliquez sur <b>'Ajouter un Webhook'</b></li>
      <li>Sélectionnez le <b>'Type d'événement'</b> (Échec permanent, Échec temporaire, Plaintes pour spam)</li>
      <li>Copiez l'URL du Webhook et collez-la dans le champ 'URL'
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>Connectez-vous</a> à votre compte Sparkpost</li>
      <li>Cliquez sur <b>Webhooks</b></li>
      <li>Entrez le nom du Webhook</li>
      <li>Copiez l'<b>URL du Webhook</b> et collez-la dans le champ <b>'URL cible'</b></li>
      <li>Sélectionnez les événements <b>Rebond</b>, <b>Plaintes pour spam</b></li>
      <li>Sélectionnez <b>'Type d'authentification'</b> sur <b>Auth de base</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>Connectez-vous</a> à votre compte SendGrid</li>
      <li>Accédez à <b>Paramètres >> Paramètres de messagerie</b></li>
      <li>Activez le Webhook d'événements, sélectionnez toutes les actions et insérez l'URL du Webhook</li>
    </ol>",

    'webhook_help_amazon_ses' => "
    <b>Configurer Amazon SES pour envoyer les informations de rebond/plaintes à Amazon SNS</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>Connectez-vous</a> à la console Amazon SES</li>
      <li>Cliquez sur <strong>Configuration Sets</strong></li>
      <li>Cliquez sur le bouton <strong>'Créer un ensemble de configurations'</strong> et définissez un nom, par exemple <strong>Relayzo-Reports</strong>. (<strong>Remarque :</strong> Ce nom sera utilisé plus tard dans Relayzo)</li>
      <li>Cliquez sur l'ensemble de configurations récemment créé</li>
      <li>Dans <strong>'Ajouter une destination'</strong>, choisissez <strong>SNS</strong> dans le menu déroulant</li>
      <li>Donnez un nom, par exemple <strong>RelayzoSNS</strong>, et sélectionnez les types d'événements à traiter : 
      <ul>
        <li>Rejet</li>
        <li>Rebond</li>
        <li>Plaintes</li>
        <li>Échec de rendu</li>
      </ul>
      </li>
      <li>Dans le menu déroulant Topic, sélectionnez <strong>'Créer un sujet SNS'</strong></li>
      <li>Définissez un <strong>Nom de sujet</strong> comme <strong>Relayzo-SNS-Topic</strong> et un <strong>Nom d'affichage</strong></li>
      <li>Appuyez sur <strong>Enregistrer</strong></li>
    </ol>
    <br>
    <b>Créer un sujet et un abonnement dans Amazon SNS</b>
    <ol>
      <li>Accédez maintenant à <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon Simple Notification Service (SNS)</a></li>
      <li><strong>Accédez</strong> aux Sujets</li>
      <li>Cliquez sur le <strong>sujet récemment créé</strong></li>
      <li>Cliquez sur le bouton <strong>'Créer un abonnement'</strong></li>
      <li>Utilisez le protocole correct, c'est-à-dire <strong>HTTP ou HTTPS</strong></li>
      <li>Pour <b>Point de terminaison</b>, entrez l'URL du Webhook : <strong>APP_URL/callback/amazon</strong> affichée dans Relayzo.</li>
      <li>Choisissez <b>Créer un abonnement</b>.</li>
      <li>Sélectionnez l'abonnement créé <b>ex. Relayzo-SNS</b>, puis cliquez sur <b>Demander une confirmation</b></li>
      <li><b>Ouvrez</b> un fichier depuis <b> <a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>Copiez</b> tout le contenu du fichier</li>
      <li><b>Collez</b>-le dans l'URL du navigateur dans une nouvelle fenêtre. Une fois que vous voyez le message de confirmation au format <strong>XML</strong>, cela signifie que la confirmation a réussi !</li>
    </ol>

    <h6>Tout est prêt maintenant. Copiez le <strong>Nom de l'ensemble de configurations</strong>, par exemple <strong>Relayzo-Reports</strong>, que vous avez récemment créé et collez-le dans <strong>Nom de l'ensemble de configurations</strong>.<h6>",

    'schedule_speed' => 'Gérez la vitesse d\'envoi de ce déclencheur. En cas de "Illimité", le système tente d\'envoyer autant que possible dans le temps le plus court possible en utilisant les ressources disponibles.',

    'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>Connectez-vous</a> à votre compte ElasticEmail</li>
      <li>Allez dans <strong>Paramètres → Webhooks</strong> depuis le tableau de bord Elastic Email.</li>
      <li>Cliquez sur <strong>'Gérer le Webhook'</strong></li>
      <li>Nom du Webhook : par exemple, Relayzo Events</li>
      <li>Copiez l’<b>'URL du Webhook'</b> et collez-la dans le champ <b>'URL'</b></li>
      <li>Événements : sélectionnez ceux que vous souhaitez (rebond, plainte, etc.)</li>
      <li>Format des données : choisissez POST (application/json)</li>
    </ol>",

    'webhook_help_postal' => "
    <ol>
      <li>Connectez-vous à l’interface web de Postal</li>
      <li>Allez dans <b>Organisation > Serveur de messagerie</b></li>
      <li>Allez dans <b>Webhooks</b></li>
      <li>Cliquez sur <b>Créer un webhook</b></li>
    </ol>
    <h6>Remplissez le formulaire du webhook :</h6>
    <ol>
      <li><b>Nom :</b> Relayzo Bounce Handler</li>
      <li><b>URL :</b> Copiez l’<b>URL du webhook</b> et collez-la dans le champ <b>URL</b></li>
      <li><b>Activé :</b> Oui – envoyer des requêtes à ce webhook</li>
      <li><b>Événements :</b> Cochez les événements à écouter : <b>MessageDeliveryFailed</b>, <b>MessageBounced</b></li>
      <li>Cliquez sur <b>Créer un webhook</b></li>
    </ol>",


];
