<?php

return [

   /*
|--------------------------------------------------------------------------
| Lignes de Langue pour la Validation
|--------------------------------------------------------------------------
|
| Les lignes de langue suivantes contiennent les messages d'erreur par défaut 
| utilisés par la classe de validation. Certaines de ces règles ont plusieurs 
| versions, comme les règles de taille. N'hésitez pas à modifier ces messages.
|
*/

'accepted' => 'Le champ :attribute doit être accepté.',
'accepted_if' => 'Le champ :attribute doit être accepté lorsque :other est :value.',
'active_url' => 'Le champ :attribute doit être une URL valide.',
'after' => 'Le champ :attribute doit être une date après :date.',
'after_or_equal' => 'Le champ :attribute doit être une date après ou égale à :date.',
'alpha' => 'Le champ :attribute ne doit contenir que des lettres.',
'alpha_dash' => 'Le champ :attribute ne doit contenir que des lettres, chiffres, tirets et underscores.',
'alpha_num' => 'Le champ :attribute ne doit contenir que des lettres et des chiffres.',
'array' => 'Le champ :attribute doit être un tableau.',
'ascii' => 'Le champ :attribute ne doit contenir que des caractères alphanumériques à un seul octet et des symboles.',
'before' => 'Le champ :attribute doit être une date avant :date.',
'before_or_equal' => 'Le champ :attribute doit être une date avant ou égale à :date.',
'between' => [
    'array' => 'Le champ :attribute doit contenir entre :min et :max éléments.',
    'file' => 'Le champ :attribute doit être entre :min et :max kilo-octets.',
    'numeric' => 'Le champ :attribute doit être entre :min et :max.',
    'string' => 'Le champ :attribute doit contenir entre :min et :max caractères.',
],
'boolean' => 'Le champ :attribute doit être vrai ou faux.',
'can' => 'Le champ :attribute contient une valeur non autorisée.',
'confirmed' => 'La confirmation du champ :attribute ne correspond pas.',
'contains' => 'Le champ :attribute doit contenir une valeur requise.',
'current_password' => 'Le mot de passe est incorrect.',
'date' => 'Le champ :attribute doit être une date valide.',
'date_equals' => 'Le champ :attribute doit être une date égale à :date.',
'date_format' => 'Le champ :attribute doit correspondre au format :format.',
'decimal' => 'Le champ :attribute doit avoir :decimal décimales.',
'declined' => 'Le champ :attribute doit être refusé.',
'declined_if' => 'Le champ :attribute doit être refusé lorsque :other est :value.',
'different' => 'Le champ :attribute et :other doivent être différents.',
'digits' => 'Le champ :attribute doit contenir :digits chiffres.',
'digits_between' => 'Le champ :attribute doit contenir entre :min et :max chiffres.',
'dimensions' => 'Le champ :attribute a des dimensions d’image non valides.',
'distinct' => 'Le champ :attribute a une valeur en double.',
'doesnt_end_with' => 'Le champ :attribute ne doit pas se terminer par l’une des valeurs suivantes : :values.',
'doesnt_start_with' => 'Le champ :attribute ne doit pas commencer par l’une des valeurs suivantes : :values.',
'email' => 'Le champ :attribute doit être une adresse e-mail valide.',
'ends_with' => 'Le champ :attribute doit se terminer par l’une des valeurs suivantes : :values.',
'enum' => 'La valeur sélectionnée pour :attribute est invalide.',
'exists' => 'La valeur sélectionnée pour :attribute est invalide.',
'extensions' => 'Le champ :attribute doit avoir l’une des extensions suivantes : :values.',
'file' => 'Le champ :attribute doit être un fichier.',
'filled' => 'Le champ :attribute doit contenir une valeur.',
'gt' => [
    'array' => 'Le champ :attribute doit contenir plus de :value éléments.',
    'file' => 'Le champ :attribute doit être supérieur à :value kilo-octets.',
    'numeric' => 'Le champ :attribute doit être supérieur à :value.',
    'string' => 'Le champ :attribute doit contenir plus de :value caractères.',
],
'gte' => [
    'array' => 'Le champ :attribute doit contenir au moins :value éléments.',
    'file' => 'Le champ :attribute doit être supérieur ou égal à :value kilo-octets.',
    'numeric' => 'Le champ :attribute doit être supérieur ou égal à :value.',
    'string' => 'Le champ :attribute doit contenir au moins :value caractères.',
],
'hex_color' => 'Le champ :attribute doit être une couleur hexadécimale valide.',
'image' => 'Le champ :attribute doit être une image.',
'in' => 'La valeur sélectionnée pour :attribute est invalide.',
'in_array' => 'Le champ :attribute doit exister dans :other.',
'integer' => 'Le champ :attribute doit être un entier.',
'ip' => 'Le champ :attribute doit être une adresse IP valide.',
'ipv4' => 'Le champ :attribute doit être une adresse IPv4 valide.',
'ipv6' => 'Le champ :attribute doit être une adresse IPv6 valide.',
'json' => 'Le champ :attribute doit être une chaîne JSON valide.',
'list' => 'Le champ :attribute doit être une liste.',
'lowercase' => 'Le champ :attribute doit être en minuscules.',
'lt' => [
    'array' => 'Le champ :attribute doit contenir moins de :value éléments.',
    'file' => 'Le champ :attribute doit être inférieur à :value kilo-octets.',
    'numeric' => 'Le champ :attribute doit être inférieur à :value.',
    'string' => 'Le champ :attribute doit contenir moins de :value caractères.',
],
'lte' => [
    'array' => 'Le champ :attribute ne doit pas contenir plus de :value éléments.',
    'file' => 'Le champ :attribute doit être inférieur ou égal à :value kilo-octets.',
    'numeric' => 'Le champ :attribute doit être inférieur ou égal à :value.',
    'string' => 'Le champ :attribute doit contenir au plus :value caractères.',
],
'mac_address' => 'Le champ :attribute doit être une adresse MAC valide.',
'max' => [
    'array' => 'Le champ :attribute ne doit pas contenir plus de :max éléments.',
    'file' => 'Le champ :attribute ne doit pas dépasser :max kilo-octets.',
    'numeric' => 'Le champ :attribute ne doit pas dépasser :max.',
    'string' => 'Le champ :attribute ne doit pas dépasser :max caractères.',
],
'max_digits' => 'Le champ :attribute ne doit pas contenir plus de :max chiffres.',
'mimes' => 'Le champ :attribute doit être un fichier de type : :values.',
'mimetypes' => 'Le champ :attribute doit être un fichier de type : :values.',
'min' => [
    'array' => 'Le champ :attribute doit contenir au moins :min éléments.',
    'file' => 'Le champ :attribute doit être d’au moins :min kilo-octets.',
    'numeric' => 'Le champ :attribute doit être d’au moins :min.',
    'string' => 'Le champ :attribute doit contenir au moins :min caractères.',
],
'min_digits' => 'Le champ :attribute doit contenir au moins :min chiffres.',
'missing' => 'Le champ :attribute doit être manquant.',
'missing_if' => 'Le champ :attribute doit être manquant lorsque :other est :value.',
'missing_unless' => 'Le champ :attribute doit être manquant sauf si :other est :value.',
'missing_with' => 'Le champ :attribute doit être manquant lorsque :values est présent.',
'missing_with_all' => 'Le champ :attribute doit être manquant lorsque :values sont présents.',
'multiple_of' => 'Le champ :attribute doit être un multiple de :value.',
'not_in' => 'La valeur sélectionnée pour :attribute est invalide.',
'not_regex' => 'Le format du champ :attribute est invalide.',
'numeric' => 'Le champ :attribute doit être un nombre.',
'password' => [
    'letters' => 'Le champ :attribute doit contenir au moins une lettre.',
    'mixed' => 'Le champ :attribute doit contenir au moins une lettre majuscule et une lettre minuscule.',
    'numbers' => 'Le champ :attribute doit contenir au moins un chiffre.',
    'symbols' => 'Le champ :attribute doit contenir au moins un symbole.',
    'uncompromised' => 'Le champ :attribute a été compromis dans une fuite de données. Veuillez choisir un autre :attribute.',
],
'present' => 'Le champ :attribute doit être présent.',
'present_if' => 'Le champ :attribute doit être présent lorsque :other est :value.',
'present_unless' => 'Le champ :attribute doit être présent sauf si :other est :value.',
'present_with' => 'Le champ :attribute doit être présent lorsque :values est présent.',
'present_with_all' => 'Le champ :attribute doit être présent lorsque :values sont présents.',
'prohibited' => 'Le champ :attribute est interdit.',
'prohibited_if' => 'Le champ :attribute est interdit lorsque :other est :value.',
'prohibited_unless' => 'Le champ :attribute est interdit sauf si :other est dans :values.',
'prohibits' => 'Le champ :attribute interdit la présence de :other.',
'regex' => 'Le format du champ :attribute est invalide.',
'required' => 'Le champ :attribute est obligatoire.',
'required_array_keys' => 'Le champ :attribute doit contenir des entrées pour : :values.',
'required_if' => 'Le champ :attribute est obligatoire lorsque :other est :value.',
'required_if_accepted' => 'Le champ :attribute est obligatoire lorsque :other est accepté.',
'required_if_declined' => 'Le champ :attribute est obligatoire lorsque :other est refusé.',
'required_unless' => 'Le champ :attribute est obligatoire sauf si :other est dans :values.',
'required_with' => 'Le champ :attribute est obligatoire lorsque :values est présent.',
'required_with_all' => 'Le champ :attribute est obligatoire lorsque :values sont présents.',
'required_without' => 'Le champ :attribute est obligatoire lorsque :values n’est pas présent.',
'required_without_all' => 'Le champ :attribute est obligatoire lorsque aucun des :values n’est présent.',
'same' => 'Le champ :attribute doit correspondre à :other.',
'size' => [
    'array' => 'Le champ :attribute doit contenir :size éléments.',
    'file' => 'Le champ :attribute doit être de :size kilo-octets.',
    'numeric' => 'Le champ :attribute doit être :size.',
    'string' => 'Le champ :attribute doit contenir :size caractères.',
],
'starts_with' => 'Le champ :attribute doit commencer par l’une des valeurs suivantes : :values.',
'string' => 'Le champ :attribute doit être une chaîne de caractères.',
'timezone' => 'Le champ :attribute doit être un fuseau horaire valide.',
'unique' => 'Le champ :attribute a déjà été pris.',
'uploaded' => 'Le téléchargement du fichier :attribute a échoué.',
'uppercase' => 'Le champ :attribute doit être en majuscules.',
'url' => 'Le champ :attribute doit être une URL valide.',
'ulid' => 'Le champ :attribute doit être un ULID valide.',
'uuid' => 'Le champ :attribute doit être un UUID valide.',

/*
|--------------------------------------------------------------------------
| Lignes de Validation Personnalisées
|--------------------------------------------------------------------------
|
| Ici, vous pouvez spécifier des messages de validation personnalisés pour 
| les attributs en utilisant la convention "attribut.règle" pour nommer 
| les lignes. Cela permet de définir rapidement un message spécifique pour 
| une règle d’attribut donnée.
|
*/

'custom' => [
    'nom-attribut' => [
        'nom-règle' => 'message-personnalisé',
    ],
],

/*
|--------------------------------------------------------------------------
| Attributs de Validation Personnalisés
|--------------------------------------------------------------------------
|
| Les lignes de langage suivantes sont utilisées pour remplacer notre 
| espace réservé d’attribut par quelque chose de plus lisible, 
| comme "Adresse E-Mail" au lieu de "email". Cela aide à rendre 
| nos messages plus expressifs.
|
*/

'attributes' => [],


];
