<?php
return [
  'webhook_help_heading' => 'Elabora i report di consegna per ',

  'gmail_setup_help' => "
    <ol>
      <li><b>Server SMTP:</b> smtp.gmail.com</li>
      <li><b>Porta SMTP:</b> 465 (SSL), 587 (TLS)</li>
      <li><b>Crittografia:</b> SSL/TLS</li>
      <li><b>Nome utente:</b> Il tuo indirizzo Gmail completo (es. tuonome@gmail.com)</li>
      <li><b>Password:</b> La tua Password per le App di Gmail (vedi sotto)</li>
    </ol>
    <h5>Importante: Usa una Password per le App</h5>
    <p>Google non consente più le app meno sicure. Devi:</p>
    <ol>
      <li>Abilitare la verifica in 2 passaggi sul tuo account Gmail.</li>
      <li>Vai a <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>Password per le app</a>.</li>
      <li>Genera una password per l’app (es. per \"Mail\" e \"Altro (nome personalizzato)\").</li>
      <li>Usa quella password di 16 caratteri come password SMTP.</li>
    </ol>",

  'microsoft_setup_help' => "
    <ol>
      <li><b>Server SMTP:</b> smtp.office365.com</li>
      <li><b>Porta SMTP:</b> 587</li>
      <li><b>Crittografia:</b> TLS</li>
      <li><b>Nome utente:</b> Il tuo indirizzo email Microsoft completo (es. tu@tuodominio.com)</li>
      <li><b>Password:</b> La password del tuo account Microsoft o una Password per le App (vedi sotto)</li>
    </ol>
    <h5>Se usi MFA (Autenticazione a più fattori)</h5>
    <p>Devi usare una Password per le App:</p>
    <ol>
      <li>Vai a <a href='https://security.microsoft.com' target='_blank' class='link-info'>Microsoft Security</a>.</li>
      <li>Sotto \"<b>Informazioni di sicurezza</b>\" > \"<b>Aggiungi metodo</b>\" > scegli Password per app.</li>
      <li>Genera e usa quella password nella tua configurazione SMTP.</li>
    </ol>",

  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>Accedi</a> al tuo account Mailgun</li>
      <li>Vai su <b>Send >> Webhooks</b></li>
      <li>Clicca su <b>'Add Webhook'</b></li>
      <li>Seleziona il <b>'Tipo di evento'</b> (Errore permanente, Errore temporaneo, Reclami di spam)</li>
      <li>Copia la 'Webhook URL' e incollala nel campo 'URL'</li>
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>Accedi</a> al tuo account Sparkpost</li>
      <li>Clicca su <b> Webhooks</b></li>
      <li>Inserisci il nome del Webhook</li>
      <li>Copia la <b>'Webhook URL'</b> e incollala nel <b>'Target URL'</b></li>
      <li>Seleziona gli eventi <b>Bounce</b>, <b>Reclami di spam</b></li>
      <li>Seleziona <b>'Tipo di autenticazione'</b> come <b>Basic Auth</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>Accedi</a> al tuo account SendGrid</li>
      <li>Vai su <b>Impostazioni >> Impostazioni email</b></li>
      <li>Attiva Event Webhook, seleziona tutte le azioni e inserisci la 'Webhook URL'</li>
    </ol>",

  'webhook_help_amazon_ses' => "
    <b>Configura Amazon SES per inviare informazioni su bounce/reclami ad Amazon SNS</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>Accedi</a> alla console Amazon SES</li>
      <li>Clicca su <strong>Configuration Sets</strong></li>
      <li>Clicca sul pulsante <strong>'Create Configuration Set'</strong> e definisci un nome es. <strong>Relayzo-Reports</strong>. (<strong>Nota:</strong> Questo nome sarà usato successivamente in Relayzo)</li>
      <li>Clicca sul Configuration Set appena creato</li>
      <li>In <strong>'Add Destination'</strong> scegli <strong>SNS</strong> dal menu a tendina</li>
      <li>Scrivi un nome es. <strong>RelayzoSNS</strong> e seleziona i tipi di eventi da elaborare. 
      <ul>
        <li>Reject</li>
        <li>Bounce</li>
        <li>Complaint</li>
        <li>Rendering Failure</li>
      </ul>
      </li>
      <li>Dal menu Topic seleziona <strong>'Create SNS Topic'</strong></li>
      <li>Definisci un <strong>Nome Topic</strong> es. <strong>Relayzo-SNS-Topic</strong> e un <strong>Nome visualizzato</strong></li>
      <li>Premi <strong>Salva</strong></li>
    </ol>
    <br>
    <b>Crea un topic e una sottoscrizione in Amazon SNS</b>
    <ol>
      <li>Ora vai su <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon Simple Notification Service (SNS)</a></li>
      <li><strong>Vai</strong> su Topics</li>
      <li>Clicca sul topic <strong>appena creato</strong></li>
      <li>Clicca sul pulsante <strong>'Create Subscription'</strong></li>
      <li>Usa il protocollo corretto cioè <strong>HTTP o HTTPS</strong></li>
      <li>Per <b>Endpoint</b>, inserisci la Webhook URL: <strong>APP_URL/callback/amazon</strong> mostrata in Relayzo.</li>
      <li>Scegli <b>Create subscription</b>.</li>
      <li>Seleziona la sottoscrizione creata <b>es. Relayzo-SNS</b> e clicca <b>Request Confirmation</b></li>
      <li><b>Apri</b> il file da <b> <a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>Copia</b> tutto il contenuto del file</li>
      <li><b>Incollalo</b> nella barra degli indirizzi del browser in una nuova finestra. Una volta visualizzato il messaggio di conferma in <strong>formato XML</strong>, significa che la conferma è andata a buon fine!</li>
    </ol>

    <h6>Ora è tutto pronto. Copia il <strong>Configuration Set Name</strong> es. <strong>Relayzo-Reports</strong> che hai creato e
    incollalo in <strong>Configuration Set Name</strong>.<h6>",

  'schedule_speed' => 'Gestisci la velocità di invio di questo trigger. In caso di \"Illimitato\", il sistema tenterà di inviare il più possibile nel minor tempo disponibile, utilizzando le risorse disponibili.',

  'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>Accedi</a> al tuo account ElasticEmail</li>
      <li>Vai su <strong>Impostazioni → Webhooks</strong> nella tua dashboard di Elastic Email.</li>
      <li>Clicca su <strong>'Gestisci Webhook'</strong></li>
      <li>Nome Webhook: es. Relayzo Events</li>
      <li>Copia la <b>'Webhook URL'</b> e incollala nel campo <b>'URL'</b></li>
      <li>Eventi: scegli quelli che desideri (bounce, reclamo, ecc.)</li>
      <li>Formato dati: scegli POST (application/json)</li>
    </ol>",

  'webhook_help_postal' => "
    <ol>
      <li>Accedi alla tua interfaccia web Postal</li>
      <li>Vai su <b>Organization > Mail Server</b></li>
      <li>Vai su <b>Webhooks</b></li>
      <li>Clicca su <b>Create Webhook</b></li>
    </ol>
    <h6>Compila il modulo webhook:</h6>
    <ol>
      <li><b>Nome:</b> Relayzo Bounce Handler</li>
      <li><b>URL:</b> Copia la <b>'Webhook URL'</b> e incollala nel campo <b>'URL'</b></li>
      <li><b>Abilitato:</b> Sì - invia richieste a questo webhook</li>
      <li><b>Eventi:</b> Seleziona gli eventi che vuoi monitorare: <b>MessageDeliveryFailed</b>, <b>MessageBounced</b></li>
      <li>Clicca su <b>Create Webhook</b></li>
    </ol>",
];
