<?php
return [
  'webhook_help_heading' => '处理投递报告 ',

  'gmail_setup_help' => "
    <ol>
      <li><b>SMTP 服务器：</b> smtp.gmail.com</li>
      <li><b>SMTP 端口：</b> 465 (SSL)，587 (TLS)</li>
      <li><b>加密：</b> SSL/TLS</li>
      <li><b>用户名：</b> 您的完整 Gmail 地址（例如，yourname@gmail.com）</li>
      <li><b>密码：</b> 您的 Gmail 应用密码（见下文）</li>
    </ol>
    <h5>重要：使用应用密码</h5>
    <p>Google 不再允许使用不安全的应用程序。您必须：</p>
    <ol>
      <li>在您的 Gmail 帐户上启用两步验证。</li>
      <li>转到 <a href='https://myaccount.google.com/apppasswords' target='_blank' class='link-info'>应用密码</a>。</li>
      <li>生成应用密码（例如，用于 \"Mail\" 和 \"其他（自定义名称）\"）。</li>
      <li>将此 16 位密码用作您的 SMTP 密码。</li>
    </ol>",

    'microsoft_setup_help' => "
    <ol>
      <li><b>SMTP 服务器：</b> smtp.office365.com</li>
      <li><b>SMTP 端口：</b> 587</li>
      <li><b>加密：</b> TLS</li>
      <li><b>用户名：</b> 您的完整 Microsoft 电子邮件地址（例如，you@yourdomain.com）</li>
      <li><b>密码：</b> 您的 Microsoft 帐户密码或应用密码（见下文）</li>
    </ol>
    <h5>如果您使用 MFA（多因素认证）</h5>
    <p>您必须使用应用密码：</p>
    <ol>
      <li>转到 <a href='https://security.microsoft.com' target='_blank' class='link-info'>Microsoft 安全</a>。</li>
      <li>在 “<b>安全信息</b>” > “<b>添加方法</b>” 下选择应用密码。</li>
      <li>生成密码并在您的 SMTP 设置中使用它。</li>
    </ol>",


  'webhook_help_mailgun' => "
    <ol>
      <li><a href='https://login.mailgun.com/login/' target='_blank' class='link-info'>登录</a> 到您的 Mailgun 账户</li>
      <li>进入 <b>发送 >> Webhooks</b></li>
      <li>点击 <b>'添加 Webhook'</b></li>
      <li>选择 <b>'事件类型'</b>（永久失败、临时失败、垃圾邮件投诉）</li>
      <li>复制 'Webhook URL' 并粘贴到 'URL'</li>
    </ol>",

  'webhook_help_sparkpost' => "
    <ol>
      <li><a href='https://app.sparkpost.com/auth' target='_blank' class='link-info'>登录</a> 到您的 Sparkpost 账户</li>
      <li>点击 <b>Webhooks</b></li>
      <li>输入 Webhook 名称</li>
      <li>复制 <b>'Webhook URL'</b> 并粘贴到 <b>'目标 URL'</b></li>
      <li>选择事件 <b>退信</b>、<b>垃圾邮件投诉</b></li>
      <li>选择 <b>'认证类型'</b> 为 <b>基本认证</b></li>
    </ol>",

  'webhook_help_sendgrid' => "
    <ol>
      <li><a href='https://app.sendgrid.com/login/' target='_blank' class='link-info'>登录</a> 到您的 SendGrid 账户</li>
      <li>进入 <b>设置 >> 邮件设置</b></li>
      <li>启用事件 Webhook，选择所有操作并插入 'Webhook URL'</li>
    </ol>",

  'webhook_help_amazon_ses' => "
    <b>配置 Amazon SES 以将退信/投诉信息发送到 Amazon SNS</b>
    <ol>
      <li><a href='https://console.aws.amazon.com/ses/' target='_blank' class='link-info'>登录</a> 到 Amazon SES 控制台</li>
      <li>点击 <strong>配置集</strong></li>
      <li>点击 <strong>'创建配置集'</strong> 按钮并定义名称，例如 <strong>Relayzo-Reports</strong>。（<strong>注意：</strong> 此配置集名称将在 Relayzo 内部使用）</li>
      <li>点击最近创建的配置集</li>
      <li>在 <strong>'添加目标'</strong> 选择 <strong>SNS</strong> 作为目标类型</li>
      <li>输入名称，例如 <strong>RelayzoSNS</strong>，然后选择要处理的事件类型：
      <ul>
        <li>拒收</li>
        <li>退信</li>
        <li>投诉</li>
        <li>渲染失败</li>
      </ul>
      </li>
      <li>在主题下拉菜单中，选择 <strong>'创建 SNS 主题'</strong></li>
      <li>定义 <strong>主题名称</strong>（例如 <strong>Relayzo-SNS-Topic</strong>）和 <strong>显示名称</strong></li>
      <li>点击 <strong>保存</strong></li>
    </ol>
    <br>
    <b>在 Amazon SNS 中创建主题和订阅</b>
    <ol>
      <li>现在转到 <a href='https://console.aws.amazon.com/sns/v3' target='_blank' class='link-info'>Amazon 简单通知服务（SNS）</a></li>
      <li><strong>导航</strong> 至 主题</li>
      <li>点击 <strong>最近创建的</strong> 主题</li>
      <li>点击 <strong>'创建订阅'</strong> 按钮</li>
      <li>选择正确的协议，例如 <strong>HTTP 或 HTTPS</strong></li>
      <li>在 <b>端点</b> 中输入 Webhook URL：<strong>APP_URL/callback/amazon</strong>，此 URL 在 Relayzo 内部可见。</li>
      <li>点击 <b>创建订阅</b></li>
      <li>选择已创建的订阅，例如 <b>Relayzo-SNS</b>，然后点击 <b>请求确认</b></li>
      <li><b>打开</b> 文件 <b><a href='APP_URL/storage/amazonsns.txt' target='_blank' class='link-info'>APP_URL/storage/amazonsns.txt</a></b></li>
      <li><b>复制</b> 文件的全部内容</li>
      <li><b>粘贴</b> 到浏览器的新窗口中，看到 XML 格式的确认消息，即表示确认成功！</li>
    </ol>

    <h6>现在一切就绪。请复制您最近创建的 <strong>配置集名称</strong>，例如 <strong>Relayzo-Reports</strong>，然后粘贴到 <strong>配置集名称</strong> 字段中。</h6>",

    'schedule_speed' => '管理此触发器的发送速度。选择 "无限制" 时，系统将尽可能快地发送邮件，充分利用可用资源。',

    'webhook_help_elastic_email' => "
    <ol>
      <li><a href='https://elasticemail.com' target='_blank' class='link-info'>登录</a>您的 ElasticEmail 账户</li>
      <li>进入 <strong>设置 → Webhooks</strong>，在 Elastic Email 控制面板中</li>
      <li>点击 <strong>“管理 Webhook”</strong></li>
      <li>Webhook 名称：例如 Relayzo Events</li>
      <li>复制<b>“Webhook URL”</b>并粘贴到<b>“URL”</b>字段中</li>
      <li>事件：选择您需要的（退信、投诉等）</li>
      <li>数据格式：选择 POST（application/json）</li>
    </ol>",

    'webhook_help_postal' => "
    <ol>
      <li>登录到您的 Postal 网络界面</li>
      <li>进入 <b>组织 > 邮件服务器</b></li>
      <li>进入 <b>Webhooks</b> 页面</li>
      <li>点击 <b>创建 Webhook</b></li>
    </ol>
    <h6>填写 Webhook 表单：</h6>
    <ol>
      <li><b>名称：</b> Relayzo Bounce Handler</li>
      <li><b>URL：</b> 复制 <b>'Webhook URL'</b> 并粘贴到 <b>'URL'</b> 字段</li>
      <li><b>启用：</b> 是 — 向此 Webhook 发送请求</li>
      <li><b>事件：</b> 选择您想监听的事件：<b>MessageDeliveryFailed</b>，<b>MessageBounced</b></li>
      <li>点击 <b>创建 Webhook</b></li>
    </ol>",



];
