$(function () {
  'use strict';
  
  // Ensure Swal (SweetAlert2) is available
  // Wait for SweetAlert2 to load if it's not immediately available
  if (typeof Swal === 'undefined' && typeof window.Swal === 'undefined') {
    // Try to wait for SweetAlert2 to load
    var checkSwal = setInterval(function() {
      if (typeof Swal !== 'undefined' || typeof window.Swal !== 'undefined') {
        clearInterval(checkSwal);
      }
    }, 100);
    
    // Stop checking after 5 seconds
    setTimeout(function() {
      clearInterval(checkSwal);
    }, 5000);
  }
  $(".btn-loading").on('click', function() {
    $(this).find("i").addClass("spinner-border spinner-border-sm align-middle");
  });
  $("#checkAll").on('click', function() {
    $('input:checkbox').not(this).prop('checked', this.checked);
  });

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission if there are invalid fields
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()

          // remove button loader
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        }

        form.classList.add('was-validated')
      }, false)
    })

  $('.select-all').on('click', function() {
    if($(this).is(':checked')) {
      $('.'+this.value).prop('checked', true);
    } else {
      $('.'+this.value).prop('checked', false);
    }
  });

  // Initialize Select2 with retry mechanism
  function initializeSelect2() {
    if (typeof $.fn.select2 !== 'undefined') {
      $(".single-select").each(function() {
        var $select = $(this);
        // Skip if already initialized or if it's growth_factor (handled separately in modal)
        if (!$select.hasClass('select2-hidden-accessible') && $select.attr('id') !== 'growth_factor') {
          $select.select2({
            dir: "ltr",
            minimumResultsForSearch: Infinity // This disables the search box
          });
        }
      });
    } else {
      // Retry after a short delay if Select2 is not yet loaded
      setTimeout(initializeSelect2, 100);
    }
  }
  
  // Initialize Select2
  initializeSelect2();
    $("#type").change(function () {
      var type = $('#type').val();
      (type == 'radio' || type == 'checkbox' || type == 'dropdown') ? $('#values').show() : $('#values').hide();
    });
    
    $("#option").change(function() {
      var option = $("#option option:selected").val();
      if(option == 'file') {
        $("#data-input-section").show();
        $("#section-emails").hide();
        $("#section-file,#info-filesize").show();
      } else if(option == 'write') {
        $("#data-input-section").show();
        $("#section-emails").show();
        $("#section-file,#info-filesize").hide();
      } else if(option == 'list') {
        // Hide entire data input section when option is 'list'
        $("#data-input-section").hide();
      }
    });

    $("#resource").change(function() {
      var resource = $("#resource option:selected").val();
      if(resource == 'file') {
        $("#section-emails,#btn-save").hide();
        $("#section-file,#info-filesize,#btn-proceed").show();
      } else {
        $("#section-emails,#btn-save").show();
        $("#section-file,#info-filesize,#btn-proceed").hide();
      }
    });

   $('#api-status').on('change', function() {
      $.ajax({
         url: '/api-status',
         method: 'PUT',
         data: {value: $('#api-status').val()},
         success: function(result) {
           if(result) {
             toastr.success('Saved successfully.');
           } else {
             toastr.error('Found some error(s).');
           }
         }
      });
   });
   $('#copy-api-url').on('click', function() {
     document.getElementById("api-base-url").select();
     document.execCommand("copy");
     toastr.success('Copied successfully!');
   });
   $('#copy-api-key').on('click', function() {
     document.getElementById("api-key").select();
     document.execCommand("copy");
     toastr.success('Copied successfully!');
   });
   
  $('#regenerate-api-key').click(function() {
    if (typeof Swal !== 'undefined') {
      Swal.fire({
        title: "",
        text: $('#api_msg_regenerate').data('value'),
        icon: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        cancelButtonText: "Cancel"
      }).then((result) => {
        if (result.isConfirmed) {
          $("#frm-api").submit(); 
        }
      });
    } else {
      // Fallback to SweetAlert v1
      swal({
        title: "",
        text: $('#api_msg_regenerate').data('value'),
        type: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        closeOnConfirm: true
      }, function(isConfirm) {
        if(isConfirm) {
          $("#frm-api").submit(); 
        }
      });
    }
  });

  $("#based-on-trigger").change(function() {
    loadBasedOnData($("#based-on-trigger").val(), 'create');
  });


  $('input[name="from_detail"]').on('change', function () {
    if ($(this).val() === 'custom' && $(this).is(':checked')) {
      // Enable validation for custom email fields
      $('#custom_email_data input, #custom_email_data select').attr('required', true);
      $('#custom_email_data').show(); // Show the div
    } else {
      // Disable validation for custom email fields
      $('#custom_email_data input, #custom_email_data select').removeAttr('required');
      $('#custom_email_data').hide(); // Hide the div
    }
  });

});

$(document).ready(function () {
  $("#btn-verify-list").on('click', function () {
    var id = $('#type-email-verifier').val();
    var list_ids = $('#list_ids').val();

    $.ajax({
      url: '/verify_email_list',
      method: 'POST',
      data: {
        id: id,
        list_ids: list_ids
      },
      beforeSend: function () {
        $(".btn-loading").find("i").addClass("spinner-border spinner-border-sm align-middle");
      },
      success: function (result) {
        toastr.success($('#list_verify_msg').data('route'));
        $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      },
      error: function (result) {
        var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
        $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        return false;
      }
    });
  });

  $("#btn-verify-email").on('click', function() {
    var id = $('#type-email-verifier').val();
    var email = $('#email').val();
    $.ajax({
      url: '/verify_email',
      method: 'POST',
      data: {
        id: id,
        email: email
      },
      beforeSend: function() {
        $('#msg').html('');
        $('#msg').addClass('text-danger');
        $('#msg').removeClass('text-success');
      },
      success: function(result) {
        if(!result.verify) {
          $('#msg').addClass('text-danger');
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        } else {
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
          $('#msg').removeClass('text-danger');
          $('#msg').addClass('text-success');
        }

        if(result.message) {
          $('#msg').html(result.message);
        } else {
          $('#msg').html(result);
        }
      }
    });
  });
});

  function importBulkUpdate(frm) {
    var route = "/list/bulk_update";
    var frm_data = new FormData(frm);
    var $btn = $("#btn-import");
    var $icon = $btn.find("i");
    
    // Show loading spinner
    $icon.removeClass("bi-arrow-repeat").addClass("spinner-border spinner-border-sm");
    
    if($('#file').length){
      var file_data = $('#file').prop('files')[0];
      frm_data.append('file', file_data);
    }

    $.ajax({
      url: route,
      type: 'POST',
      data: frm_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(result) {
        $icon.removeClass("spinner-border spinner-border-sm").addClass("bi-arrow-repeat");
        toastr.success($('#msg_update').data('value'));
      },
      error: function(xhr) {
        $icon.removeClass("spinner-border spinner-border-sm").addClass("bi-arrow-repeat");
        
        if (xhr.status === 401) {
          toastr.error('You do not have permission to perform bulk updates. Please contact your administrator.');
        } else if (xhr.status === 403) {
          toastr.error('Access forbidden. You do not have the required permissions.');
        } else if (xhr.responseJSON && xhr.responseJSON.errors) {
          var errors = xhr.responseJSON.errors;
          for (error in errors) {
            toastr.error(errors[error]);
          }
        } else {
          toastr.error('An error occurred while trying to perform the bulk update. Please try again.');
        }
      }
    });
    return true;
  }

function getAppURL(){
  return window.location.protocol+'//'+window.location.hostname;
}


function destroyMany(route, msg='Are you sure to delete?') {

  if(!$('input:checkbox:checked').length){
   if (typeof Swal !== 'undefined') {
     Swal.fire({title: '',text:"Please select at least one checkbox.", icon: "warning"});
   } else {
     swal({title: '',text:"Please select at least one checkbox."});
   }
   return false;
  }

  var ids = $('input:checkbox:checked').map(function() {
    return this.value;
  }).get();

  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
      url: route,
      method: 'DELETE',
      data: {action: 'many', ids: ids},
      success: function(destroy) {
        //console.log(destroy)
        if(destroy) {
          toastr.success('Deleted successfully.');
          $('input:checkbox:checked').map(function() {
            $('#'+'row_'+this.value).fadeOut();
            $('#data').DataTable().ajax.reload(null, false);
            $("#checkAll").prop('checked', false);
          }).get();
        } else {
          toastr.error('Found some error(s).');
        }
      }
      });
    }
  });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      closeOnConfirm: true
    }, function(){
      $.ajax({
        url: route,
        method: 'DELETE',
        data: {action: 'many', ids: ids},
        success: function(destroy) {
          if(destroy) {
            toastr.success('Deleted successfully.');
            $('input:checkbox:checked').map(function() {
              $('#'+'row_'+this.value).fadeOut();
              $('#data').DataTable().ajax.reload(null, false);
              $("#checkAll").prop('checked', false);
            }).get();
          } else {
            toastr.error('Found some error(s).');
          }
        }
      });
    });
  }
}

function destroy(id, route, msg='Are you sure to delete?') {
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        var row_id = '#'+'row_'+id;
    $.ajax({
      url: route,
      method: 'DELETE',
      beforeSend: function() {
      },
      success: function(destroy) {
        if(destroy.success) {
          toastr.success(destroy.message);
          $(row_id).fadeOut();
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          toastr.error(destroy.message);
        }
      }
    });
      }
    });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      closeOnConfirm: true
    }, function(isConfirm) {
      if(isConfirm) {
        var row_id = '#'+'row_'+id;
    $.ajax({
      url: route,
      method: 'DELETE',
      beforeSend: function() {
      },
      success: function(destroy) {
        if(destroy.success) {
          toastr.success(destroy.message);
          $(row_id).fadeOut();
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          toastr.error(destroy.message);
        }
      }
    });
      }
    });
  }
}


// Global function to disable Select2 for group dropdowns
function disableGroupSelect2() {
  $('select[name="group_id"]').each(function() {
    if ($(this).hasClass('select2-hidden-accessible') && typeof $.fn.select2 !== 'undefined') {
      $(this).select2('destroy');
    }
    // Ensure the original select is visible and remove any Select2 classes
    $(this).show().removeClass('select2-hidden-accessible');
    // Remove any Select2 containers that might have been created
    $(this).siblings('.select2-container').remove();
    // Force the select to be visible and functional
    $(this).css({
      'display': 'block',
      'visibility': 'visible',
      'opacity': '1',
      'z-index': '1'
    });
  });
}

// Run on document ready
$(document).ready(function() {
  disableGroupSelect2();
});

// Run on page load and AJAX complete
$(document).on('DOMContentLoaded ajaxComplete', function() {
  disableGroupSelect2();
});

function viewModal(modal, route) {
  $.ajax({
    url: route,
    method: 'GET',
    success: function(result) {
      $('#modal-data').html(result);
      $('#'+modal).modal('show');
      
      // Initialize Select2 for groups move modal after content is loaded
      if (modal === 'modal' && $('#groups-move').length) {
        setTimeout(function() {
          if (!$('#groups-move').hasClass('select2-hidden-accessible') && typeof $.fn.select2 !== 'undefined') {
            $('#groups-move').select2({
              placeholder: 'Select Group',
              allowClear: false,
              width: '100%',
              dropdownParent: $('#modal-group-move .modal-content')
            });
            console.log('Select2 initialized for groups-move dropdown');
          }
        }, 200);
      }
      
      // Disable Select2 for group dropdowns in modals
      setTimeout(function() {
        disableGroupSelect2();
      }, 100);
    }
  });
}


function checkSpamScore(modal, route, data) {
  $.ajax({
    url: route,
    method: 'POST',
    data: {content: data},
    success: function(result) {
      $('#modal-data').html(result);
      $('#'+modal).modal('show');
    }
  });
}

function chatGPT(modal, route, data) {
  $.ajax({
    url: route,
    method: 'POST',
    data: {content: data},
    success: function(result) {
      $('#modal-data').html(result);
      $('#'+modal).modal('show');
    }
  });
}


function suppressionImport(button, frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
          $('#suppression-fields').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
        },
        success: function(result) {
          $('#suppression-fields').html(result);
          $('#btn-import').show();
          $('#btn-proceed').hide();
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doSuppressionImport(button, frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
    },
    success: function(data) {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      toastr.success(data);
    }
  });
  return true;
}

function deleteGroup($this, msg='Are you sure to delete?') {
  var span = $($this).parent().closest('tr').children('td').children('span');
  var id = span.attr('id');
  var group_name = span.html().replace(/(<([^>]+)>)/ig,"");
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Proceed",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
    $('#group-id-old').val(id);
    $('#move-id').val('');
    $('#modal-title-group').html(group_name);
    $('#modal-group-move').modal('show');
    }
  });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Proceed",
      closeOnConfirm: true
    }, function(){
      $('#group-id-old').val(id);
      $('#move-id').val('');
      $('#modal-title-group').html(group_name);
      $('#modal-group-move').modal('show');
    });
  }
}

function eraseGroup($this, route, msg='Are you sure to delete?') {
  var span = $($this).parent().closest('tr').children('td').children('span');
  var id = span.attr('id');
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
    $.ajax({
      method: 'DELETE',
      url: route,
      data: {id: id, action: 'erase'},
      success: function(destroy) {
        if(destroy) {
          toastr.success('Deleted successfully.');
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          toastr.error('Found some error(s).');
        }
      }
    });
    }
  });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Delete",
      closeOnConfirm: true
    }, function(){
      $.ajax({
        method: 'DELETE',
        url: route,
        data: {id: id, action: 'erase'},
        success: function(destroy) {
          if(destroy) {
            toastr.success('Deleted successfully.');
            $('#data').DataTable().ajax.reload(null, false);
          } else {
            toastr.error('Found some error(s).');
          }
        }
      });
    });
  }
}

function moveGroup() {
  var group_id_new = $('#groups-move').val();
  var group_id_old = $('#group-id-old').val();
  var move_id = $('#move-id').val();
  var route = $('#route-group').val();

  $.ajax({
    method: 'DELETE',
    url: route,
    data: {id: group_id_old, group_id_new: group_id_new, move_id: move_id,  action: 'move'},
    success: function(destroy) {
      $('#modal-group-move').modal('hide');
      toastr.success('Moved successfully.');
      $("#btn-move").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $('#data').DataTable().ajax.reload(null, false);
    },
    error: function(result) {
    }
  });
}
function move(id, name) {
  $('#move-id').val(id);
  $('#modal-title-group').html(name);
  $('#modal-group-move').modal('show');
}

function emptyList(id, route, msg='Are you sure to empty?') {
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Empty List",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
    $.ajax({
      url: route,
      method: 'POST',
      beforeSend: function() {
      },
      success: function(result) {
        if(result) {
          toastr.success('Empty successfully.');
        } else {
          toastr.error('Found some error(s).');
        }
      }
    });
    }
  });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Empty List",
      closeOnConfirm: true
    }, function(){
      $.ajax({
        url: route,
        method: 'POST',
        beforeSend: function() {
        },
        success: function(result) {
          if(result) {
            toastr.success('Empty successfully.');
          } else {
            toastr.error('Found some error(s).');
          }
        }
      });
    });
  }
}


function clearCache() {
  $.ajax({
    url: "/clear_cache",
    method: 'GET',
    beforeSend: function() { },
    success: function(result) {
      toastr.success('Cache has been cleared successfully.');
    }
  });
}

function loadListCustomFields(list_id, view=null, custom_field_ids=null) {
  $.ajax({
    url: "/lists-custom-fields",
    method: 'GET',
    data: {list_id: list_id, view: view, custom_field_ids: custom_field_ids},
    beforeSend: function() {
      $('#list_custom_fields').html('<div class="col-md-offset-2 col-md-10"><i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#list_custom_fields').html(result);
    }
  });
}

function loadListCustomFieldsWithData() {
  $.ajax({
    url: "/lists-custom-fields",
    method: 'GET',
    data: {list_id: $('#list-id').val(), contact_id: $('#contact-id').val()},
    beforeSend: function() {
      $('#list_custom_fields').html('<div class="col-md-offset-2 col-md-10"><i class="spinner-border text-dark" aria-hidden="true"></i></i></div>');
    },
    success: function(result) {
      $('#list_custom_fields').html(result);
    }
  });
}

function contactsImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      var list_id = $('#lists').val();
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1, list_id: list_id},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
        },
        success: function(result) {
          $('#btn-proceed').hide();
          $('#list-custom-fields').html(result);          
          $('#btn-import').show();          
          $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doContactsImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
      $("#lists,#duplicates,#active,#confirmed,#verified,#bounced,#suppressed").prop('disabled', true);
      $('.choices').css('pointer-events', 'none');  // Prevent interaction but keep the dropdown visible
      $('.choices').css('cursor', 'not-allowed');   // Show the forbidden cursor on hover
      $('#btn-import').hide();
      $('#fields-mapping').hide();
      $('#import-contacts').show();
    },
    success: function(id) {
      contactsImportStatus(id);
    }
  });
  return true;
}

function contactsImportStatus(id) {
  var route = "/contacts-import-status/"+id;
  $.ajax({
    url: route,
    type: 'GET',
    success: function(result) {
      var obj = JSON.parse(result);
      var percent = (obj.processed/obj.total)*100;
      var percentage = Math.round(percent)+'%';
      $('.progress-bar').width(percentage).html(percentage);
      $('#total').html(obj.total);
      $('#processed').html(obj.processed);
      $('#duplicates-data').html(obj.duplicates);
      $('#invalids').html(obj.invalids);
      $('#suppressed-data').html(obj.suppressed);
      $('#bounced-data').html(obj.bounced);
      if(percent != 100) {
        if(obj.total != obj.processed) setTimeout(contactsImportStatus(id), 5000);
      }
    }
  });
}

function copyShortcode(code){
  var shortcode = document.getElementById("shortcode-textbox");
  shortcode.value = code;
  shortcode.select();
  document.execCommand("copy");
  toastr.success('Copied successfully!');
}

function validateImap(frm, route) {
  var frm_data = $(frm).serialize();
  var $btn = $("#validate-imap");
  var $msg = $("#imap-msg");
  var originalHtml = $btn.html();
  
  $.ajax({
    url: route,
    method: 'GET',
    data: frm_data,
    beforeSend: function() {
      // Clear message span
      $msg.html('');
      
      // Disable button and show spinner on button
      $btn.prop('disabled', true);
      $btn.html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>Validating...');
    },
    success: function(result) {
      // Restore button state
      $btn.prop('disabled', false);
      $btn.html(originalHtml);
      
      // Show result in message span with prominent styling
      $msg.html('<div class="text-center"><div class="alert alert-success d-inline-block mb-0"><i class="bi bi-check-circle-fill me-2"></i>' + result + '</div></div>');
    },
    error: function(xhr, status, error) {
      // Restore button state
      $btn.prop('disabled', false);
      $btn.html(originalHtml);
      
      // Show error message with prominent styling
      $msg.html('<div class="text-center"><div class="alert alert-danger d-inline-block mb-0"><i class="bi bi-exclamation-triangle-fill me-2"></i>Validation failed. Please try again.</div></div>');
    }
  });
}

function domainVerifications(id, type) {
  var route = "/domain_verfications/"+id+"/"+type;
  $.ajax({
    url: route,
    type: 'GET',
    beforeSend: function() {
      if(type=='all' || type=='dkim') {
        $('#key-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='all' || type=='spf') {
        $('#spf-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='all' || type=='dmarc') {
        $('#dmarc-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='tracking') {
        $('#tracking-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
    },
    success: function(data) {
      var obj = JSON.parse(data);
      if(type=='all' || type=='dkim') {
        $('#key-'+id).html(obj.key ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='all' || type=='spf') {
        $('#spf-'+id).html(obj.spf ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='all' || type=='dmarc') {
        $('#dmarc-'+id).html(obj.dmarc ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='tracking') {
        $('#tracking-'+id).html(obj.tracking ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
    }
  });
}

function validateDomain(id) {
  domainVerifications(id, 'all');
  setTimeout(function() {
    $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
  }, 3000); // 5000 milliseconds = 5 seconds
}

function sendEmailTest(frm) {
  // Get email input and validate multiple emails
  var emailInput = $('#email-input');
  var $btn = $('#send-test-email');
  var emails = emailInput.val().trim();
  
  if (!emails) {
    emailInput.addClass('is-invalid');
    toastr.error($btn.data('email-required'));
    return false;
  }
  
  // Split emails by comma and validate each one
  var emailList = emails.split(',').map(function(email) {
    return email.trim();
  }).filter(function(email) {
    return email.length > 0;
  });
  
  // Validate each email
  var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  var invalidEmails = [];
  
  for (var i = 0; i < emailList.length; i++) {
    if (!emailRegex.test(emailList[i])) {
      invalidEmails.push(emailList[i]);
    }
  }
  
  if (invalidEmails.length > 0) {
    emailInput.addClass('is-invalid');
    toastr.error($btn.data('invalid-emails') + ': ' + invalidEmails.join(', '));
    return false;
  }
  
  // Remove invalid class if validation passes
  emailInput.removeClass('is-invalid');
  
  // Get sending server ID
  var sendingServerId = $('#sending_server_ids').val();
  console.log('Sending server ID:', sendingServerId);
  
  // Check if sending server is selected (only if no hidden sending_server_ids[] is provided)
  var hasHiddenSendingServer = $('input[name="sending_server_ids[]"]').length > 0;
  if (!hasHiddenSendingServer && (!sendingServerId || sendingServerId === '')) {
    toastr.error('Please select a delivery server');
    return false;
  }
  
  // Update the form data with validated emails and sending server
  var frm_data = $(frm).serialize();
  frm_data = frm_data.replace(/email=[^&]*/, 'email=' + encodeURIComponent(emails));
  
  // Only manually add sending_server_id if no hidden sending_server_ids[] is provided
  if (!hasHiddenSendingServer && sendingServerId) {
    frm_data += '&sending_server_id=' + encodeURIComponent(sendingServerId);
  }
  
  // Debug: Log the form data being sent
  console.log('Form data being sent:', frm_data);
  
  var route = "/send_email_test";
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('');
      // Show loading state
      var $btn = $("#send-test-email");
      $btn.prop('disabled', true);
      $btn.html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>' + $btn.data('sending-text'));
    },
    success: function(result) {
      var $btn = $("#send-test-email");
      $btn.prop('disabled', false);
      $btn.html('<i class="bi bi-send me-1"></i>' + $btn.data('send-text'));
      $("#msg").html(result);
    },
    error: function(result) {
      var $btn = $("#send-test-email");
      $btn.prop('disabled', false);
      $btn.html('<i class="bi bi-send me-1"></i>' + $btn.data('send-text'));
      
      var errors = result.responseJSON.errors;
      if (errors) {
        for (error in errors) {
          toastr.error(errors[error]);
        }
      } else {
        toastr.error($btn.data('send-failed'));
      }
      return false;
    }
  });
}

function resetSentCounter(id, msg='Are you sure to clear the sent counter?') {
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Reset counter",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: "/sending_server/reset_counter/"+id,
          method: 'PUT',
          beforeSend: function() {
          },
          success: function(result) {
            if(result) {
              toastr.success('Counter reset successfully.');
              $('#data').DataTable().ajax.reload(null, false);
            } else {
              var errors = result.responseJSON.errors;
              for (error in errors) {
                toastr.error(errors[error]);
              }
            }
          }
        });
      }
    });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Reset counter",
      closeOnConfirm: true
    },
    function(){
      $.ajax({
        url: "/sending_server/reset_counter/"+id,
        method: 'PUT',
        beforeSend: function() {
        },
        success: function(result) {
          if(result) {
            toastr.success('Counter reset successfully.');
            $('#data').DataTable().ajax.reload(null, false);
          } else {
            var errors = result.responseJSON.errors;
            for (error in errors) {
              toastr.error(errors[error]);
            }
          }
        }
      });
    });
  }
}
function insertCKEDITOR(id, route, subject=null) {
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: $('#insert-template-msg').data('value'),
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Continue",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        CKEDITOR.instances['content_html'].setData('');
        $.get(route+id, function(content_html) {
          content_html = content_html.replace("Relayzo - Email Template", "");
          CKEDITOR.instances['content_html'].insertHtml(content_html);

          // set schedule subject
          if (subject !== null) {
             $('#email_subject').val(subject);
          }
          $('#modal').modal('hide');
        });
      }
    });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: $('#insert-template-msg').data('value'),
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Continue",
      closeOnConfirm: true
    }, function (isConfirm) {
      if(isConfirm) {
        CKEDITOR.instances['content_html'].setData('');
        $.get(route+id, function(content_html) {
          content_html = content_html.replace("Relayzo - Email Template", "");
          CKEDITOR.instances['content_html'].insertHtml(content_html);

          // set schedule subject
          if (subject !== null) {
             $('#email_subject').val(subject);
          }
          $('#modal').modal('hide');
        });
      }
    });
  }
}

function loadSendingServerAttributes(type, action, id=null) {
  var route = "/get_sending_server_fields/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#sending-attributes').show();
      $('#sending-attributes').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
    },
    success: function(result) {
      $('#sending-attributes').html(result);
    }
  });
}

  $("#type").change(function() {
    var type = $("#type").val();
    loadSendingServerAttributes(type, 'create');
  });

  $("#speed_sending_server").change(function() {
    var value = $("#speed_sending_server").val();
    if (value === 'limited') {
      $("#speed-attributes").show('slow');
      $("#warmup-plan").hide('slow');
    } else if (value === 'warmup') {
      $("#speed-attributes").hide('slow');
      $("#warmup-plan").show('slow');
    } else {
      $("#speed-attributes").hide('slow');
      $("#warmup-plan").hide('slow');
    }
  });

  $("#speed").change(function() {
    var value = $("#speed").val();
    if (value === 'limited') {
      $("#speed-attributes").show('slow');
    } else {
      $("#speed-attributes").hide('slow');
    }
  });

  $("#send").change(function() {
    var value = $("#send").val();
    if (value === 'After') {
      $("#send-datetime").show('slow');
    } else {
      $("#send-datetime").hide('slow');
    }
  });

  function runLimitedToUnlimited(id, msg){
    // Check if Swal (SweetAlert2) is available - try both Swal and window.Swal
    var SwalInstance = typeof Swal !== 'undefined' ? Swal : (typeof window.Swal !== 'undefined' ? window.Swal : null);
    
    if (!SwalInstance || typeof SwalInstance.fire !== 'function') {
      // Fallback to SweetAlert v1 if Swal.fire is not available
      if (typeof swal !== 'undefined') {
        swal({
          title: 'This action is irreversible.',
          text: msg,
          type: "warning",
          showCancelButton: true,
          confirmButtonClass: "btn-success",
          cancelButtonClass: "btn-danger",
          confirmButtonText: "Run Without Limit",
          closeOnConfirm: true
        }, function(isConfirm) {
          if(isConfirm) {
            $.ajax({
              url: "/limited_to_unlimited",
              method: 'PUT',
              data: {id: id},
              success: function(result) {
                toastr.success('Update successfully.');
                $('#data').DataTable().ajax.reload(null, false);
              }
            });
          }
        });
      } else {
        // Last resort: use browser confirm
        if (confirm('This action is irreversible.\n\n' + msg + '\n\nDo you want to continue?')) {
          $.ajax({
            url: "/limited_to_unlimited",
            method: 'PUT',
            data: {id: id},
            success: function(result) {
              toastr.success('Update successfully.');
              $('#data').DataTable().ajax.reload(null, false);
            }
          });
        }
      }
      return;
    }
    
    // Use SweetAlert2
    SwalInstance.fire({
      title: 'This action is irreversible.',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      confirmButtonClass: "btn-success",
      cancelButtonClass: "btn-danger",
      confirmButtonText: "Run Without Limit"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: "/limited_to_unlimited",
          method: 'PUT',
          data: {id: id},
          success: function(result) {
            toastr.success('Update successfully.');
            $('#data').DataTable().ajax.reload(null, false);
          }
        });
      }
    });
  }
function set2xSpeed(id, limit, initial_limit, msg){
  // Check if Swal (SweetAlert2) is available - try both Swal and window.Swal
  var SwalInstance = typeof Swal !== 'undefined' ? Swal : (typeof window.Swal !== 'undefined' ? window.Swal : null);
  
  if (!SwalInstance || typeof SwalInstance.fire !== 'function') {
    // Fallback to SweetAlert v1 if Swal.fire is not available
    if (typeof swal !== 'undefined') {
      swal({
        title: "The updated speed cannot be reduced once applied.",
        text: msg,
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-success",
        cancelButtonClass: "btn-danger",
        confirmButtonText: "Double the Speed",
        closeOnConfirm: true
      }, function(isConfirm) {
        if(isConfirm) {
          $.ajax({
            url: "/set_2x_speed",
            method: 'PUT',
            data: {id: id, initial_limit:initial_limit, limit:limit},
            success: function(result) {
              toastr.success('Update successfully.');
              $('#data').DataTable().ajax.reload(null, false);
            }
          });
        }
      });
    } else {
      // Last resort: use browser confirm
      if (confirm('The updated speed cannot be reduced once applied.\n\n' + msg + '\n\nDo you want to continue?')) {
        $.ajax({
          url: "/set_2x_speed",
          method: 'PUT',
          data: {id: id, initial_limit:initial_limit, limit:limit},
          success: function(result) {
            toastr.success('Update successfully.');
            $('#data').DataTable().ajax.reload(null, false);
          }
        });
      }
    }
    return;
  }
  
  // Use SweetAlert2
  SwalInstance.fire({
    title: "The updated speed cannot be reduced once applied.",
    text: msg,
    icon: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    cancelButtonClass: "btn-danger",
    confirmButtonText: "Double the Speed"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: "/set_2x_speed",
        method: 'PUT',
        data: {id: id, initial_limit:initial_limit, limit:limit},
        success: function(result) {
          toastr.success('Update successfully.');
          $('#data').DataTable().ajax.reload(null, false);
        }
      });
    }
  });
}
function playCampaign(id) {
  $.ajax({
    url: '/update_schedule_campaign_status/'+id,
    method: 'PUT',
    data: {status: 'Paused'},
    success: function(result) {
      $('#pause-'+id).hide();
      $('#play-'+id).show();
      $('#status-'+id).html($('#paused').data('value'));
      toastr.error($('#paused-msg').data('value'));
    }
  });
  
}
function pauseCampaign(id) {
  $.ajax({
    url: '/update_schedule_campaign_status/'+id,
    method: 'PUT',
    data: {status: 'Resume'},
    success: function(result) {
      $('#play-'+id).hide();
      $('#pause-'+id).show();
      $('#status-'+id).html($('#running').data('value'));
      toastr.success($('#running-msg').data('value'));
    }
  });
}
function copyCampaign(id, msg) {
  Swal.fire({
    title: '',
    text: msg,
    icon: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    cancelButtonClass: "btn-danger",
    confirmButtonText: "Yes",
    cancelButtonText: "Cancel"
  }).then((result) => {
    if (result.isConfirmed) {
      location.href = "/copy_schedule/"+id;
    }
  });
}

function playSplitTest(id) {
  $.ajax({
    url: getAppURL()+'/update_split_test_status/'+id,
    method: 'PUT',
    data: {status: 'Paused'},
    success: function(result) {
      $('#pause-'+id).hide();
      $('#play-'+id).show();
      $('#status-'+id).html($('#paused').data('value'));
      toastr.success($('#paused-msg').data('value'));
    }
  });
  
}
function pauseSplitTest(id) {
  $.ajax({
    url: getAppURL()+'/update_split_test_status/'+id,
    method: 'PUT',
    data: {status: 'Resume'},
    success: function(result) {
      $('#play-'+id).hide();
      $('#pause-'+id).show();
      $('#status-'+id).html($('#running').data('value'));
      toastr.error($('#running-msg').data('value'));
    }
  });
}

function bouncesImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
          $('#bounce-fields').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
        },
        success: function(result) {
          $('#bounce-fields').html(result);
          $('#btn-import').show();
          $('#btn-proceed').hide();
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doBouncesImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
    },
    success: function(data) {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      toastr.success('Import successfully.');
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
  return true;
}

function exportBounced(route, msg, msg_success) {
    Swal.fire({
        title: '',
        text: msg,
        icon: 'warning',
        showCancelButton: true,
        cancelButtonClass: "btn-danger",
        confirmButtonClass: "btn-primary",
        confirmButtonText: "Export",
        cancelButtonText: "Cancel"
    }).then((result) => {
        if (result.isConfirmed) {
            $.get(route, function( data ) {
                toastr.success(msg_success);
            });
        }
    });
}

function detailStats(id, type) {
  var route = '/detail/stat/campaign/'+id+'/'+type;
  $('#tab_stat_campaign_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_campaign_'+type).html(data);
  });
}

$('#stat-export').on('click', function() {
  $('#export-download').empty();
  var route = $('#stat-export').data('route');
  $.get(route, function(result) {
    var route = $('#export-download').data('route');
    $('#export-download').html('<a class="link-info" href="'+route+'">'+$('#export-download').data('value')+'</a>');
    $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
  });
});

$('#stat-ai-analysis').on('click', function() {
  var route = $('#stat-ai-analysis').data('route');
  $.get(route, function(data) {
    chatGPT('modal', '/chatGPT', data);
    setTimeout(function () {
        $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
    }, 5000);
  });
});

function detailStatsTriggers(id, type) {
  var route = '/detail/stat/trigger/'+id+'/'+type;
  $('#tab_stat_trigger_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_trigger_'+type).html(data);
  });
}

function detailStatsDrips(id, type) {
  var route = '/detail/stat/drip/'+id+'/'+type;
  $('#tab_stat_drip_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_drip_'+type).html(data);
  });
}

function detailSplitTestStats(id, type) {
  var route = '/detail/stat/split_test/'+id+'/'+type;
  $('#tab_stat_split_test_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_split_test_'+type).html(data);
  });
}

function sendHelp(frm) {
  var frm_data = $(frm).serialize();
  var route = "/help_send";
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('');
    },
    success: function(result) {
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $("#msg").html(result);
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
}

function moveCopySegment(button, route) {
  var frm_data = $('#frm-list').serialize();
  $.ajax({
    method: 'PUT',
    url: route,
    data: frm_data,
    success: function(msg) {
      toastr.success(msg);
      $('#modal').modal('hide');
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}
function segmentExport(route) {
  $.ajax({
    method: 'PUT',
    data: {action: 'Export'},
    url: route,
    success: function(msg) {
      toastr.success(msg);
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}

function segmentStop(route) {
  $.ajax({
    method: 'PUT',
    url: route,
    success: function(msg) {
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}

// Handle date changes (shared logic for onReady and onChange)
function handleDateChange(localDate, dateStr) {
    if (localDate) {
        const timeZone = document.querySelector("#timezone").value;

        // Convert the selected date to UTC based on the specified timezone
        const utcDate = convertToUTC(localDate, timeZone);

        // Save the UTC date to the hidden field (db_send_datetime)
        document.querySelector("#db_send_datetime").value = utcDate;

        // Keep the selected date visible in the calendar field
        document.querySelector("#send_datetime").value = dateStr;
    }
}

// Convert a local date to UTC based on the specified timezone
function convertToUTC(localDate, timeZone) {
    const options = {
        timeZone: timeZone,
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        hourCycle: "h23",
    };

    const formatter = new Intl.DateTimeFormat("en-US", options);
    const formattedDate = formatter.formatToParts(localDate);

    const year = formattedDate.find((p) => p.type === "year").value;
    const month = formattedDate.find((p) => p.type === "month").value;
    const day = formattedDate.find((p) => p.type === "day").value;
    const hour = formattedDate.find((p) => p.type === "hour").value;
    const minute = formattedDate.find((p) => p.type === "minute").value;
    const second = formattedDate.find((p) => p.type === "second").value;

    // Construct the UTC ISO date string
    return new Date(`${year}-${month}-${day}T${hour}:${minute}:${second}`).toISOString();
}

function loadBasedOnData(type, action, id=null) {
  var route = getAppURL()+"/get_based_on_data/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#based-on-data').html('<div class="form-group"><div class="col-md-12">'+
        '<i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#based-on-data').html(result);
      
      // Immediately prevent Choices.js from being applied to list_ids
      // by adding a data attribute and class before any other scripts run
      setTimeout(function() {
        var $listSelect = $("#based-on-data #list_ids");
        if ($listSelect.length > 0) {
          // Add protection classes and attributes
          $listSelect.addClass('use-multiselect no-choices').attr('data-use-multiselect', 'true');
          // Also prevent Choices.js by removing any data-trigger attribute
          $listSelect.removeAttr('data-trigger');
          
          // Immediately destroy any existing Choices.js instances
          var listElement = $listSelect[0];
          if (listElement) {
            if (listElement._choices) {
              try {
                listElement._choices.destroy();
              } catch(e) {}
              delete listElement._choices;
            }
            if ($listSelect.data('choices')) {
              try {
                $listSelect.data('choices').destroy();
              } catch(e) {}
              $listSelect.removeData('choices');
            }
            var choicesContainer = $listSelect.closest('.choices');
            if (choicesContainer.length > 0) {
              choicesContainer.remove();
              $listSelect.show();
            }
          }
        }
      }, 10);

      // Function to destroy Choices.js from list_ids
      function destroyChoicesFromListIds() {
        var $listSelect = $("#based-on-data #list_ids");
        if ($listSelect.length === 0) {
          return false;
        }
        
        var listElement = $listSelect[0];
        var destroyed = false;
        
        if (listElement) {
          // Check for Choices.js instance stored in element property
          if (listElement._choices) {
            try {
              listElement._choices.destroy();
              destroyed = true;
            } catch(e) {}
            delete listElement._choices;
          }
          // Check for Choices.js instance stored in jQuery data
          if ($listSelect.data('choices')) {
            try {
              $listSelect.data('choices').destroy();
              destroyed = true;
            } catch(e) {}
            $listSelect.removeData('choices');
          }
          // Remove Choices.js wrapper elements if they exist
          var choicesContainer = $listSelect.closest('.choices');
          if (choicesContainer.length > 0) {
            choicesContainer.remove();
            $listSelect.show(); // Show the original select
            destroyed = true;
          }
        }
        
        return destroyed;
      }

      // Function to initialize Bootstrap Multiselect for lists
      function initListsMultiselect() {
        var $listSelect = $("#based-on-data #list_ids");
        if ($listSelect.length === 0) {
          return false; // List select not found yet
        }
        
        // Ensure Bootstrap Multiselect library is loaded
        if (typeof $.fn.multiselect === 'undefined') {
          console.warn('Multiselect library not loaded yet');
          return false; // Library not loaded yet
        }
        
        // First, destroy any Choices.js instances
        destroyChoicesFromListIds();
        
        // Destroy any existing multiselect instance if it exists
        if ($listSelect.data('multiselect')) {
          $listSelect.multiselect('destroy');
        }
        
        // Make sure select is visible before initializing
        $listSelect.show();
        
        // Use default language strings (these match the language files)
        // The actual strings will be rendered by the server in the Blade template
        var nonSelectedText = 'None selected';
        var allSelectedText = 'All selected';
        var nSelectedText = 'selected';
        var selectAllText = ' Select All';
        var deselectAllText = ' Deselect All';
        var filterPlaceholder = 'Search';
        
        // Initialize Bootstrap Multiselect
        try {
          $listSelect.multiselect({
            enableClickableOptGroups: true,
            enableCollapsibleOptGroups: true,
            enableFiltering: true,
            includeSelectAllOption: true,
            buttonWidth: '100%',
            maxHeight: 400,
            nonSelectedText: nonSelectedText,
            allSelectedText: allSelectedText,
            nSelectedText: nSelectedText,
            selectAllText: selectAllText,
            deselectAllText: deselectAllText,
            filterPlaceholder: filterPlaceholder
          });
          
          // Wait a moment for multiselect to create the button, then hide the select
          setTimeout(function() {
            // Hide the original select element
            $listSelect.hide();
            
            // Ensure the multiselect button is visible
            var $btnGroup = $listSelect.next('.btn-group');
            if ($btnGroup.length === 0) {
              $btnGroup = $listSelect.siblings('.btn-group');
            }
            if ($btnGroup.length > 0) {
              $btnGroup.show();
              var $multiselectBtn = $btnGroup.find('.multiselect');
              if ($multiselectBtn.length > 0) {
                $multiselectBtn.show();
              }
            }
          }, 50);
          
          // Apply styling after initialization
          setTimeout(function() {
            $('#based-on-data .multiselect-container .multiselect-all, #based-on-data .multiselect-container .multiselect-all *').css('font-weight', 'bold');
            $('#based-on-data .multiselect-container .multiselect-group, #based-on-data .multiselect-container .multiselect-group *').css('font-weight', 'bold');
            $('#based-on-data .multiselect-container .multiselect-group .caret-container').css({
              'font-weight': 'bold',
              'margin-right': '8px'
            });
            $('#based-on-data .multiselect-container .multiselect-group ~ li.multiselect-option').css({
              'padding-left': '40px',
              'margin-left': '10px'
            });
          }, 150);
          
          return true; // Successfully initialized
        } catch(e) {
          console.error('Error initializing multiselect:', e);
          // If multiselect fails, at least show the select element
          $listSelect.show();
          return false;
        }
      }
      
      // Initialize immediately, then with multiple retries
      var initAttempts = 0;
      var maxAttempts = 10;
      
      function attemptInit() {
        initAttempts++;
        var $listSelect = $("#based-on-data #list_ids");
        
        // Make sure the select element exists and is visible initially
        if ($listSelect.length > 0 && $listSelect.is(':hidden') && !$listSelect.data('multiselect')) {
          $listSelect.show();
        }
        
        if (initListsMultiselect()) {
          return; // Success
        }
        if (initAttempts < maxAttempts) {
          setTimeout(attemptInit, 150 * initAttempts);
        } else {
          // If all attempts failed, show the select element as fallback
          var $listSelect = $("#based-on-data #list_ids");
          if ($listSelect.length > 0) {
            $listSelect.show();
            console.warn('Multiselect initialization failed, showing native select');
          }
        }
      }
      
      // Prevent Choices.js from being applied to list_ids by intercepting any attempts
      if (typeof Choices !== 'undefined') {
        // Store original Choices constructor
        var OriginalChoices = window.Choices;
        
        // Create a wrapper that checks for list_ids
        window.Choices = function(element, config) {
          var el = typeof element === 'string' ? document.querySelector(element) : element;
          
          // If this is list_ids or has use-multiselect class, don't apply Choices.js
          if (el && (el.id === 'list_ids' || 
                     el.classList.contains('use-multiselect') || 
                     el.classList.contains('no-choices') ||
                     el.getAttribute('data-use-multiselect') === 'true')) {
            console.log('Prevented Choices.js from being applied to list_ids');
            // Return a dummy object to prevent errors
            return {
              destroy: function() {},
              setValue: function() {},
              setChoices: function() {}
            };
          }
          
          // Otherwise, use the original Choices constructor
          return new OriginalChoices(element, config);
        };
        
        // Copy static properties
        window.Choices.defaults = OriginalChoices.defaults;
        
        // Restore original after 3 seconds (enough time for initialization)
        setTimeout(function() {
          window.Choices = OriginalChoices;
        }, 3000);
      }
      
      // Start initialization attempts after a short delay to ensure DOM is ready
      setTimeout(function() {
        attemptInit();
      }, 100);
      
      // Also set up a MutationObserver to watch for Choices.js being applied
      var $listSelect = $("#based-on-data #list_ids");
      if ($listSelect.length > 0 && typeof MutationObserver !== 'undefined') {
        var observer = new MutationObserver(function(mutations) {
          var $listSelect = $("#based-on-data #list_ids");
          if ($listSelect.length > 0) {
            // Check if Choices.js was applied
            if ($listSelect.closest('.choices').length > 0 || $listSelect[0]._choices || $listSelect.data('choices')) {
              // Choices.js was applied, destroy it and reinitialize multiselect
              destroyChoicesFromListIds();
              setTimeout(function() {
                initListsMultiselect();
              }, 50);
            }
          }
        });
        
        // Observe the based-on-data container for changes
        var basedOnDataContainer = document.getElementById('based-on-data');
        if (basedOnDataContainer) {
          observer.observe(basedOnDataContainer, {
            childList: true,
            subtree: true,
            attributes: true
          });
        }
        
        // Clean up observer after 10 seconds
        setTimeout(function() {
          observer.disconnect();
        }, 10000);
      }
      
      // Periodic check to ensure Choices.js hasn't been applied (runs for 5 seconds)
      var checkInterval = setInterval(function() {
        var $listSelect = $("#based-on-data #list_ids");
        if ($listSelect.length > 0) {
          // Check if Choices.js was applied
          var hasChoices = $listSelect.closest('.choices').length > 0 || 
                          ($listSelect[0] && ($listSelect[0]._choices || $listSelect.data('choices')));
          
          if (hasChoices) {
            console.log('Choices.js detected on list_ids, destroying and reinitializing multiselect');
            destroyChoicesFromListIds();
            // Re-add protection attributes
            $listSelect.addClass('use-multiselect no-choices').attr('data-use-multiselect', 'true');
            setTimeout(function() {
              initListsMultiselect();
            }, 50);
          }
        }
      }, 150);
      
      setTimeout(function() {
        clearInterval(checkInterval);
      }, 5000);

      // Reinitialize Choices.js for other dropdowns (segments, campaigns)
      // IMPORTANT: Do NOT apply Choices.js to list_ids - it should use Bootstrap Multiselect
      setTimeout(function() {
        $("#based-on-data #segment_ids,#based-on-data #schedule_campaign_stat_ids").each(function() {
          var $this = $(this);
          var elementId = $this.attr('id');
          
          // Skip if this is list_ids, has data-use-multiselect attribute, or has use-multiselect/no-choices class
          if (elementId === 'list_ids' || 
              $this.data('use-multiselect') || 
              $this.hasClass('use-multiselect') || 
              $this.hasClass('no-choices') ||
              $this.closest('.choices').length > 0) {
            return;
          }
          
          // Destroy existing Choices instance (if any)
          if ($this.data('choices')) {
            try {
              $this.data('choices').destroy();
            } catch(e) {}
          }
          
          // Double check it's not list_ids before applying
          if (elementId !== 'list_ids') {
            // Apply Choices.js
            try {
              new Choices(this, {
                removeItemButton: true,
                allowHTML: true,
                shouldSort: false,
              });
            } catch(e) {
              console.error('Error applying Choices.js to', elementId, e);
            }
          }
        });
      }, 300);

        // Reinitialize Flatpickr for newly loaded elements
        $("#send_datetime .flatpickr").each(function() {
            // Check if Flatpickr is already initialized and destroy it
            if ($(this)[0]._flatpickr) {
                $(this)[0]._flatpickr.destroy();
            }

            // Initialize Flatpickr
            $(this).flatpickr({
                enableTime: false,
                time_24hr: false,  // Use 12-hour format with AM/PM
                dateFormat: "Y-m-d", // User-friendly format
                disableMobile: true
            });
        });
    }
  });
}

function loadBasedOnAction(type, action, id=null) {
  var route = getAppURL()+"/get_based_on_data/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#action-data').html('<div class="form-group"><div class="col-md-12">'+
        '<i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#action-data').html(result);
    }
  });
}

function loadListCustomFieldsWebForms(list_id, view=null, custom_field_ids=null) {
     $.ajax({
       url: getAppURL()+"/lists-custom-fields",
       method: 'GET',
       data: {list_id: list_id, view: view, custom_field_ids: custom_field_ids},
       beforeSend: function() {
         $('#list_custom_fields').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
       },
       success: function(result) {
         $('#list_custom_fields').html(result);
         $("#custom_fields").each(function() {
            // Destroy existing Choices instance (if any)
            if ($(this).data('choices')) {
                $(this).data('choices').destroy();
            }

            // Apply Choices.js
            new Choices(this, {
                removeItemButton: true,
                allowHTML: true,
                shouldSort: false,
            });
        });
       }
     });
   }

function set2xSpeedSplitTest(id, limit, initial_limit, msg){
  Swal.fire({
    title: "The updated speed cannot be reduced once applied.",
    text: msg,
    icon: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    confirmButtonText: "Update"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: getAppURL()+"/set_2x_speed_split_test",
        method: 'PUT',
        data: {id: id, initial_limit:initial_limit, limit:limit},
        success: function(result) {
          toastr.success('Update successfully.');
        }
      });
    }
  });
}
function runLimitedToUnlimitedSplitTest(id, msg){
  Swal.fire({
    title: 'This action is irreversible.',
    text: msg,
    icon: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Run as Unlimited"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: getAppURL()+"/limited_to_unlimited_split_test",
        method: 'PUT',
        data: {id: id},
        success: function(result) {
          toastr.success('Set successfully.');
        }
      });
    }
  });
}


function setStatusMany(route, status, ids=0, msg='Are you sure to update?') {
  if(!ids) {
      if(!$('input:checkbox:checked').length){
        if (typeof Swal !== 'undefined') {
          Swal.fire({title: '',text:"Please select at least one checkbox.", icon: "warning"});
        } else {
          swal({title: '',text:"Please select at least one checkbox."});
        }
        return false;
      }

      var ids = $('input:checkbox:checked').map(function() {
        return this.value;
      }).get();
  }

  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Update",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: route,
          method: 'PUT',
          data: {action: 'many', ids: ids, status: status},
          success: function(update) {
            console.log(update)
            if(update) {
              toastr.success(update.message);
              $('#data').DataTable().ajax.reload(null, false);
              $("#checkAll").prop('checked', false);
            } else {
              toastr.error('Found some error(s).');
            }
          }
        });
      }
    });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Update",
      closeOnConfirm: true
    },
    function(){
      $.ajax({
        url: route,
        method: 'PUT',
        data: {action: 'many', ids: ids, status: status},
        success: function(update) {
          console.log(update)
          if(update) {
            toastr.success(update.message);
            $('#data').DataTable().ajax.reload(null, false);
            $("#checkAll").prop('checked', false);
          } else {
            toastr.error('Found some error(s).');
          }
        }
      });
    });
  }
}

function loadEmailVerifiersAttributes(type, action, id=null) {
  var route = getAppURL()+"/get_email_verifiers_fields/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#email_verifiers-attributes').show();
      $('#email_verifiers-attributes').html('<div class="spinner-border text-dark mt-3" role="status"><spam class="visually-hidden"></span></div>');
    },
    success: function(result) {
      $('#email_verifiers-attributes').html(result);
    }
  });
}

function refreshLicense(frm) {
  var frm_data = $(frm).serialize();
  var route = "/refresh_license";
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('<i class="bi bi-info-circle me-2"></i><span id="msg-text"></span>').addClass('d-none').removeClass('alert-success alert-danger alert-info');
    },
    success: function(result) {
      $("#refresh-license").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      
      // Debug: Log the result to console
      console.log('License refresh result:', result);
      
      // Show the message div
      $("#msg").removeClass('d-none');
      
      // Get the message from result
      var message = '';
      if (result.message) {
        message = result.message;
      } else if (typeof result === 'string') {
        message = result;
      } else {
        message = 'License verification failed';
      }
      
      if(!result.verify) {
        $('#msg').removeClass('alert-success alert-info').addClass('alert-danger');
        $('#msg-text').html(message);
      } else {
        $('#msg').removeClass('alert-danger alert-info').addClass('alert-success');
        $('#msg-text').html(message);
      }
    },
    error: function(result) {
      $("#refresh-license").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      
      // Show error message in modal
      $("#msg").removeClass('d-none alert-success').addClass('alert-danger');
      
      var errorMsg = 'An error occurred while refreshing the license';
      if (result.responseJSON && result.responseJSON.errors) {
        var errors = result.responseJSON.errors;
        var errorMessages = [];
        for (error in errors) {
          errorMessages.push(errors[error]);
        }
        errorMsg = errorMessages.join(', ');
      } else if (result.responseJSON && result.responseJSON.message) {
        errorMsg = result.responseJSON.message;
      }
      
      $('#msg-text').html('<i class="bi bi-exclamation-circle me-2"></i>' + errorMsg);
      return false;
    }
  });
}

function backupFilesDB(frm) {
  var frm_data = $(frm).serialize();
  var route = "/backup";
  var $btn = $("#backup");
  var $icon = $btn.find("i");
  
  // Show loading spinner
  $icon.removeClass("bi-download").addClass("spinner-border spinner-border-sm");
  
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('');
    },
    success: function(result) {
      $icon.removeClass("spinner-border spinner-border-sm").addClass("bi-download");
      toastr.success($('#msg-backup').data('value'));
    },
    error: function(xhr) {
      $icon.removeClass("spinner-border spinner-border-sm").addClass("bi-download");
      
      if (xhr.status === 401) {
        toastr.error('You do not have permission to create backups. Please contact your administrator.');
      } else if (xhr.status === 403) {
        toastr.error('Access forbidden. You do not have the required permissions.');
      } else if (xhr.responseJSON && xhr.responseJSON.errors) {
        var errors = xhr.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      } else {
        toastr.error('An error occurred while trying to create the backup. Please try again.');
      }
    }
  });
}

function deleteNote(route, msg="Are you sure to delete the note?")
{
    swal({
      title: "",
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Yes",
      closeOnConfirm: false
    }, function (isConfirm) {
      if(isConfirm) {
        $.ajax({
          url: route,
          method: 'DELETE',
          success: function(destroy) {
            if(destroy.success) {
              toastr.success(destroy.message);
              location.reload();
            } else {
              toastr.error(destroy.message);
            }
          }
        }); 
      }
    });
}

function pinNote(route, title, is_pinned)
{
    $.ajax({
      url: route,
      method: 'PUT',
      data: {title: title, is_pinned: is_pinned},
      success: function(status) {
        if(status.success) {
          toastr.success(status.message);
          location.reload();
        } else {
          toastr.error(status.message);
        }
      }
    });
}

var copy = function(id) {
  $('#'+id).select();
  document.execCommand("copy");
  toastr.success('Copied successfully.');
}

function convertMarkdownBoldToHTML(markdownText) {
  return markdownText.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
}

function aiAnalysisCampaign() {
  $(this).find("i").addClass("spinner-border spinner-border-sm align-middle");
  var email_subject = $('#email_subject').val();
  var email_content = $('#sending_content').val();
  var data = `Could you please imporve the email subjet and the content for the campaign?\n
    Email Subject: ${email_subject}\n
    Email Content: ${email_content}`;
  
  chatGPT('modal', '/chatGPT', data);
  setTimeout(function () {
      $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
  }, 5000);
}