$(function () {
    'use strict';
    if (CKEDITOR.instances["content_html_chatgpt"]) {
        CKEDITOR.instances["content_html_chatgpt"].destroy();
    }

    CKEDITOR.replace('content_html_chatgpt', {
        fullPage: true,
        allowedContent: true,
        height: 500,
        extraPlugins: 'font,find,justify,mc_uploader,emoji',
        language: $('html')[0].lang,
        enterMode: CKEDITOR.ENTER_BR,
        font_names: 'Arial/Arial, Helvetica, sans-serif;' +
        'Times New Roman/Times New Roman, Times, serif;' +
        'Verdana/Verdana, Geneva, sans-serif;' +
        'Calibri/Calibri, sans-serif;' +   // Calibri
        'Tahoma/Tahoma, Geneva, sans-serif;' + // Tahoma
        'Lucida Sans/Lucida Sans, Lucida Grande, sans-serif;' + // Lucida
        'Comic Sans MS/Comic Sans MS, cursive;' +
        'Courier New/Courier New, Courier, monospace;',
        
        // Customize the toolbar
        toolbar: [
            { name: 'document', items: ['Source'] }, // Added Source and Preview buttons
            { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike'] },
            { name: 'paragraph', items: ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'] },
            { name: 'links', items: ['Link', 'Unlink'] },
            { name: 'tools', items: ['Maximize'] }
        ],
    });
});

function ask_chatGPT() {
    var updatedContent = CKEDITOR.instances['content_html_chatgpt'].getData();
    chatGPT('modal', '/chatGPT', updatedContent);
    $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
}