$(function () {
  'use strict';
  $('.daterange-domain').daterangepicker({
    maxDate: new Date,
    ranges   : {
      'Today'       : [moment(), moment()],
      'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month'  : [moment().startOf('month'), moment().endOf('month')],
      'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'This Year'   : [moment().startOf('year'), moment().endOf('year')],
      'Last Year'   : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
    },
    startDate: moment().subtract(0, 'days'),
    endDate  : moment()
  }, function (start, end) {
    domiansChart(start, end);
  });

  $('.daterange-country').daterangepicker({
    maxDate: new Date,
    ranges   : {
      'Today'       : [moment(), moment()],
      'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month'  : [moment().startOf('month'), moment().endOf('month')],
      'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'This Year'   : [moment().startOf('year'), moment().endOf('year')],
      'Last Year'   : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
    },
    startDate: moment().subtract(0, 'days'),
    endDate  : moment()
  }, function (start, end) {
    countryChart(start, end);
  });

  $('.daterange-campaigns').daterangepicker({
    maxDate: new Date,
    ranges   : {
      'Today'       : [moment(), moment()],
      'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month'  : [moment().startOf('month'), moment().endOf('month')],
      'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'This Year'   : [moment().startOf('year'), moment().endOf('year')],
      'Last Year'   : [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
    },
    startDate: moment().subtract(0, 'days'),
    endDate  : moment()
  }, function (start, end) {
    campaignsChart(start, end);
  });

  var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [5,6,9,10]}],
    "order": [[6, "DESC"]],
    "lengthMenu": [[3], [3]],
    "lengthChange" : false,
    "searching": false,
    "responsive": true,
    "ajax": {
      "url" : $('#data-campaigns-route').data('value')
    },
  });

  table.on('draw', function() {
      $('.dataTables_paginate a').addClass('btn btn-primary me-1');
      $('.dataTables_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });

  var table_trigger = $('#data-triggers').DataTable({
    "columnDefs": [{"sortable": false, "targets": [3,5]}],
    "order": [[5, "DESC"]],
    "lengthMenu": [[3], [3]],
    "lengthChange" : false,
    "searching": false,
    "responsive": true,
    "ajax": {
      "url" : $('#data-triggers-route').data('value')
    },
  });

  table_trigger.on('draw', function() {
      $('.dataTables_paginate a').addClass('btn btn-primary me-1');
      $('.dataTables_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });


  var table_split_tests = $('#data-split-tests').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0,2,3,4,5,6,7,8,9,10,12,13]}],
    "order": [[5, "DESC"]],
    "lengthMenu": [[3], [3]],
    "lengthChange" : false,
    "searching": false,
    "responsive": true,
    "ajax": {
      "url" : $('#data-split-tests-route').data('value')
    },
  });

  table_split_tests.on('draw', function() {
      $('.dataTables_paginate a').addClass('btn btn-primary me-1');
      $('.dataTables_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });

  
});

function domiansChart(start, end) {
  var start_datetime = start.format('YYYY-MM-DD 00:00:00');
  var end_datetime = end.format('YYYY-MM-DD 23:59:59');
  $.ajax({
    url: $('#domain').data('route'),
    data: {start_datetime: start_datetime, end_datetime: end_datetime},
    beforeSend: function( xhr ) {  
      $('#div-chart-domain').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
      $('#domain-range').html('( ' +start.format('YYYY-MM-DD')+ ' - '+end.format('YYYY-MM-DD')+' )');
    }
  })
  .done(function( data ) {
    $('#div-chart-domain').html('<canvas id="canvas-chart-domain" style="height: 250px;"></canvas>');
    var canvas_chart_sent = $('#canvas-chart-domain').get(0).getContext('2d');
    var chart       = new Chart(canvas_chart_sent);
    var data        =  JSON.parse(data);
    var options     = {
      legend: {
        position: 'right',
        labels: {
          boxWidth: 20
        }
      },
    };

    if(data.labels.length) {
      var myPieChart = new Chart(chart, {
          type: 'pie',
          data: data,
          options: options
      });
    } else {
      $('#div-chart-domain').html($('#no-found').data('value'));
    }
  });
}
function recipientsSummaryChart() {
  $.ajax({
    url: $('#recipients-summary').data('route'),
    beforeSend: function( xhr ) {}
  })
  .done(function( data ) {
    $('#div-chart-recipients-summary').html('<canvas id="canvas-chart-recipients-summary" style="height: 250px;"></canvas>');
    var canvas_chart_sent = $('#canvas-chart-recipients-summary').get(0).getContext('2d');
    var chart       = new Chart(canvas_chart_sent);
    var data        =  JSON.parse(data);
    var options     = {
      legend: {
        position: 'right',
        labels: {
          boxWidth: 20
        }
      },
    };

    if(data.labels.length) {
      var myPieChart = new Chart(chart, {
          type: 'pie',
          data: data,
          options: options
      });
    } else {
      $('#div-chart-recipients-summary').html($('#no-found').data('value'));
    }
  });
}

function countryChart(start, end) {
  var start_datetime = start.format('YYYY-MM-DD 00:00:00');
  var end_datetime = end.format('YYYY-MM-DD 23:59:59');
  $.ajax({
    url: $('#country').data('route'),
    data: {start_datetime: start_datetime, end_datetime: end_datetime},
    beforeSend: function( xhr ) {  
      $('#world-map').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
      $('#country-range').html('( ' +start.format('YYYY-MM-DD')+ ' - '+end.format('YYYY-MM-DD')+' )');
    }
  })
  .done(function( data ) {
    var data = JSON.parse(data);
    // World map by jvectormap
    $('#world-map').html('');
    $('#world-map').vectorMap({
      map              : 'world_mill_en',
      backgroundColor  : 'transparent',
      regionStyle      : {
        initial: {
          fill            : '#e4e4e4',
          'fill-opacity'  : 1,
          stroke          : 'none',
          'stroke-width'  : 0,
          'stroke-opacity': 1
        },
        hover: {
          stroke: '#3D5A6B',
          "stroke-width": 2,
          cursor: 'pointer'
        }
      },
      series           : {
        regions: [
          {
            values           : data,
            scale            : ['#deeef7', '#096da5'],
            normalizeFunction: 'polynomial'
          }
        ]
      },
      onRegionTipShow: function(e, el, code){
        if (typeof data[code] != 'undefined')
          el.html(el.html() +" ("+ $('#opens').data('value') +": "+data[code]+')');
      }
    });
  });
}

function campaignsChart(start, end) {
  var start_datetime = start.format('YYYY-MM-DD 00:00:00');
  var end_datetime = end.format('YYYY-MM-DD 23:59:59');
  $.ajax({
    url: $('#campaign').data('route'),
    data: {start_datetime: start_datetime, end_datetime: end_datetime},
    beforeSend: function( xhr ) {  
      $('#div-chart-campaigns').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
      $('#campaigns-range').html('( ' +start.format('YYYY-MM-DD')+ ' - '+end.format('YYYY-MM-DD')+' )');
    }
  })
  .done(function( data ) {
    $('#div-chart-campaigns').html('<canvas id="canvas-chart-campaigns" style="height: 250px;"></canvas>');
    var canvas_chart_sent = $('#canvas-chart-campaigns').get(0).getContext('2d');
    var chart       = new Chart(canvas_chart_sent);
    var data        =  JSON.parse(data);
    var options = {
      responsive: true,
      tooltips: {
        mode: 'index',
        intersect: false,
      },
      hover: {
        mode: 'nearest',
        intersect: true
      },
      legend: {
        labels: {
          boxWidth: 20
        }
      },
      scales: {
        yAxes: [{
          ticks: {
            beginAtZero: true,
            userCallback: function(label, index, labels) {
               // when the floored value is the same as the value we have a whole number
               if (Math.floor(label) === label) {
                   return label;
               }
           },
          }
        }]
      },
    };

    if(data.labels.length) {
      var mylineChart = new Chart(chart, {
          type: 'line',
          data: data,
          options: options
      });
    } else {
      $('#div-chart-').html($('#campaign').data('value'));
    }
  });
}