'use strict';
$.extend( $.fn.dataTable.defaults, {
  "processing" : true,
  "serverSide" : true,
  "searching"  : true,
  "responsive": true,
  "pagingType" : "full_numbers",
  "language": {
    "search": "",
    "lengthMenu"    : "_MENU_",
    "loadingRecords": $('#dt_loadingRecords').data('value'),
    "processing"    : '<div class="position-fixed top-0 start-0 w-100 h-100 bg-light bg-opacity-50 d-flex justify-content-center align-items-center" id="loader"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>',
    "zeroRecords"   : $('#dt_zeroRecords').data('value'),
    "info"          : $('#dt_info').data('value'),
    "infoEmpty"     : $('#dt_infoEmpty').data('value'),
    "infoFiltered"  : $('#dt_infoFiltered').data('value'),
    "paginate" : {
      "previous": $('#dt_previous').data('value'),
      "next"    : $('#dt_next').data('value'),
      "first"   : $('#dt_first').data('value'),
      "last"    : $('#dt_last').data('value'),
    }
  },
  initComplete: function () {
    var input = $('.dataTables_filter input').unbind(),
        self = this.api(),
        $searchButton = $('<button class="btn btn-primary">')
            .text($('#dt_btn_search').data('value'))
            .click(function () {
                self.search(input.val()).draw();
            }),
        $showAllButton = $('<button class="btn btn-primary">') // Declare $showAllButton here.
            .text($('#dt_btn_show_all').data('value'))
            .click(function () {
                self.search('').draw();
            });

    // Append buttons to the search filter
    $('.dataTables_filter').append($searchButton);
    $('.dataTables_filter').append($showAllButton);

    // Modify classes for input and other elements
    $('.dataTables_filter input[type="search"]').removeClass('form-control form-control-sm');
    $('.dataTables_filter input[type="search"]').addClass('form-control mb-3');
    $('.dataTables_length select').addClass('form-select position-absolute');
    $('.dataTables_filter').addClass('btn-list');
    $('#data_filter label').addClass('me-2 mb-1');
    //$('#data_paginate a').addClass('btn btn-primary me-1');
    $('.dataTables_paginate a').addClass('btn btn-primary me-1');
    
    // Show additional row button if it exists
    if ($('#addRow').length) {
        $('#addRow').show();
    }
    if ($('#add-template-btn').length) {
        $('#add-template-btn').show();
    }
    if ($('#add-drip-btn').length) {
        $('#add-drip-btn').show();
    }
    if ($('#add-spintag-btn').length) {
        $('#add-spintag-btn').show();
    }
    if ($('#add-schedule-campaign-btn').length) {
        $('#add-schedule-campaign-btn').show();
    }
    if ($('#add-trigger-btn').length) {
        $('#add-trigger-btn').show();
    }
}

});

// For responsive
if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
  $.extend( $.fn.dataTable.defaults, {
    "sScrollX"   : '100%',
  });
}