$(function () {
    'use strict';
    $('[data-toggle="tooltip"]').tooltip();
    
    // Handle Add List button click with error handling
    $('#add-list-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        
        // Show loading spinner
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        
        // Try to navigate to the create page
        $.ajax({
            url: href,
            type: 'GET',
            success: function() {
                // If successful, navigate to the page
                window.location.href = href;
            },
            error: function(xhr) {
                // Reset button
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                
                if (xhr.status === 401) {
                    alert('You do not have permission to create lists. Please contact your administrator.');
                } else if (xhr.status === 403) {
                    alert('Access forbidden. You do not have the required permissions.');
                } else {
                    alert('An error occurred while trying to access the create list page. Please try again.');
                }
            }
        });
    });
    
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 4, 6]}],
        "order": [[3, "asc"], [1, "desc"]],
        "responsive": true,
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": $('#route-lists').data('route'),
        "drawCallback": function ( settings, data ) {
            var api = this.api();
            var rows = api.rows( {page:'current'} ).nodes();
            var last=null;
            var groupColumn=3;
            api.column(groupColumn, {page:'current'} ).data().each( function ( group, i ) {
                var spanElement = $(group);
                var group_id = spanElement.attr('id');

                let url = $('#route-group-edit').data('route');
                let route_url = url.replace("group-id", group_id);

                if ( last !== group ) {
                    $(rows).eq( i ).before(
                        '<tr class="dt_group"><td colspan="6" class="fw-bold">'+group+'</td>'+
                        '<td>'+
                        '&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="bottom" class="bi bi-pencil-square" style="cursor: pointer;" title="'+$('#tooltip-group-edit').data('value')+'" onclick="viewModal(\'modal\', \''+route_url+'\')"></i>'+
                        '&nbsp;&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="bottom" class="bi bi-trash" style="cursor: pointer;" title="'+$('#tooltip-group-delete-list').data('value')+'" onclick="deleteGroup(this, \''+$('#msg-group-delete-list').data('value')+'\')"></i>'+
                        '&nbsp;&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="bottom" class="bi bi-eraser" style="cursor: pointer;" title="'+$('#tooltip-group-eraser-list').data('value')+'" onclick="eraseGroup(this, \''+$('#route-group-eraser-list').data('route')+'\', \''+$('#msg-group-erase-list').data('value')+'\')"></i>'+
                        '</td></tr>'
                        );
                    last = group;
                }
            });
            // Reinitialize Bootstrap tooltips after DataTable redraw
            $('[data-bs-toggle="tooltip"]').tooltip();
        },
    });

    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});