'use strict';
flatpickr("#send_datetime", {
    enableTime: true,
    time_24hr: false, // Use 12-hour format with AM/PM
    minDate: "today",
    dateFormat: "Y-m-d h:i K", // User-friendly format
    defaultDate: document.querySelector("#send_datetime").value, // Pre-filled value from server
    disableMobile: true,
    onReady: function (selectedDates, dateStr, instance) {
        // Trigger the same behavior as onChange for the default value
        handleDateChange(instance.selectedDates[0], dateStr);
    },
    onChange: function (selectedDates, dateStr, instance) {
        if (selectedDates.length > 0) {
            handleDateChange(selectedDates[0], dateStr);
        }
    },
});

$('#copy-as-text').click(function() {
      var content_html = CKEDITOR.instances['content_html'].getSnapshot();
      var content = content_html.replace(/<br\s*\/?>|<\/p>|<\/div>|<\/li>/gi, "\n");
      content = content.replace(/&nbsp;/g, ' ');
      // remove html tags
      var regex = /(<([^>]+)>)/ig
      var content = $.trim(content.replace(regex, ""));
      $('#content_text').val(content);
  });

$("#send-option").change(function() {
  $("#send-datetime").slideToggle('slow');
});

$('.repeater-attachments').repeater({
  show: function () {
    $(this).slideDown();
  },
  hide: function (deleteElement) {
    if (typeof Swal !== 'undefined') {
      Swal.fire({
        title: "",
        text: $('#attachment_delete_msg').data('value'),
        icon: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        cancelButtonText: "Cancel"
      }).then((result) => {
        if(result.isConfirmed) {
          $(this).slideUp(deleteElement);
        }
      });
    } else {
      // Fallback to SweetAlert v1
      swal({
        title: "",
        text: $('#attachment_delete_msg').data('value'),
        type: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        closeOnConfirm: false
      }, function (isConfirm) {
        if(isConfirm) {
          $(this).slideUp(deleteElement);
          swal.close(); // **Manually close the alert**
        }
      });
    }

  },
  isFirstItemUndeletable: true
});

$(".delete-file").click(function () {
    var fileName = $(this).data("file"); // Get file name
    var scheduleId = $('#schedule_id').data('value'); // Get schedule ID
    var fileItem = $(this).closest(".file-item"); // Store reference to delete on success

    if (typeof Swal !== 'undefined') {
      Swal.fire({
        title: "",
        text: $('#attachment_delete_msg').data('value'),
        icon: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        cancelButtonText: "Cancel"
      }).then((result) => {
        if(result.isConfirmed) {
          $.ajax({
                url: "/delete-attachment/" + scheduleId, 
                type: "DELETE",
                data: {
                    file: fileName,
                    user_id: $('#user_id').data('value')
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                        fileItem.remove(); // Remove file item from DOM
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error("Failed to delete file.");
                }
            });
        }
      });
    } else {
      // Fallback to SweetAlert v1
      swal({
        title: "",
        text: $('#attachment_delete_msg').data('value'),
        type: "warning",
        showCancelButton: true,
        cancelButtonClass: "btn-primary",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes",
        closeOnConfirm: false
      }, function (isConfirm) {
        if(isConfirm) {
          $.ajax({
                url: "/delete-attachment/" + scheduleId, 
                type: "DELETE",
                data: {
                    file: fileName,
                    user_id: $('#user_id').data('value')
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                        fileItem.remove(); // Remove file item from DOM
                        swal.close(); // **Manually close the alert**
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error("Failed to delete file.");
                }
            });
        }
      });
    }
});

function onCancel(){ $('#smartwizard').smartWizard("reset"); }

function submitFrom(operation, msg){ 
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: '',
      text: msg,
      icon: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-success",
      confirmButtonText: "Yes",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        $("#operation").val(operation);
        $('#frm-schedule').submit(); 
      }
    });
  } else {
    // Fallback to SweetAlert v1
    swal({
      title: '',
      text: msg,
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-success",
      confirmButtonText: "Yes",
      closeOnConfirm: true
    }, function(){
      $("#operation").val(operation);
      $('#frm-schedule').submit(); 
    });
  }
}


function provideContent(idx, stepDirection, stepPosition, selStep, callback) {
  callback();
}


function ucfirst(str) {
  if (!str) return ''; // Handle empty strings
  return str.charAt(0).toUpperCase() + str.slice(1);
}

  // Helper function to get selected labels
function getSelectedLabels(choicesInstance) {
  if (!choicesInstance) return [];
  const selectedValues = choicesInstance.getValue(true); // ["8", "15", "17"]
  const allOptions = choicesInstance.passedElement.element.options;
  return selectedValues.map(value => {
    const option = Array.from(allOptions).find(option => option.value === value);
    return option ? option.text : ''; // Return the text if found, otherwise empty string
  });
}


$(function() {

// Note: #sending_server_ids uses Bootstrap Multiselect (initialized in dropdown_sending_server.blade.php)
// #list_ids uses Choices.js
$("#smartwizard").on("showStep", function(e, anchorObject, stepIndex, stepDirection, stepPosition) {

  $('#smartwizard .nav-link').addClass('text-primary');
  $('#smartwizard .sw-toolbar-elm .btn').addClass('btn-primary');

  // Enable/disable navigation buttons based on step position
  $("#prev-btn").removeClass('disabled').prop('disabled', false);
  $("#next-btn").removeClass('disabled').prop('disabled', false);
  if (stepPosition === 'first') {
    $("#prev-btn").addClass('disabled').prop('disabled', true);
  } else if (stepPosition === 'last') {
    $("#next-btn").addClass('disabled').prop('disabled', true);
  }

  // On the final step, capture input values and display them in the review section
  if (stepIndex === 3) {
    const dataFromDetail = {
      sending_server: `As defined for sending server`,
      list: `As defined for list`,
      custom: `Custom`,
    };
    const name = $("#name").val();
    const selectedRadioValue = $("input[name='from_detail']:checked").val();
    const open_tracking = $('#open_tracking').is(':checked') ? 'Yes' : 'No';;
    const click_tracking = $('#click_tracking').is(':checked') ? 'Yes' : 'No';;
    const email_subject = $("#email_subject").val();
    const sending_content = $("#sending_content").val();
    const send = $("#send-option").val();
    const send_datetime = $("#send_datetime").val();
    const speed = $("#speed").val();
    const duration = $("#duration").val();
    const limit = $("#limit").val();
    const pause_limit = $("#pause_limit").val();
    const delivery_timing = $("#delivery_timing").val();
    const auto_scheduled_next = $("#auto_scheduled_next").is(':checked');
    const days = $("#days").val();
    const start_time = $("#startTime").val();
    const end_time = $("#endTime").val();
    // Only get custom email values if custom option is selected
    let from_name = '';
    let from_email = '';
    let reply_email = '';
    
    if($("input[name='from_detail']:checked").val() == 'custom') {
      from_name = $("#from_name").val();
      const from_email_part1 = $("#from_email_part1").val();
      const from_email_part2 = $("#sending-domains").val();
      from_email = from_email_part1 && from_email_part2 ? from_email_part1 + '@' + from_email_part2 : '';
      reply_email = $("#reply_email").val();
    }


    const review_name = $('#review_name').data('value');
    const review_from_detail = $('#review_from_detail').data('value');
    const review_from_name = $('#review_from_name').data('value');
    const review_from_email = $('#review_from_email').data('value');
    const review_reply_email = $('#review_reply_email').data('value');
    const review_subject = $('#review_subject').data('value');
    const review_sending_content = $('#review_sending_content').data('value');
    const review_open_tracking = $('#review_open_tracking').data('value');
    const review_click_tracking = $('#review_click_tracking').data('value');
    const review_send = $('#review_send').data('value');
    const review_send_at = $('#review_send_at').data('value');
    const review_sending_speed = $('#review_sending_speed').data('value');
    const review_limit = $('#review_limit').data('value');
    const review_maximum = $('#review_maximum').data('value');


    let custom_data;
    
    // Campaign Detail Section (Combined Basic Info + Campaign Detail)
    let campaignDetailHtml = `
      <div class="mb-2">
        <small class="text-muted">${review_name}</small>
        <div class="fw-semibold">${name || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${review_from_detail}</small>
        <div class="fw-semibold">${dataFromDetail[selectedRadioValue] || "---"}</div>
      </div>`;

    if($("input[name='from_detail']:checked").val() == 'custom') {
      campaignDetailHtml += `
        <div class="mb-2">
          <small class="text-muted">${review_from_name}</small>
          <div class="fw-semibold">${from_name || "---"}</div>
        </div>
        <div class="mb-2">
          <small class="text-muted">${review_from_email}</small>
          <div class="fw-semibold">${from_email || "---"}</div>
        </div>
        <div class="mb-2">
          <small class="text-muted">${review_reply_email}</small>
          <div class="fw-semibold">${reply_email || "---"}</div>
        </div>`;
    }

    campaignDetailHtml += `
      <div class="mb-2">
        <small class="text-muted">${review_subject}</small>
        <div class="fw-semibold">${email_subject || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${review_sending_content}</small>
        <div class="fw-semibold">${ucfirst(sending_content) || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${review_open_tracking}</small>
        <div class="fw-semibold">${ucfirst(open_tracking) || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${review_click_tracking}</small>
        <div class="fw-semibold">${ucfirst(click_tracking) || "---"}</div>
      </div>`;
    $("#review-campaign-detail").html(campaignDetailHtml);

    // Settings Section
    let settingsHtml = `
      <div class="mb-2">
        <small class="text-muted">${$('#review_send').data('value')}</small>
        <div class="fw-semibold">${ucfirst(send) || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${$('#review_send_at').data('value')}</small>
        <div class="fw-semibold">${send_datetime || "---"}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${$('#review_sending_speed').data('value')}</small>
        <div class="fw-semibold">${speed == "unlimited" ? ucfirst($('#review_maximum').data('value')) : ucfirst(speed)}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${$('#review_limit').data('value')}</small>
        <div class="fw-semibold">${speed == "unlimited" ? "---" : (limit+"/"+ucfirst(duration))}</div>
      </div>
      <div class="mb-2">
        <small class="text-muted">${$('#review_delivery_timing').data('value')}</small>
        <div class="fw-semibold">${delivery_timing && typeof delivery_timing === "string" ? delivery_timing.replace(/_/g, " ").replace(/\\b\\w/g, l => l.toUpperCase()) : "---"}</div>
      </div>`;

    // Add days, start time, and end time if delivery timing is specific_hours
    if (delivery_timing === 'specific_hours') {
      console.log('Delivery timing is specific_hours');
      console.log('Days:', days);
      console.log('Start time:', start_time);
      console.log('End time:', end_time);
      
      settingsHtml += `
        <div class="mb-2">
          <small class="text-muted">${$('#review_auto_scheduled_next').data('value')}</small>
          <div class="fw-semibold">${auto_scheduled_next ? "Yes" : "No"}</div>
        </div>
        <div class="mb-2">
          <small class="text-muted">${$('#review_days').data('value')}</small>
          <div class="fw-semibold">${Array.isArray(days) ? days.join(", ") : (days || "---")}</div>
        </div>
        <div class="mb-2">
          <small class="text-muted">${$('#review_start_time').data('value')}</small>
          <div class="fw-semibold">${start_time ? (() => { const parts = start_time.toString().split(":"); const hour = parseInt(parts[0] || 0); const minutes = parts[1] || "00"; const ampm = hour >= 12 ? "PM" : "AM"; const h12 = hour === 0 ? 12 : hour > 12 ? hour - 12 : hour; return `${h12}:${minutes} ${ampm}`; })() : "---"}</div>
        </div>
        <div class="mb-2">
          <small class="text-muted">${$('#review_end_time').data('value')}</small>
          <div class="fw-semibold">${end_time ? (() => { const parts = end_time.toString().split(":"); const hour = parseInt(parts[0] || 0); const minutes = parts[1] || "00"; const ampm = hour >= 12 ? "PM" : "AM"; const h12 = hour === 0 ? 12 : hour > 12 ? hour - 12 : hour; return `${h12}:${minutes} ${ampm}`; })() : "---"}</div>
        </div>`;
    } else {
      console.log('Delivery timing is not specific_hours:', delivery_timing);
    }
    $("#review-settings").html(settingsHtml);

    // Targeting Section
    let targetingHtml = '';
    
    // Display list choices
    let listsText = "---";
    const listSelect = document.getElementById("list_ids");
    if (listSelect) {
      const selectedValues = $(listSelect).val();
      if (selectedValues && (Array.isArray(selectedValues) ? selectedValues.length > 0 : selectedValues !== '')) {
        // Get selected option labels
        const selectedLabels = [];
        if (Array.isArray(selectedValues)) {
          selectedValues.forEach(function(value) {
            if (value && value !== '') {
              const option = listSelect.querySelector(`option[value="${value}"]`);
              if (option) {
                selectedLabels.push(option.textContent.trim());
              }
            }
          });
        } else {
          const option = listSelect.querySelector(`option[value="${selectedValues}"]`);
          if (option) {
            selectedLabels.push(option.textContent.trim());
          }
        }
        listsText = selectedLabels.join(", ");
      }
    }
    targetingHtml += `
      <div class="mb-2">
        <small class="text-muted">${$('#review_lists').data('value')}</small>
        <div class="fw-semibold">${listsText}</div>
      </div>`;

    // Display sending server choices
    let serversText = "---";
    const sendingServerSelect = document.getElementById("sending_server_ids");
    if (sendingServerSelect) {
      const selectedValues = $(sendingServerSelect).val();
      if (selectedValues && (Array.isArray(selectedValues) ? selectedValues.length > 0 : selectedValues !== '')) {
        // Get selected option labels
        const selectedLabels = [];
        if (Array.isArray(selectedValues)) {
          selectedValues.forEach(function(value) {
            if (value && value !== '') {
              const option = sendingServerSelect.querySelector(`option[value="${value}"]`);
              if (option) {
                selectedLabels.push(option.textContent.trim());
              }
            }
          });
        } else {
          const option = sendingServerSelect.querySelector(`option[value="${selectedValues}"]`);
          if (option) {
            selectedLabels.push(option.textContent.trim());
          }
        }
        serversText = selectedLabels.join(", ");
      }
    }
    targetingHtml += `
      <div class="mb-2">
        <small class="text-muted">${$('#review_delivery_servers').data('value')}</small>
        <div class="fw-semibold">${serversText}</div>
      </div>`;
    
    $("#review-targeting").html(targetingHtml);
  }

  // Update the current step info in the UI
  let stepInfo = $('#smartwizard').smartWizard("getStepInfo");
  $("#sw-current-step").text(stepInfo.currentStep + 1);
  $("#sw-total-step").text(stepInfo.totalSteps);
});

// Smart Wizard
$('#smartwizard').smartWizard({
    selected: 0,
    theme: 'square',
    transition: {
        animation: 'fade'
    },
    toolbar: {
        showNextButton: true,
        showPreviousButton: true,
        position: 'top',
        extraHtml: `<span class="ps-1"></span>
                    <button type="button" name="scheduled" class="btn btn-success btn-submit d-none" onclick="submitFrom('scheduled', 'Are you sure to schedule?')">Schedule</button>
                    <span class="ps-1"></span>
                    <button type="button" name="save" class="btn btn-secondary btn-submit d-none" onclick="submitFrom('save', 'Are you sure to save as draft?')">Save</button>`
    },
    keyboardSettings: {
        keyNavigation: false,
    },
    anchor: {
        enableNavigation: true,
        enableNavigationAlways: false,
        enableDoneState: true,
        markPreviousStepsAsDone: true,
        unDoneOnBackNavigation: false,
        enableDoneStateNavigation: true
    },
    disabledSteps: [],
    errorSteps: [],
    hiddenSteps: [],
    getContent: provideContent
});


    $("#state_selector").on("change", function() {
      $('#smartwizard').smartWizard("setState", [$('#step_to_style').val()], $(this).val(), !$('#is_reset').prop("checked"));
      return true;
    });

    $("#style_selector").on("change", function() {
      $('#smartwizard').smartWizard("setStyle", [$('#step_to_style').val()], $(this).val(), !$('#is_reset').prop("checked"));
      return true;
    });

  });

$("#smartwizard").on("leaveStep", function (e, anchorObject, currentStepIndex, nextStepIndex) {
// Display submit button on the final step
  if (nextStepIndex === 3) {
    $(".btn-submit").removeClass('d-none');
  } else {
    $(".btn-submit").addClass('d-none');
  }

    if (currentStepIndex === 0) { // Validate only on Step 0
        let form = document.getElementById("frm-schedule");

        const listDropdown = document.getElementById("list_ids");
        // For Bootstrap Multiselect, find the multiselect button instead of Choices container
        const listMultiselectButton = listDropdown ? listDropdown.nextElementSibling?.querySelector('.multiselect') : null;
        const listMultiselectContainer = listDropdown ? listDropdown.closest('.form-group, .col-md-12, .col-12')?.querySelector('.btn-group .multiselect') : null;
        const sendingServerDropdown = document.getElementById("sending_server_ids");
        // For Bootstrap Multiselect, find the multiselect button instead of Choices container
        const multiselectButton = sendingServerDropdown ? sendingServerDropdown.nextElementSibling?.querySelector('.multiselect') : null;
        const multiselectContainer = sendingServerDropdown ? sendingServerDropdown.closest('.form-group, .col-md-12, .col-12')?.querySelector('.btn-group .multiselect') : null;

        // Force form validation
        if (form.checkValidity() === false) {
            e.preventDefault(); // Prevent SmartWizard navigation
            form.classList.add("was-validated"); // Add Bootstrap validation styles

            // Handle Bootstrap Multiselect validation for lists
            if (listDropdown) {
                var listSelectedValues = $(listDropdown).val();
                var listIsValid = false;
                
                if (listSelectedValues === null || listSelectedValues === undefined) {
                    listIsValid = false;
                } else if (Array.isArray(listSelectedValues)) {
                    var listValidValues = listSelectedValues.filter(function(val) { 
                        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
                    });
                    listIsValid = listValidValues.length > 0;
                } else if (typeof listSelectedValues === 'string') {
                    listIsValid = listSelectedValues.trim() !== '' && listSelectedValues !== null;
                }
                
                if (listIsValid) {
                    var $listSelectedOptions = $(listDropdown).find('option:selected[value!=""]');
                    listIsValid = $listSelectedOptions.length > 0;
                }
                
                var $listMultiselectBtn = listMultiselectButton ? $(listMultiselectButton) : (listMultiselectContainer ? $(listMultiselectContainer) : $(listDropdown).next('.btn-group').find('.multiselect'));
                
                if (!listIsValid) {
                    if ($listMultiselectBtn.length > 0) {
                        $listMultiselectBtn.addClass("is-invalid").css({
                            'border-color': '#dc3545',
                            'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
                        });
                    }
                    $(listDropdown).addClass("is-invalid");
                } else {
                    if ($listMultiselectBtn.length > 0) {
                        $listMultiselectBtn.removeClass("is-invalid").css({
                            'border-color': '',
                            'box-shadow': ''
                        });
                        $listMultiselectBtn.addClass("is-valid");
                    }
                    $(listDropdown).removeClass("is-invalid");
                }
            }

            // Handle Bootstrap Multiselect validation
            if (sendingServerDropdown) {
                var selectedValues = $(sendingServerDropdown).val();
                var isValid = false;
                
                if (selectedValues === null || selectedValues === undefined) {
                    isValid = false;
                } else if (Array.isArray(selectedValues)) {
                    var validValues = selectedValues.filter(function(val) { 
                        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
                    });
                    isValid = validValues.length > 0;
                } else if (typeof selectedValues === 'string') {
                    isValid = selectedValues.trim() !== '' && selectedValues !== null;
                }
                
                if (isValid) {
                    var $selectedOptions = $(sendingServerDropdown).find('option:selected[value!=""]');
                    isValid = $selectedOptions.length > 0;
                }
                
                var $multiselectBtn = multiselectButton ? $(multiselectButton) : (multiselectContainer ? $(multiselectContainer) : $(sendingServerDropdown).next('.btn-group').find('.multiselect'));
                
                if (!isValid) {
                    if ($multiselectBtn.length > 0) {
                        $multiselectBtn.addClass("is-invalid").css({
                            'border-color': '#dc3545',
                            'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
                        });
                    }
                    $(sendingServerDropdown).addClass("is-invalid");
                } else {
                    if ($multiselectBtn.length > 0) {
                        $multiselectBtn.removeClass("is-invalid").css({
                            'border-color': '',
                            'box-shadow': ''
                        });
                        $multiselectBtn.addClass("is-valid");
                    }
                    $(sendingServerDropdown).removeClass("is-invalid");
                }
            }

            return false; // Stop navigation
        } else {
            // Remove invalid styling from lists multiselect
            if (listDropdown) {
                var $listMultiselectBtn = listMultiselectButton ? $(listMultiselectButton) : (listMultiselectContainer ? $(listMultiselectContainer) : $(listDropdown).next('.btn-group').find('.multiselect'));
                if ($listMultiselectBtn.length > 0) {
                    $listMultiselectBtn.removeClass("is-invalid").css({
                        'border-color': '',
                        'box-shadow': ''
                    });
                }
                $(listDropdown).removeClass("is-invalid");
            }
            // Remove invalid styling from sending server multiselect
            if (sendingServerDropdown) {
                var $multiselectBtn = multiselectButton ? $(multiselectButton) : (multiselectContainer ? $(multiselectContainer) : $(sendingServerDropdown).next('.btn-group').find('.multiselect'));
                if ($multiselectBtn.length > 0) {
                    $multiselectBtn.removeClass("is-invalid").css({
                        'border-color': '',
                        'box-shadow': ''
                    });
                }
                $(sendingServerDropdown).removeClass("is-invalid");
            }
        }
    }
    return true; // Allow navigation if valid
});


let multipleDays;
    (function () {
      "use strict";
      multipleDays = new Choices(document.getElementById('days'), {
        searchEnabled: true,
        removeItemButton: true,
        placeholder: true, // Optional: Show placeholder text
        shouldSort: false, // Prevents automatic sorting
      });
    })();

function updateEndTime() {
        const startTime = parseInt(document.getElementById('startTime').value);
        const endTimeSelect = document.getElementById('endTime');

        // Clear existing options
        for (let i = endTimeSelect.options.length - 1; i >= 0; i--) {
            endTimeSelect.remove(i);
        }

        // Add new options that are greater than the selected start time
        for (let i = startTime + 1; i <= 24; i++) {
            const option = document.createElement("option");
            option.value = i;
            option.text = `${i <= 12 ? i : i - 12} ${i < 12 || i == 24 ? 'AM' : 'PM'}`;
            endTimeSelect.add(option);
        }
    }

    $("#delivery_timing").change(function() {
      $("#delivery_timing_options").slideToggle('slow');
    });

    // Validate subject field when sending content changes
    $('#sending_content').on('change', function() {
        validateSubjectField();
    });

    // Validate subject field when subject input changes
    $('#email_subject').on('input blur', function() {
        validateSubjectField();
    });

    // Validate sending datetime when send option changes
    $('#send-option').on('change', function() {
        validateSendingDatetime();
    });

    // Validate sending datetime when datetime input changes
    $('#send_datetime').on('input blur', function() {
        validateSendingDatetime();
    });

    // Validate days when delivery timing changes
    $('#delivery_timing').on('change', function() {
        validateDaysField();
    });

    // Validate days when days input changes
    $('#days').on('input blur change', function() {
        validateDaysField();
    });

    // Validate speed fields when speed changes
    $('#speed').on('change', function() {
        validateSpeedFields();
    });

    // Validate speed fields when limit input changes
    $('#limit').on('input blur', function() {
        validateSpeedFields();
    });

    // Validate speed fields when pause limit input changes
    $('#pause_limit').on('input blur', function() {
        validateSpeedFields();
    });

    // Function to validate sending datetime
    function validateSendingDatetime() {
        var sendOption = $('#send-option').val();
        var sendDatetime = $('#send_datetime').val().trim();
        
        if (sendOption === 'later' && sendDatetime === '') {
            $('#send_datetime').addClass('is-invalid');
            $('#send_datetime').css('border-color', 'red');
        } else {
            $('#send_datetime').removeClass('is-invalid');
            $('#send_datetime').css('border-color', '');
        }
    }

    // Function to validate days field
    function validateDaysField() {
        var deliveryTiming = $('#delivery_timing').val();
        var days = $('#days').val();
        
        // For multiple choice fields, check if any values are selected
        var hasSelectedDays = false;
        if (Array.isArray(days)) {
            hasSelectedDays = days.length > 0;
        } else {
            hasSelectedDays = days !== '' && days !== null && days !== undefined;
        }
        
        if (deliveryTiming === 'specific_hours' && !hasSelectedDays) {
            $('#days').addClass('is-invalid');
            $('#days').css('border-color', 'red');
        } else {
            $('#days').removeClass('is-invalid');
            $('#days').css('border-color', '');
        }
    }

    // Function to validate speed fields
    function validateSpeedFields() {
        var speed = $('#speed').val();
        var limit = $('#limit').val();
        var pauseLimit = $('#pause_limit').val();
        
        // Fallback: Try different possible field IDs for pause_limit
        if (!pauseLimit || pauseLimit === '' || pauseLimit === null || pauseLimit === undefined) {
            pauseLimit = $('#pause-limit').val() || $('#pauseLimit').val() || $('#pause_limit').val() || $('#pause-limit').val();
        }
        
        if (speed === 'limited') {
            // Validate limit field - check if it's a valid number (including 0)
            var limitNum = parseFloat(limit);
            var limitValid = !isNaN(limitNum) && limit !== '' && limit !== null && limit !== undefined;
            
            if (!limitValid) {
                $('#limit').addClass('is-invalid');
                $('#limit').css('border-color', 'red');
            } else {
                $('#limit').removeClass('is-invalid');
                $('#limit').css('border-color', '');
            }
            
            // Clear pause_limit validation (no validation required)
            $('#pause_limit').removeClass('is-invalid');
            $('#pause_limit').css('border-color', '');
        } else {
            // When speed is not limited, clear validation
            $('#limit').removeClass('is-invalid');
            $('#pause_limit').removeClass('is-invalid');
            $('#limit').css('border-color', '');
            $('#pause_limit').css('border-color', '');
        }
    }

    // Function to validate subject field
    function validateSubjectField() {
        var sendingContent = $('#sending_content').val();
        var subject = $('#email_subject').val().trim();
        
        if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
            $('#email_subject').addClass('is-invalid');
            $('#email_subject').css('border-color', 'red');
        } else {
            $('#email_subject').removeClass('is-invalid');
            $('#email_subject').css('border-color', '');
        }
    }

    // Initial validation when page loads
    $(document).ready(function() {
        setTimeout(function() {
            validateSubjectField();
        }, 1000);
    });

    // Validate when switching to tab 2
    $('#smartwizard').on('stepContent', function(e, anchorObject, stepNumber, stepDirection) {
        console.log('Step content event - Step:', stepNumber, 'Direction:', stepDirection);
        
        // When entering step 2 (Campaign Detail)
        if (stepNumber === 1 || anchorObject.attr('href') === '#step-2') {
            setTimeout(function() {
                validateSubjectField();
            }, 100);
        }
    });

    // Also validate when step 2 becomes active
    $(document).on('DOMNodeInserted', function(e) {
        if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
            setTimeout(function() {
                validateSubjectField();
            }, 100);
        }
    });

    // Override the wizard's next button functionality
    $(document).on('click', '.sw-btn-next', function(e) {
        console.log('Next button clicked');
        
        // Check if we're on step 2
        if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
            var sendingContent = $('#sending_content').val();
            var subject = $('#email_subject').val().trim();
            
            console.log('Validating on next click - Sending content:', sendingContent, 'Subject:', subject);
            
            if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                $('#email_subject').addClass('is-invalid');
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                return false;
            } else {
                $('#email_subject').removeClass('is-invalid');
            }
        }
    });

    // Try to intercept the wizard's step change with a more aggressive approach
    $(document).on('click', 'a[href="#step-3"]', function(e) {
        console.log('Trying to go to step 3');
        
        // Check if we're on step 2
        if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
            var sendingContent = $('#sending_content').val();
            var subject = $('#email_subject').val().trim();
            
            console.log('Validating step 2 to step 3 - Sending content:', sendingContent, 'Subject:', subject);
            
            if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                $('#email_subject').addClass('is-invalid');
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                return false;
            } else {
                $('#email_subject').removeClass('is-invalid');
            }
        }
    });

    // Try to intercept all wizard navigation
    $(document).on('click', '.nav-link', function(e) {
        var href = $(this).attr('href');
        console.log('Nav link clicked:', href);
        
        if (href === '#step-3') {
            // Check if we're on step 2
            if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
                var sendingContent = $('#sending_content').val();
                var subject = $('#email_subject').val().trim();
                
                console.log('Validating nav link - Sending content:', sendingContent, 'Subject:', subject);
                
                if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                    $('#email_subject').addClass('is-invalid');
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    return false;
                } else {
                    $('#email_subject').removeClass('is-invalid');
                }
            }
        }
    });

    // Simple approach - disable next button when subject is invalid
    setInterval(function() {
        // Check which step is actually active
        var activeStep = null;
        if ($('#step-1').hasClass('active') || $('#step-1').is(':visible')) activeStep = 1;
        else if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) activeStep = 2;
        else if ($('#step-3').hasClass('active') || $('#step-3').is(':visible')) activeStep = 3;
        else if ($('#step-4').hasClass('active') || $('#step-4').is(':visible')) activeStep = 4;
        
        // Only validate when we're on step 2
        if (activeStep === 2) {
            var sendingContent = $('#sending_content').val();
            var subject = $('#email_subject').val().trim();
            
            if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                $('#email_subject').addClass('is-invalid');
                $('#email_subject').css('border-color', 'red');
                // Disable next button only, keep previous button enabled
                $('.sw-btn-next').show().prop('disabled', true).addClass('disabled');
                $('.sw-btn-prev').prop('disabled', false).removeClass('disabled');
            } else {
                $('#email_subject').removeClass('is-invalid');
                $('#email_subject').css('border-color', '');
                // Enable next button, keep previous button enabled
                $('.sw-btn-next').show().prop('disabled', false).removeClass('disabled');
                $('.sw-btn-prev').prop('disabled', false).removeClass('disabled');
            }
        } else if (activeStep === 3) {
            // Validate step 3 - sending datetime when send is "later"
            var sendOption = $('#send-option').val();
            var sendDatetime = $('#send_datetime').val().trim();
            var deliveryTiming = $('#delivery_timing').val();
            var days = $('#days').val();
            var speed = $('#speed').val();
            var limit = $('#limit').val();
            var pauseLimit = $('#pause_limit').val();
            
            var isInvalid = false;
            
            // Check sending datetime validation
            if (sendOption === 'later' && sendDatetime === '') {
                $('#send_datetime').addClass('is-invalid');
                $('#send_datetime').css('border-color', 'red');
                isInvalid = true;
            } else {
                $('#send_datetime').removeClass('is-invalid');
                $('#send_datetime').css('border-color', '');
            }
            
            // Check days validation when delivery timing is specific_hours
            var hasSelectedDays = false;
            if (Array.isArray(days)) {
                hasSelectedDays = days.length > 0;
            } else {
                hasSelectedDays = days !== '' && days !== null && days !== undefined;
            }
            
            if (deliveryTiming === 'specific_hours' && !hasSelectedDays) {
                $('#days').addClass('is-invalid');
                $('#days').css('border-color', 'red');
                isInvalid = true;
            } else {
                $('#days').removeClass('is-invalid');
                $('#days').css('border-color', '');
            }
            
            // Check speed validation when speed is limited
            if (speed === 'limited') {
                // Check if limit is a valid number (including 0)
                var limitNum = parseFloat(limit);
                var limitValid = !isNaN(limitNum) && limit !== '' && limit !== null && limit !== undefined;
                
                if (!limitValid) {
                    $('#limit').addClass('is-invalid');
                    $('#limit').css('border-color', 'red');
                    isInvalid = true;
                } else {
                    $('#limit').removeClass('is-invalid');
                    $('#limit').css('border-color', '');
                }
                
                // Clear pause_limit validation (no validation required)
                $('#pause_limit').removeClass('is-invalid');
                $('#pause_limit').css('border-color', '');
            } else {
                // When speed is not limited, clear validation
                $('#limit').removeClass('is-invalid');
                $('#pause_limit').removeClass('is-invalid');
                $('#limit').css('border-color', '');
                $('#pause_limit').css('border-color', '');
            }
            
            if (isInvalid) {
                // Disable next button only, keep previous button enabled
                $('.sw-btn-next').show().prop('disabled', true).addClass('disabled');
                $('.sw-btn-prev').prop('disabled', false).removeClass('disabled');
            } else {
                // Enable next button, keep previous button enabled
                $('.sw-btn-next').show().prop('disabled', false).removeClass('disabled');
                $('.sw-btn-prev').prop('disabled', false).removeClass('disabled');
            }
        } else {
            // When not on step 2 or 3, check which step we're on
            if (activeStep === 1) {
                // Step 1: Force enable next, force disable previous (no validation)
                $('.sw-btn-next').show().prop('disabled', false).removeClass('disabled');
                $('.sw-btn-prev').prop('disabled', true).addClass('disabled');
                return; // Exit early to prevent any other validation
            } else {
                // Step 4 or other: Hide next button, enable previous
                $('.sw-btn-next').hide();
                $('.sw-btn-prev').prop('disabled', false).removeClass('disabled');
            }
            
            // Clear all validation states
            $('#email_subject').removeClass('is-invalid');
            $('#send_datetime').removeClass('is-invalid');
            $('#days').removeClass('is-invalid');
            $('#limit').removeClass('is-invalid');
            $('#pause_limit').removeClass('is-invalid');
            $('#email_subject').css('border-color', '');
            $('#send_datetime').css('border-color', '');
            $('#days').css('border-color', '');
            $('#limit').css('border-color', '');
            $('#pause_limit').css('border-color', '');
        }
    }, 500);

    // Try to intercept the wizard's step change
    $(document).on('click', 'a[href="#step-3"]', function(e) {
        console.log('Trying to go to step 3');
        
        // Check if we're on step 2
        if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
            var sendingContent = $('#sending_content').val();
            var subject = $('#email_subject').val().trim();
            
            console.log('Validating step 2 to step 3 - Sending content:', sendingContent, 'Subject:', subject);
            
            if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                $('#email_subject').addClass('is-invalid');
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                return false;
            } else {
                $('#email_subject').removeClass('is-invalid');
            }
        }
    });

    // Try to intercept all wizard navigation
    $(document).on('click', '.nav-link', function(e) {
        var href = $(this).attr('href');
        console.log('Nav link clicked:', href);
        
        if (href === '#step-3') {
            // Check if we're on step 2
            if ($('#step-2').hasClass('active') || $('#step-2').is(':visible')) {
                var sendingContent = $('#sending_content').val();
                var subject = $('#email_subject').val().trim();
                
                console.log('Validating nav link - Sending content:', sendingContent, 'Subject:', subject);
                
                if ((sendingContent === 'html' || sendingContent === 'text') && subject === '') {
                    $('#email_subject').addClass('is-invalid');
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    return false;
                } else {
                    $('#email_subject').removeClass('is-invalid');
                }
            }
        }
    });
