$(function() {
	'use strict';
  $('.repeater-contact').repeater({
    show: function () {
      $(this).slideDown();
    },
    hide: function (deleteElement) {
      swal({
      title: "",
      text: $('#segment_delete_msg').data('value'),
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Yes",
      closeOnConfirm: false
    }, function (isConfirm) {
      if(isConfirm) {
        $(this).slideUp(deleteElement);
        swal.close(); // **Manually close the alert**
      }
    });

    },
    isFirstItemUndeletable: true
  });

	flatpickr("#datetime", {
    enableTime: false,
    time_24hr: false, // Use 12-hour format with AM/PM
    dateFormat: "Y-m-d", // User-friendly format
    disableMobile: true,
	});
});
function loadContactAction($this, placeholder_values='Use comma for multiples') {
  var contact_filter_action = $this.name.replace('name', 'action');
  var contact_filter_value = $this.name.replace('name', 'value');
  var select_action =  $("[name='"+contact_filter_action+"']");
  var select_value =  $("[name='"+contact_filter_value+"']");

  if($this.value == '') {
    select_action.replaceWith(
      "<select class='form-control' name='"+contact_filter_action+"'></select>"
    );
    select_value.replaceWith(
      "<select class='form-control' name='"+contact_filter_value+"'></select>"
    );
  } else if($this.value == 'email') {
    select_action.replaceWith(
      "<select class='form-select' name='"+contact_filter_action+"'>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "<option value='contain'>contain</option>"+
      "<option value='not_contain'>doesn\'t</option>"+
      "</select>"
    );
    select_value.replaceWith(
      "<input type='text' class='form-control' placeholder='"+placeholder_values+"' name='"+contact_filter_value+"' >"
    );
  } else {
    select_action.replaceWith(
      "<select class='form-select' name='"+contact_filter_action+"'>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "</select>"
    );

    if($this.value == 'status') {
      select_value.replaceWith(
        "<select class='form-select' name='"+contact_filter_value+"'>"+
        "<option value='active'>Active</option>"+
        "<option value='inactive'>Inactive</option>"+
        "</select>"
      );
    } else if($this.value == 'source') {
      select_value.replaceWith(
        "<select class='form-select' name='"+contact_filter_value+"'>"+
        "<option value='app'>App</option>"+
        "<option value='import'>Import</option>"+
        "</select>"
      );
    }
  }
}

function loadDate($this) {
  var date_filter_value = $this.name.replace('action', 'value');
  var date_value =  $("input[name='"+date_filter_value+"']");
  flatpickr(date_value, {
    enableTime: false,
    time_24hr: false, // Use 12-hour format with AM/PM
    dateFormat: "Y-m-d", // User-friendly format
    disableMobile: true,
  });
}

function loadCustomFieldAction($this, placeholder_values='Use comma for multiples') {
  var custom_fields_filter_action = $this.name.replace('name', 'action');
  var custom_fields_filter_value = $this.name.replace('name', 'value');
  var select_action =  $("[name='"+custom_fields_filter_action+"']");
  var select_value =  $("[name='"+custom_fields_filter_value+"']");

  if($this.value == '') {
    select_action.replaceWith(
      "<select class='form-control' name='"+custom_fields_filter_action+"'>"+
      "<option value=''></option>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "<option value='contain'>contain</option>"+
      "<option value='not_contain'>doesn't</option>"+
      "</select>"
    );
    select_value.replaceWith(
      "<input type='text' class='form-control' placeholder='"+placeholder_values+"' name='"+custom_fields_filter_value+"' >"
    );
  }
}

function loadDateFieldAction($this) {
  var date_filter_action = $this.name.replace('name', 'action');
  var date_filter_value = $this.name.replace('name', 'value');
  var select_action =  $("[name='"+date_filter_action+"']");
  var select_value =  $("[name='"+date_filter_value+"']");

  if($this.value == '') {
    select_action.replaceWith(
      "<select class='form-control' name='"+date_filter_action+"' onchange='loadDate(this)'>"+
      "<option value=''></option>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "<option value='after'>after</option>"+
      "<option value='before'>before</option>"+
      "</select>"
    );
    select_value.replaceWith(
      "<input type='text' class='form-control' id='datetime' name='"+date_filter_value+"' >"
    );
  }
}