'use strict';
   (function () {
        // Set initial required state and visibility if "later" is already selected
        var initialSendValue = $("#send").val();
        if (initialSendValue === 'later') {
          $("#send_datetime").attr('required', 'required');
          $("#send_datetime_div").show();
        }
        
        $("#send").change(function() {
        var value = $("#send").val();
        var $sendDatetime = $("#send_datetime");
        if (value === 'later') {
          $("#send_datetime_div").show('slow');
          // Make send_datetime required when "Later" is selected
          $sendDatetime.attr('required', 'required');
        } else {
          $("#send_datetime_div").hide('slow');
          // Remove required attribute when "Now" is selected
          $sendDatetime.removeAttr('required');
          // Clear any validation errors
          $sendDatetime.removeClass('is-invalid');
          var $feedback = $sendDatetime.siblings('.invalid-feedback');
          if ($feedback.length === 0) {
            $feedback = $sendDatetime.closest('.form-group').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
    });
    
    // Clear validation when send_datetime is changed
    $("#send_datetime").on('change', function() {
        var $sendDatetime = $(this);
        var sendValue = $("#send").val();
        if (sendValue === 'later') {
            var datetimeValue = $sendDatetime.val();
            if (datetimeValue && datetimeValue.trim() !== '') {
                $sendDatetime.removeClass('is-invalid');
                var $feedback = $sendDatetime.siblings('.invalid-feedback');
                if ($feedback.length === 0) {
                    $feedback = $sendDatetime.closest('.form-group').find('.invalid-feedback');
                }
                if ($feedback.length > 0) {
                    $feedback.hide();
                }
            }
        }
    });
    var sendDatetimeElement = document.querySelector("#send_datetime");
    if (sendDatetimeElement) {
        flatpickr("#send_datetime", {
            enableTime: true,
            time_24hr: false, // Use 12-hour format with AM/PM
            minDate: "today",
            dateFormat: "Y-m-d h:i K", // User-friendly format
            defaultDate: sendDatetimeElement.value || null, // Pre-filled value from server
            disableMobile: true,
            onReady: function (selectedDates, dateStr, instance) {
                // Trigger the same behavior as onChange for the default value
                handleDateChange(instance.selectedDates[0], dateStr);
            },
            onChange: function (selectedDates, dateStr, instance) {
                if (selectedDates.length > 0) {
                    handleDateChange(selectedDates[0], dateStr);
                    // Clear validation when date is selected
                    var $sendDatetime = $("#send_datetime");
                    $sendDatetime.removeClass('is-invalid');
                    var $feedback = $sendDatetime.siblings('.invalid-feedback');
                    if ($feedback.length === 0) {
                        $feedback = $sendDatetime.closest('.form-group').find('.invalid-feedback');
                    }
                    if ($feedback.length > 0) {
                        $feedback.hide();
                    }
                }
            },
        });
    }
    window.addEventListener('load', function () {
        var forms = document.getElementsByClassName('needs-validation');
        if (!forms || forms.length === 0) {
            return; // No forms found, exit early
        }
        Array.prototype.filter.call(forms, function (form) {
            if (!form || typeof form !== 'object' || !form.addEventListener) {
                return; // Skip invalid form elements
            }
            try {
                form.addEventListener('submit', function (event) {
                    if (!form || typeof form !== 'object' || typeof form.checkValidity !== 'function') {
                        event.preventDefault();
                        return; // Skip if form is invalid
                    }
                    try {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                            const listDropdown = document.getElementById("list_ids");
                            // For Bootstrap Multiselect, find the multiselect button instead of Choices container
                            let listMultiselectButton = null;
                            let listMultiselectContainer = null;
                            if (listDropdown && listDropdown.nextElementSibling) {
                        const nextSibling = listDropdown.nextElementSibling;
                        if (nextSibling && typeof nextSibling.querySelector === 'function') {
                            const multiselectBtn = nextSibling.querySelector('.multiselect');
                            if (multiselectBtn) {
                                listMultiselectButton = multiselectBtn;
                            }
                        }
                                if (listDropdown.closest && typeof listDropdown.closest === 'function') {
                                    const parentContainer = listDropdown.closest('.form-group, .col-md-12, .col-12');
                                    if (parentContainer && typeof parentContainer.querySelector === 'function') {
                                        const multiselectContainer = parentContainer.querySelector('.btn-group .multiselect');
                                        if (multiselectContainer) {
                                            listMultiselectContainer = multiselectContainer;
                                        }
                                    }
                                }
                            }
                            
                            const sendingServerDropdown = document.getElementById("sending_server_ids");
                            // For Bootstrap Multiselect, find the multiselect button instead of Choices container
                            let multiselectButton = null;
                            let multiselectContainer = null;
                            if (sendingServerDropdown && sendingServerDropdown.nextElementSibling) {
                        const nextSibling = sendingServerDropdown.nextElementSibling;
                        if (nextSibling && typeof nextSibling.querySelector === 'function') {
                            const multiselectBtn = nextSibling.querySelector('.multiselect');
                            if (multiselectBtn) {
                                multiselectButton = multiselectBtn;
                            }
                        }
                                if (sendingServerDropdown.closest && typeof sendingServerDropdown.closest === 'function') {
                                    const parentContainer = sendingServerDropdown.closest('.form-group, .col-md-12, .col-12');
                                    if (parentContainer && typeof parentContainer.querySelector === 'function') {
                                        const multiselectContainerEl = parentContainer.querySelector('.btn-group .multiselect');
                                        if (multiselectContainerEl) {
                                            multiselectContainer = multiselectContainerEl;
                                        }
                                    }
                                }
                            }
                            const campaignDropdown = document.getElementById("broadcast_ids");
                            // For campaign dropdown, use Bootstrap Multiselect (same as lists)
                            let campaignMultiselectButton = null;
                            let campaignMultiselectContainer = null;
                            
                            if (campaignDropdown && campaignDropdown.nextElementSibling) {
                                // Check for Bootstrap Multiselect button
                                const nextSibling = campaignDropdown.nextElementSibling;
                                if (nextSibling && typeof nextSibling.querySelector === 'function') {
                                    const multiselectBtn = nextSibling.querySelector('.multiselect');
                                    if (multiselectBtn) {
                                        campaignMultiselectButton = multiselectBtn;
                                    }
                                }
                                // Check parent container for multiselect
                                if (campaignDropdown.closest && typeof campaignDropdown.closest === 'function') {
                                    const parentContainer = campaignDropdown.closest('.form-group, .col-md-12, .col-12');
                                    if (parentContainer && typeof parentContainer.querySelector === 'function') {
                                        const multiselectContainer = parentContainer.querySelector('.btn-group .multiselect');
                                        if (multiselectContainer) {
                                            campaignMultiselectContainer = multiselectContainer;
                                        }
                                    }
                                }
                            }

                            // Handle Bootstrap Multiselect validation for lists
                            if (listDropdown && !listDropdown.disabled) {
                        try {
                            var listSelectedValues = $(listDropdown).val();
                            var listIsValid = false;
                            
                            if (listSelectedValues === null || listSelectedValues === undefined) {
                                listIsValid = false;
                            } else if (Array.isArray(listSelectedValues)) {
                                var listValidValues = listSelectedValues.filter(function(val) { 
                                    return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
                                });
                                listIsValid = listValidValues.length > 0;
                            } else if (typeof listSelectedValues === 'string') {
                                listIsValid = listSelectedValues.trim() !== '' && listSelectedValues !== null;
                            }
                            
                            if (listIsValid) {
                                var $listSelectedOptions = $(listDropdown).find('option:selected[value!=""]');
                                listIsValid = $listSelectedOptions.length > 0;
                            }
                            
                            var $listMultiselectBtn = listMultiselectButton ? $(listMultiselectButton) : (listMultiselectContainer ? $(listMultiselectContainer) : $(listDropdown).next('.btn-group').find('.multiselect'));
                            
                            if (!listIsValid) {
                                if ($listMultiselectBtn.length > 0) {
                                    $listMultiselectBtn.addClass("is-invalid").css({
                                        'border-color': '#dc3545',
                                        'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
                                    });
                                }
                                $(listDropdown).addClass("is-invalid");
                            } else {
                                if ($listMultiselectBtn.length > 0) {
                                    $listMultiselectBtn.removeClass("is-invalid").css({
                                        'border-color': '',
                                        'box-shadow': ''
                                    });
                                    $listMultiselectBtn.addClass("is-valid");
                                }
                                $(listDropdown).removeClass("is-invalid");
                            }
                        } catch(e) {
                            console.warn('Error validating list dropdown:', e);
                        }
                    }

                            // Handle Bootstrap Multiselect validation for broadcasts (same as lists)
                            if (campaignDropdown && !campaignDropdown.disabled) {
                        try {
                            var campaignSelectedValues = $(campaignDropdown).val();
                            var campaignIsValid = false;
                            
                            if (campaignSelectedValues === null || campaignSelectedValues === undefined) {
                                campaignIsValid = false;
                            } else if (Array.isArray(campaignSelectedValues)) {
                                var campaignValidValues = campaignSelectedValues.filter(function(val) { 
                                    return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
                                });
                                campaignIsValid = campaignValidValues.length > 0;
                            } else if (typeof campaignSelectedValues === 'string') {
                                campaignIsValid = campaignSelectedValues.trim() !== '' && campaignSelectedValues !== null;
                            }
                            
                            if (campaignIsValid) {
                                var $campaignSelectedOptions = $(campaignDropdown).find('option:selected[value!=""]');
                                campaignIsValid = $campaignSelectedOptions.length > 0;
                            }
                            
                            var $campaignMultiselectBtn = campaignMultiselectButton ? $(campaignMultiselectButton) : (campaignMultiselectContainer ? $(campaignMultiselectContainer) : $(campaignDropdown).next('.btn-group').find('.multiselect'));
                            
                            if (!campaignIsValid) {
                                if ($campaignMultiselectBtn.length > 0) {
                                    $campaignMultiselectBtn.addClass("is-invalid").css({
                                        'border-color': '#dc3545',
                                        'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
                                    });
                                }
                                $(campaignDropdown).addClass("is-invalid");
                                
                                // Show validation feedback
                                var $feedback = $('#broadcast_ids_feedback');
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).next('.invalid-feedback');
                                }
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).siblings('.invalid-feedback');
                                }
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
                                }
                                if ($feedback.length > 0) {
                                    $feedback.show();
                                }
                            } else {
                                if ($campaignMultiselectBtn.length > 0) {
                                    $campaignMultiselectBtn.removeClass("is-invalid").css({
                                        'border-color': '',
                                        'box-shadow': ''
                                    });
                                    $campaignMultiselectBtn.addClass("is-valid");
                                }
                                $(campaignDropdown).removeClass("is-invalid");
                                
                                // Hide validation feedback
                                var $feedback = $('#broadcast_ids_feedback');
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).next('.invalid-feedback');
                                }
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).siblings('.invalid-feedback');
                                }
                                if ($feedback.length === 0) {
                                    $feedback = $(campaignDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
                                }
                                if ($feedback.length > 0) {
                                    $feedback.hide();
                                }
                            }
                        } catch(e) {
                            console.warn('Error validating campaign dropdown:', e);
                        }
                    }

                            // Handle Bootstrap Multiselect validation
                            if (sendingServerDropdown) {
                        var selectedValues = $(sendingServerDropdown).val();
                        var isValid = false;
                        
                        if (selectedValues === null || selectedValues === undefined) {
                            isValid = false;
                        } else if (Array.isArray(selectedValues)) {
                            var validValues = selectedValues.filter(function(val) { 
                                return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
                            });
                            isValid = validValues.length > 0;
                        } else if (typeof selectedValues === 'string') {
                            isValid = selectedValues.trim() !== '' && selectedValues !== null;
                        }
                        
                        if (isValid) {
                            var $selectedOptions = $(sendingServerDropdown).find('option:selected[value!=""]');
                            isValid = $selectedOptions.length > 0;
                        }
                        
                        var $multiselectBtn = multiselectButton ? $(multiselectButton) : (multiselectContainer ? $(multiselectContainer) : $(sendingServerDropdown).next('.btn-group').find('.multiselect'));
                        
                        if (!isValid) {
                            if ($multiselectBtn.length > 0) {
                                $multiselectBtn.addClass("is-invalid").css({
                                    'border-color': '#dc3545',
                                    'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
                                });
                            }
                            $(sendingServerDropdown).addClass("is-invalid");
                        } else {
                            if ($multiselectBtn.length > 0) {
                                $multiselectBtn.removeClass("is-invalid").css({
                                    'border-color': '',
                                    'box-shadow': ''
                                });
                                $multiselectBtn.addClass("is-valid");
                            }
                                $(sendingServerDropdown).removeClass("is-invalid");
                            }
                        }
                        }
                        
                        // Validate send_datetime when send is "later"
                        const sendDropdown = document.getElementById("send");
                        const sendDatetimeInput = document.getElementById("send_datetime");
                        if (sendDropdown && sendDatetimeInput) {
                            try {
                                var sendValue = $(sendDropdown).val();
                                var sendDatetimeValue = $(sendDatetimeInput).val();
                                
                                if (sendValue === 'later') {
                                    // send_datetime is required when send is "later"
                                    if (!sendDatetimeValue || sendDatetimeValue.trim() === '') {
                                        $(sendDatetimeInput).addClass("is-invalid");
                                        var $feedback = $(sendDatetimeInput).siblings('.invalid-feedback');
                                        if ($feedback.length === 0) {
                                            $feedback = $(sendDatetimeInput).closest('.form-group').find('.invalid-feedback');
                                        }
                                        if ($feedback.length > 0) {
                                            $feedback.show();
                                        }
                                        // Prevent form submission
                                        if (event) {
                                            event.preventDefault();
                                            event.stopPropagation();
                                        }
                                    } else {
                                        $(sendDatetimeInput).removeClass("is-invalid");
                                        var $feedback = $(sendDatetimeInput).siblings('.invalid-feedback');
                                        if ($feedback.length === 0) {
                                            $feedback = $(sendDatetimeInput).closest('.form-group').find('.invalid-feedback');
                                        }
                                        if ($feedback.length > 0) {
                                            $feedback.hide();
                                        }
                                    }
                                } else {
                                    // Clear validation when send is "now"
                                    $(sendDatetimeInput).removeClass("is-invalid");
                                    var $feedback = $(sendDatetimeInput).siblings('.invalid-feedback');
                                    if ($feedback.length === 0) {
                                        $feedback = $(sendDatetimeInput).closest('.form-group').find('.invalid-feedback');
                                    }
                                    if ($feedback.length > 0) {
                                        $feedback.hide();
                                    }
                                }
                            } catch(e) {
                                console.warn('Error validating send_datetime:', e);
                            }
                        }
                        
                        // Add was-validated class to form (always, whether valid or invalid)
                        if (form && typeof form === 'object' && form.classList && typeof form.classList.add === 'function') {
                            try {
                                form.classList.add('was-validated');
                            } catch(e) {
                                console.warn('Error adding was-validated class:', e);
                            }
                        }
                    } catch(e) {
                        console.error('Error in form submit handler:', e);
                        if (event) {
                            event.preventDefault();
                        }
                    }
            }, false);
            } catch(e) {
                console.error('Error adding submit listener to form:', e);
            }
        });
    }, false);
})();