$(function() {
  'use strict';
  $('#btn-update').on('click', function() {
    var $btn = $(this);
    var $icon = $btn.find('i');
    
    // Show loading spinner
    $icon.removeClass('bi-arrow-up-circle').addClass('spinner-border spinner-border-sm');
    
    Swal.fire({
      title: '',
      text: $('#update-proceed-msg').data('value'),
      icon: 'warning',
      showCancelButton: true,
      cancelButtonText: "Cancel",
      cancelButtonClass: "btn-danger",
      confirmButtonClass: "btn-primary",
      confirmButtonText: "Yes"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: '/update_app',
          method: 'POST',
          data: {do_update: 1},
          beforeSend: function() {
            $('#msg').html($('#update-warning-msg').data('value'));
            $('#msg').addClass('text-danger');
            $('#msg').removeClass('text-success');
          },
          success: function(result) {
            if(!result.verify) {
              $('#msg').addClass('text-danger');
              $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-arrow-up-circle');
            } else {
              $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-arrow-up-circle');
              $('#msg').removeClass('text-danger');
              $('#msg').addClass('text-success');
              $('#btn-update').hide();
            }
            if(result.message) {
              $('#msg').html(result.message);
            }
            else {
              $('#msg').html(result);
            }
          },
          error: function(xhr) {
            $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-arrow-up-circle');
            $('#msg').addClass('text-danger');
            $('#msg').removeClass('text-success');
            if (xhr.status === 401) { 
              $('#msg').html('You do not have permission to update the application. Please contact your administrator.');
            } else if (xhr.status === 403) { 
              $('#msg').html('Access forbidden. You do not have the required permissions.');
            } else { 
              $('#msg').html('An error occurred while trying to update the application. Please try again.');
            }
          }
        });
      } else {
        $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-arrow-up-circle');
      }
    });
  });
});