<?php
if (!isset($_SESSION)) session_start();
$server = $_SERVER['SERVER_NAME'];

$session_user_id = !empty($_SESSION['user_id']) ? $_SESSION['user_id'] : $_GET['su_id'];
$_SESSION['lang'] = !empty($_SESSION['langCode']) ? $_SESSION['langCode'] : $_GET['langCode'];
$upload_folder="/images/users/{$session_user_id}/gallery/";
$full_adr=$server.$upload_folder;
$full_browse_dir=$_SERVER["DOCUMENT_ROOT"].$upload_folder;
$_SESSION['upload_adr']=$full_browse_dir;

include('lang.php');


//Stuff related to my site
//You can delete this, if you do not need
//******************************************************
if(isset($_SESSION["id"])){ $ses_id=$_SESSION["id"];
if(!file_exists($full_browse_dir."/".$ses_id))
{ 
    mkdir($full_browse_dir."/".$ses_id, 0777, true);
}
$full_adr=$full_adr.$ses_id."/";
$full_browse_dir=$full_browse_dir.$ses_id."/";
$upload_folder=$upload_folder.$ses_id."/";
$_SESSION['upload_adr']=$full_browse_dir;
}
//*******************************************************
function check_jpeg($f, $fix=false ){
# [070203]
# check for jpeg file header and footer - also try to fix it
    if ( false !== (@$fd = fopen($f, 'r+b' )) ){
        if ( fread($fd,2)==chr(255).chr(216) ){
            fseek ( $fd, -2, SEEK_END );
            if ( fread($fd,2)==chr(255).chr(217) ){
                fclose($fd);
                return true;
            }else{
                if ( $fix && fwrite($fd,chr(255).chr(217)) ){return true;}
                fclose($fd);
                return false;
            }
        }else{fclose($fd); return false;}
    }else{
        return false;
    }
}
//*******************************************************
/*function imageCreateFromAny($filepath) {
    $type = exif_imagetype($filepath); // [] if you don't have exif you could use getImageSize()
    $allowedTypes = array(
        1,  // [] gif
        2,  // [] jpg
        3,  // [] png
        4,  // [] jpeg
        6   // [] bmp
    );
    if (!in_array($type, $allowedTypes)) {
        return false;
    }
    switch ($type) {
        case 1 :
            $im = imagecreatefromgif($filepath);
        break;
        case 2 :
            $im = imagecreatefromjpeg($filepath);
        break;
        case 3 :
        
            $im = imagecreatefrompng($filepath);
        break;
        case 6 :
            $im = imagecreatefromwbmp($filepath);
        break;
    }   
    return $im; 
} 
// create thumbnails from images
function make_thumb($folder,$src,$dest,$thumb_width) {
	$source_image = imageCreateFromAny($folder.'/'.$src);
	$width = imagesx($source_image);
	$height = imagesy($source_image);
	
	$thumb_height = floor($height*($thumb_width/$width));
	
	$virtual_image = imagecreatetruecolor($thumb_width,$thumb_height);
	
	imagecopyresampled($virtual_image,$source_image,0,0,0,0,$thumb_width,$thumb_height,$width,$height);
	
	imagejpeg($virtual_image,$dest,100);
	
}
//}*/

function imageCreateFromAny($filepath) {
    if (!file_exists($filepath)) {
        return false; // File does not exist
    }

    // Use exif_imagetype() if available, otherwise fallback to getimagesize()
    if (function_exists('exif_imagetype')) {
        $type = exif_imagetype($filepath);
    } else {
        $info = getimagesize($filepath);
        $type = $info[2] ?? false; // Make sure it's not undefined
    }

    if (!$type) {
        return false; // Could not determine image type
    }

    $imageCreateFunctions = [
        IMAGETYPE_GIF => 'imagecreatefromgif',
        IMAGETYPE_JPEG => 'imagecreatefromjpeg',
        IMAGETYPE_PNG => 'imagecreatefrompng',
        IMAGETYPE_BMP => 'imagecreatefromwbmp',
        IMAGETYPE_WEBP => 'imagecreatefromwebp' // optional: add WEBP support
    ];

    return isset($imageCreateFunctions[$type]) && function_exists($imageCreateFunctions[$type])
        ? @$imageCreateFunctions[$type]($filepath)
        : false;
}


// Create thumbnails from images
function make_thumb($folder, $src, $dest, $thumb_width) {
    $source_path = $folder . '/' . $src;
    $source_image = imageCreateFromAny($source_path);

    if (!$source_image) {
        return false; // Failed to create image
    }

    $width = imagesx($source_image);
    $height = imagesy($source_image);
    $thumb_height = (int) floor($height * ($thumb_width / $width));

    $thumb_image = imagecreatetruecolor($thumb_width, $thumb_height);
    imagecopyresampled($thumb_image, $source_image, 0, 0, 0, 0, $thumb_width, $thumb_height, $width, $height);

    $result = imagejpeg($thumb_image, $dest, 90); // Set quality to 90 instead of 100 to optimize file size

    imagedestroy($source_image);
    imagedestroy($thumb_image);

    return $result;
}


// display pagination
function print_pagination($numPages,$currentPage, $lang) {
     
   echo $lang[$_SESSION['lang']]['page'] ." ". $currentPage ." ".$lang[$_SESSION['lang']]['of']." ". $numPages;
   
   if ($numPages > 1) {
      
	   echo '&nbsp;&nbsp;';
   
       if ($currentPage > 1) {
	       $prevPage = $currentPage - 1;
	       echo '<a href="'. $_SERVER['PHP_SELF'] .'?p='. $prevPage.'">&laquo;&laquo;</a>';
	   }	   
	   
	   for( $e=0; $e < $numPages; $e++ ) {
           $p = $e + 1;
       
	       if ($p == $currentPage) {	    
		       $class = 'current-paginate';
	       } else {
	           $class = 'paginate';
	       } 
	       

		       echo '<a class="'. $class .'" href="'. $_SERVER['PHP_SELF'] .'?p='. $p .'">'. $p .'</a>';
		  	  
	   }
	   
	   if ($currentPage != $numPages) {
           $nextPage = $currentPage + 1;	
		   echo '<a href="'. $_SERVER['PHP_SELF'] .'?p='. $nextPage.'">&raquo;&raquo;</a>';
	   }	  	 
   
   }

}
?>

<head>
	    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Image Uploader</title>
    <meta name="author" content="ZmajSOft">
    
    <link rel="stylesheet" href="styles.css">

<link href="styles.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="/assets/css/sweetalert.css">
<script src="/assets/js/jquery.min.js"></script>
<script src="/assets/js/sweetalert.min.js"></script>
<script type="text/javascript">
$(document).ready(function (e) {
	$("#uploadForm").on('submit',(function(e) {
		e.preventDefault();
		$.ajax({
        	url: "upload.php",
			 type: "POST",
			data:  new FormData(this),
			contentType: false,
    	    cache: false,
			processData:false,
			success: function(data)
		    {
			$("#targetLayer").html(data);
		    },
		  	error: function() 
	    	{
	    	} 	        
	   });
	}));
});
</script>
<script>
function useImage(imgSrc,server) {
    function getUrlParam( paramName ) {
        var reParam = new RegExp( '(?:[\?&]|&)' + paramName + '=([^&]+)', 'i' ) ;
        var match = window.location.search.match(reParam) ;

        return ( match && match.length > 1 ) ? match[ 1 ] : null ;
    }
    var funcNum = getUrlParam( 'CKEditorFuncNum' );
    var imgSrc = imgSrc;
    var fileUrl = imgSrc;
    window.opener.CKEDITOR.tools.callFunction(funcNum, 'https://'+server+fileUrl );

    window.close();
}
</script> 
<script>
function deleteImage(file_name, file_thumb)
{
  // Check if SweetAlert2 is available and use appropriate syntax
  if (typeof Swal !== 'undefined' && typeof Swal.fire === 'function') {
    // SweetAlert2 syntax
    var swalResult = Swal.fire({
      title: "Delete Image",
      text: "Are you sure you want to delete this image? This action cannot be undone.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#dc3545",
      cancelButtonColor: "#6c757d",
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "Cancel",
      reverseButtons: true,
      focusCancel: true
    });
    
    // Only call .then() if Swal.fire returned a promise
    if (swalResult && typeof swalResult.then === 'function') {
      swalResult.then((result) => {
        if (result.isConfirmed) {
          performDelete(file_name, file_thumb);
        }
      });
    } else {
      // If Swal.fire didn't return a promise, fallback to confirm
      if (confirm("Are you sure you want to delete this image? This action cannot be undone.")) {
        performDelete(file_name, file_thumb);
      }
    }
  } else if (typeof swal !== 'undefined') {
    // SweetAlert1 syntax (fallback)
    swal({
      title: "Delete Image",
      text: "Are you sure you want to delete this image? This action cannot be undone.",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#dc3545",
      cancelButtonColor: "#6c757d",
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "Cancel",
      reverseButtons: true,
      focusCancel: true
    }, function(isConfirm) {
      if (isConfirm) {
        performDelete(file_name, file_thumb);
      }
    });
  } else {
    // Fallback to native confirm
    if (confirm("Are you sure you want to delete this image? This action cannot be undone.")) {
      performDelete(file_name, file_thumb);
    }
  }
}

function performDelete(file_name, file_thumb) {
  $.ajax({
    url: 'delete.php',
    type: "POST",
    data: {'file' : file_name },
    success: function (response) {
      deletethumb(file_thumb);
      if (typeof Swal !== 'undefined') {
        Swal.fire({
          title: "Deleted!",
          text: "The image has been deleted successfully.",
          icon: "success",
          timer: 2000,
          showConfirmButton: false
        });
      } else if (typeof swal !== 'undefined') {
        swal({
          title: "Deleted!",
          text: "The image has been deleted successfully.",
          type: "success",
          timer: 2000,
          showConfirmButton: false
        });
      } else {
        alert("Image deleted successfully!");
        location.reload();
      }
    },
    error: function () {
      if (typeof Swal !== 'undefined') {
        Swal.fire({
          title: "Error!",
          text: "Something went wrong while deleting the image.",
          icon: "error",
          confirmButtonText: "OK"
        });
      } else if (typeof swal !== 'undefined') {
        swal({
          title: "Error!",
          text: "Something went wrong while deleting the image.",
          type: "error",
          confirmButtonText: "OK"
        });
      } else {
        alert("Error deleting image!");
      }
    }
  });
}

function deletethumb(file_name) {
  $.ajax({
    url: 'delete.php',
    type: "POST",
    data: {'file' : file_name },
    success: function (response) {
      location = location;
    },
    error: function () {
      if (typeof Swal !== 'undefined' && typeof Swal.fire === 'function') {
        Swal.fire({
          title: "Error!",
          text: "Something went wrong while deleting the thumbnail.",
          icon: "error",
          confirmButtonText: "OK"
        });
      } else if (typeof swal !== 'undefined') {
        swal({
          title: "Error!",
          text: "Something went wrong while deleting the thumbnail.",
          type: "error",
          confirmButtonText: "OK"
        });
      } else {
        alert("Error deleting thumbnail!");
      }
    }
  });
}
</script> 
<script type='text/javascript'>
function preview_image(event) 
{
 var reader = new FileReader();
 reader.onload = function()
 {
  var output = document.getElementById('output_image');
  output.src = reader.result;
 }
 reader.readAsDataURL(event.target.files[0]);
}
</script>
<style type="text/css">
/* Modern Professional Styling */
* {
    box-sizing: border-box;
}

body {
    background: #f8f9fa;
    margin: 0;
    padding: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 14px;
    color: #333;
    line-height: 1.6;
}

/* Upload Section */
.bgColor {
    background: #F8F9FA;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    margin: 20px;
    padding: 25px;
    border: 1px solid #e3e6f0;
    min-height: 180px;
}

#targetLayer {
    text-align: center;
    margin-bottom: 20px;
    padding: 30px 20px;
    background: #f8f9fa;
    border-radius: 8px;
    border: 2px dashed #dee2e6;
    min-height: 120px;
    display: flex;
    align-items: center;
    justify-content: center;
}

#targetLayer img {
    max-width: 200px;
    max-height: 120px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    object-fit: contain;
}

#uploadFormLayer {
    text-align: center;
}

.inputFile {
    background: #fff;
    border: 2px solid #e3e6f0;
    border-radius: 8px;
    padding: 12px 20px;
    font-size: 14px;
    color: #495057;
    cursor: pointer;
    transition: all 0.3s ease;
    margin-bottom: 15px;
    width: 100%;
    max-width: 300px;
}

.inputFile:hover {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25);
}

.btnSubmit {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 8px;
    padding: 12px 30px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
}

.btnSubmit:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.6);
}

/* Gallery Section */
.gallery {
    position: relative;
    overflow: hidden;
    width: 100%;
    margin: 20px auto;
    padding: 25px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    border: 1px solid #e3e6f0;
}

.gallery a:link,
.gallery a:active,
.gallery a:visited {
    color: #495057;
    outline: 0;
    text-decoration: none;
    transition: all 0.3s ease;
}

.gallery a:hover {
    color: #007bff;
    text-decoration: none;
}

.gallery img {
    border: 0;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.gallery .float-left {float: left;}
.gallery .float-right {float: right;}
.gallery .clear {clear: both;}
.gallery .clearb10 {padding-bottom: 15px; clear: both;}

.gallery .titlebar {
    height: 30px;
    line-height: 30px;
    margin: 0 5px;
    border-bottom: 2px solid #e3e6f0;
    margin-bottom: 20px;
}

.gallery .title {
    font-size: 20px;
    font-weight: 600;
    color: #495057;
}

/* Thumbnail Styling */
.gallery .thumb {
    overflow: hidden;
    float: left;
    width: 180px;
    height: 120px;
    margin: 10px;
    border: 3px solid #fff;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    position: relative;
    background: #f8f9fa;
}


.gallery .thumb:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    border-color: #007bff;
}

.gallery .thumb img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 8px;
}

/* Pagination Styling */
.gallery .paginate-wrapper {
    padding: 20px 0;
    font-size: 14px;
    text-align: center;
    background: #f8f9fa;
    border-radius: 8px;
    margin-top: 20px;
}

.gallery a.paginate {
    color: #6c757d;
    padding: 8px 12px;
    margin: 0 3px;
    text-decoration: none;
    border-radius: 6px;
    transition: all 0.3s ease;
    display: inline-block;
    background: #fff;
    border: 1px solid #dee2e6;
}

.gallery a.current-paginate, 
.gallery a.paginate:hover {
    color: #fff;
    background: #007bff;
    border-color: #007bff;
    font-weight: 600;
    transform: translateY(-1px);
}

.gallery a.paginate-arrow {
    text-decoration: none;
    border: 0;
    background: #6c757d;
    color: #fff;
    padding: 8px 12px;
    border-radius: 6px;
    margin: 0 3px;
    transition: all 0.3s ease;
}

.gallery a.paginate-arrow:hover {
    background: #007bff;
    transform: translateY(-1px);
}

/* Action Buttons */
.closes {
    color: #dc3545;
    font-size: 18px;
    font-weight: bold;
    background: rgba(255,255,255,0.9);
    border-radius: 50%;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: absolute;
    top: 5px;
    right: 5px;
    z-index: 10;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    line-height: 1;
    text-align: center;
}

.closes:hover {
    color: #fff;
    background: #dc3545;
    transform: scale(1.1);
}

.view {
    color: #28a745;
    float: left;
    font-size: 12px;
    font-weight: 600;
    padding: 6px 12px;
    background: rgba(255,255,255,0.9);
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.3s ease;
    position: absolute;
    bottom: 5px;
    left: 5px;
    z-index: 10;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    border: 1px solid #28a745;
}

.view:hover {
    color: #fff !important;
    background: #28a745;
    transform: translateY(-1px);
}

/* Total Count Styling */
.gallery > div:first-child {
    background: linear-gradient(135deg, #e9ecef 0%, #dee2e6 100%);
    color: #495057;
    padding: 8px 15px;
    border-radius: 6px;
    margin-bottom: 15px;
    font-size: 12px;
    font-weight: 500;
    text-align: center;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

/* Responsive Design */
@media (max-width: 768px) {
    .gallery .thumb {
        width: 150px;
        height: 100px;
        margin: 8px;
    }
    
    .gallery {
        padding: 15px;
    }
    
    .bgColor {
        margin: 10px;
        padding: 20px;
    }
}

/* Loading Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.gallery .thumb {
    animation: fadeIn 0.5s ease-out;
}

/* No Images Message */
.gallery:empty::before {
    content: "No images found!";
    display: block;
    text-align: center;
    color: #6c757d;
    font-size: 16px;
    padding: 40px;
    background: #f8f9fa;
    border-radius: 8px;
    border: 2px dashed #dee2e6;
}

/* Professional SweetAlert Styling */
.swal-wide {
    width: 400px !important;
    border-radius: 12px !important;
    box-shadow: 0 10px 40px rgba(0,0,0,0.2) !important;
}

.swal-title {
    font-size: 20px !important;
    font-weight: 600 !important;
    color: #495057 !important;
    margin-bottom: 10px !important;
}

.swal-content {
    font-size: 14px !important;
    color: #6c757d !important;
    line-height: 1.5 !important;
}

.swal-confirm {
    background: #dc3545 !important;
    border: none !important;
    border-radius: 6px !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
    font-size: 14px !important;
    transition: all 0.3s ease !important;
}

.swal-confirm:hover {
    background: #c82333 !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 12px rgba(220, 53, 69, 0.4) !important;
}

.swal-cancel {
    background: #6c757d !important;
    border: none !important;
    border-radius: 6px !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
    font-size: 14px !important;
    transition: all 0.3s ease !important;
}

.swal-cancel:hover {
    background: #5a6268 !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 12px rgba(108, 117, 125, 0.4) !important;
}
</style>

</head>

<body>
<table width="100%"><tr><td>
<div class="bgColor" style="background-color: #F8F9FA;" width="100%">
<form id="uploadForm" action="upload.php" method="post" enctype="multipart/form-data">
<div id="targetLayer"><img id="output_image" alt="No Image" style="max-width:180px; max-height: 100px" src="images/default-image.jpg"/>
</div> 
<div id="uploadFormLayer">
<input name="userImage" accept="image/*" type="file" class="inputFile" onchange="preview_image(event)" /> <br>
<input type="submit" value="<?php echo $lang[$_SESSION['lang']]['submit'] ?>" class="btnSubmit" />

</div></div>
</form>
</div>
</td></tr>
<tr><td>
<div class="gallery"> 
<?php 
$itemsPerPage = '30';         // number of images per page    
$thumb_width  = '150';        // width of thumbnails
$thumb_height = '130';         // height of thumbnails
$src_folder   =$full_browse_dir;             // current folder
$src_files    = @scandir($src_folder) or null; // files in current folder
$extensions   = array(".jpg",".jpeg",".png",".gif",".JPG",".JPEG",".PNG",".GIF"); // allowed extensions in photo gallery
$files = array();
$Ftype="Images";
$CKEditorFuncNum=0;
If(isset($_REQUEST['CKEditorFuncNum'])) $CKEditorFuncNum= $_REQUEST['CKEditorFuncNum'];

if(!empty($src_files)) {
  foreach($src_files as $file) {
    $ext = strrchr($file, '.');
      if(in_array($ext, $extensions)) {
         array_push( $files, $file );
         if (!is_dir($src_folder.'/thumbs')) {
            mkdir($src_folder.'/thumbs');
            chmod($src_folder.'/thumbs', 0777); 
         }

       $thumb = $src_folder.'/thumbs/'.$file;
         if (!file_exists($thumb)) {
            try {
                make_thumb($src_folder,$file,$thumb,$thumb_width); 
                chmod($thumb, 0777); 
            } catch (\Exception $e) {
                //echo $e->getMessage();
            }
            
       }
    }
  }
} else {
  if(!is_dir($src_folder)) {
    if(!mkdir($src_folder, 0777, true)) {
      throw new Exception("Dir not created", 1);
    }
   }
}

if ( count($files) == 0 ) {
    echo 'No image found!';
} else {
  echo "<div> <strong style='padding:3px; font-size:12px; font-weight:500;''>". $lang[$_SESSION['lang']]['total'].":<strong> ".count($files)."</div><br>";
   
    $numPages = ceil( count($files) / $itemsPerPage );

    if(isset($_GET['p'])) {
      
       $currentPage = $_GET['p'];
       if($currentPage > $numPages) {
           $currentPage = $numPages;
       }

    } else {
       $currentPage=1;
    } 

    $start = ( $currentPage * $itemsPerPage ) - $itemsPerPage;

    for( $i=$start; $i<$start + $itemsPerPage; $i++ ) {
		  
	   if( isset($files[$i]) && is_file( $src_folder .'/'. $files[$i] ) ) { 
	   $slika=$files[$i];
	   $full_slika=$upload_folder.$files[$i];
	   $za_brisanje=$src_folder .'/'. $files[$i];
	   $za_brisanje_thumb=$src_folder .'/thumbs/'. $files[$i];
	   $thumb=$upload_folder."/thumbs/".$files[$i];
       $image_url = $upload_folder.$files[$i];

       if(!file_exists($thumb)) {
            $thumb = $image_url;
       }
	  ?>
	   <div class="thumb">
		    <span  class="closes" title="Delete" onclick="deleteImage('<?php echo $za_brisanje;?>', '<?php echo $za_brisanje_thumb;?>');" >&times;</span>
        <a class="view" target="_blank" title="<?php echo  $lang[$_SESSION['lang']]['view'] ?>" href="<?php echo $image_url?>"><?php echo $lang[$_SESSION['lang']]['view']; ?></a>
	            <a href="<?php echo $full_slika?>" class="albumpix" rel="albumpix">
			       <img src='<?php echo $thumb?>' width="<?php echo $thumb_width?>" height="<?php echo $thumb_height?>" alt=""  
			     onclick="return false"  ondblclick="useImage('<?php echo $full_slika ?>','<?php echo $server?>');" />
			     
				</a>  
			    </div>
	<?php
      
	    } else {
		  
		  if( isset($files[$i]) ) {
		    echo $files[$i];
		  }
		  
		}
     
    }
	   

     echo '<div class="clear"></div>';
     echo '<div class="p5-sides">
	         <div class="float-right" class="paginate-wrapper">';
              print_pagination($numPages,$currentPage, $lang);
       echo '</div>
	         <div class="clearb10">
		   </div>';

}
?>

</div> 
</td></tr>  </table>
</body>
</html>
