<?php
// Bootstrap Laravel to access authenticated user
define('LARAVEL_START', microtime(true));
require __DIR__ . '/../../../../vendor/autoload.php';
$app = require_once __DIR__ . '/../../../../bootstrap/app.php';

// Uncomment if you want to allow posts from other domains
// header('Access-Control-Allow-Origin: *');

require_once('slim.php');

// Get user ID - prioritize GET/POST parameters (passed from JavaScript)
$user_id = null;

// First priority: GET/POST parameters (most reliable, passed from JavaScript)
if (!empty($_GET['user_id'])) {
    $user_id = $_GET['user_id'];
} elseif (!empty($_POST['user_id'])) {
    $user_id = $_POST['user_id'];
}

// Fallback 1: Try to get from Laravel authenticated user
if (empty($user_id)) {
    try {
        $request = Illuminate\Http\Request::capture();
        $kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
        $response = $kernel->handle($request);
        
        // Get authenticated user
        $user = \Illuminate\Support\Facades\Auth::user();
        if ($user) {
            $user_id = $user->id;
        }
    } catch (Exception $e) {
        // Laravel Auth not available, continue with other methods
    }
}

// Fallback 2: Try to use the same session path as the builder (custom session)
if (empty($user_id)) {
    $session_path = __DIR__ . '/../../../../resources/views/templates/rz_builder/sessions';
    if (!is_dir($session_path)) {
        mkdir($session_path, 0777, true);
    }
    session_save_path($session_path);
    
    if (!isset($_SESSION)) {
        session_start();
    }
    
    if (!empty($_SESSION['mc_user_id'])) {
        $user_id = $_SESSION['mc_user_id'];
    } elseif (!empty($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];
    }
}

// Fallback 3: Extract from referer URL if it contains the pattern
if (empty($user_id) && !empty($_SERVER['HTTP_REFERER'])) {
    if (preg_match('/\/images\/users\/(\d+)\//', $_SERVER['HTTP_REFERER'], $matches)) {
        $user_id = $matches[1];
    }
}

// If no user ID found, return error
if (empty($user_id)) {
    Slim::outputJSON(array(
        'status' => SlimStatus::FAILURE,
        'message' => 'User ID not found. Please ensure you are logged in.'
    ));
    return;
}

// Build absolute path for user gallery
// Get the public directory (3 levels up from this script: server -> rz_builder -> components -> public)
$public_dir = dirname(__DIR__, 3);
$gallery_path = $public_dir . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'users' . DIRECTORY_SEPARATOR . $user_id . DIRECTORY_SEPARATOR . 'gallery' . DIRECTORY_SEPARATOR;

// Create directory if it doesn't exist
if (!file_exists($gallery_path)) {
    mkdir($gallery_path, 0777, true);
}

// Get posted data, if something is wrong, exit
try {
    $images = Slim::getImages();
}
catch (Exception $e) {

    // Possible solutions
    // ----------
    // Make sure you're running PHP version 5.6 or higher

    Slim::outputJSON(array(
        'status' => SlimStatus::FAILURE,
        'message' => 'Unknown'
    ));

    return;
}

// No image found under the supplied input name
if ($images === false) {

    // Possible solutions
    // ----------
    // Make sure the name of the file input is "slim[]" or you have passed your custom
    // name to the getImages method above like this -> Slim::getImages("myFieldName")

    Slim::outputJSON(array(
        'status' => SlimStatus::FAILURE,
        'message' => 'No data posted'
    ));

    return;
}

// Should always be one image (when posting async), so we'll use the first on in the array (if available)
$image = array_shift($images);

// Something was posted but no images were found
if (!isset($image)) {

    // Possible solutions
    // ----------
    // Make sure you're running PHP version 5.6 or higher

    Slim::outputJSON(array(
        'status' => SlimStatus::FAILURE,
        'message' => 'No images found'
    ));

    return;
}

// If image found but no output or input data present
if (!isset($image['output']['data']) && !isset($image['input']['data'])) {

    // Possible solutions
    // ----------
    // If you've set the data-post attribute make sure it contains the "output" value -> data-post="actions,output"
    // If you want to use the input data and have set the data-post attribute to include "input", replace the 'output' String above with 'input'

    Slim::outputJSON(array(
        'status' => SlimStatus::FAILURE,
        'message' => 'No image data'
    ));

    return;
}



// if we've received output data save as file
if (isset($image['output']['data'])) {

    // get the name of the file
    $name = $image['output']['name'];

    // get the crop data for the output image
    $data = $image['output']['data'];

    // If you want to store the file in another directory pass the directory name as the third parameter.
    // $file = Slim::saveFile($data, $name, 'my-directory/');

    // If you want to prevent Slim from adding a unique id to the file name add false as the fourth parameter.
    // $file = Slim::saveFile($data, $name, 'tmp/', false);
    $output = Slim::saveFile($data, $name, $gallery_path);
}

// if we've received input data (do the same as above but for input data)
if (isset($image['input']['data'])) {

    // get the name of the file
    $name = $image['input']['name'];

    // get the crop data for the output image
    $data = $image['input']['data'];

    // If you want to store the file in another directory pass the directory name as the third parameter.
    // $file = Slim::saveFile($data, $name, 'my-directory/');

    // If you want to prevent Slim from adding a unique id to the file name add false as the fourth parameter.
    // $file = Slim::saveFile($data, $name, 'tmp/', false);
    $input = Slim::saveFile($data, $name, $gallery_path);
}



//
// Build response to client
//
$response = array(
    'status' => SlimStatus::SUCCESS
);

if (isset($output) && isset($input)) {

    $response['output'] = array(
        'file' => $output['name'],
        'path' => $output['path']
    );

    $response['input'] = array(
        'file' => $input['name'],
        'path' => $input['path']
    );

}
else {
    $response['file'] = isset($output) ? $output['name'] : $input['name'];
    $response['path'] = isset($output) ? $output['path'] : $input['path'];
}

// Return results as JSON String
Slim::outputJSON($response);