<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Relayzo - Installation</title>
  <link rel="icon" type="image/x-icon" href="favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body style="background-color: #10172D; color: #FFFFFF;">

  <div class="container mt-5" id="page1">
    <div class="col-md-12 text-center">
      <img src="login_logo.png" alt="Logo">
      <h5 class="mt-3">Power Your Campaigns, Own Your Success</h5>
    </div>
<br>
    <h5>For installation help: <a href="https://relayzo.com/installation-guide" target="_blank">https://relayzo.com/installation-guide</a></h5>
<br>
    <?php include_once('dependencies.php'); ?>
    <button type="button" class="btn btn-warning mb-5 btn-sm mt-3" onclick="location.href='/install/setup.php'">Refresh</button>
    <form id="frm-install" method="post" action="" class="needs-validation" novalidate onsubmit=" return install(this)">
      <h4 style="color: #FEC91E" class="mt-3">Application Settings</h4>
      <div class="mb-3">
        <label for="license_key" class="form-label">License Key</label>
        <input type="text" class="form-control" name="license_key" id="license_key" placeholder="Enter the License Key" required>
      </div>
      <div class="row">
      <div class="mb-3 col-md-6">
        <label for="timezone" name="timezone" class="form-label">Time Zone</label>
        <select name="timezone" class="form-select" id="timezone" required>
          <option value="">Select your time zone</option>
          <option value="Pacific/Midway">(GMT-11:00) Midway Island </option>
          <option value="US/Samoa">(GMT-11:00) Samoa </option>
          <option value="US/Hawaii">(GMT-10:00) Hawaii </option>
          <option value="US/Alaska">(GMT-09:00) Alaska </option>
          <option value="US/Pacific">(GMT-08:00) Pacific Time (US &amp; Canada) </option>
          <option value="America/Tijuana">(GMT-08:00) Tijuana </option>
          <option value="US/Arizona">(GMT-07:00) Arizona </option>
          <option value="US/Mountain">(GMT-07:00) Mountain Time (US &amp; Canada) </option>
          <option value="America/Chihuahua">(GMT-07:00) Chihuahua </option>
          <option value="America/Mazatlan">(GMT-07:00) Mazatlan </option>
          <option value="America/Mexico_City">(GMT-06:00) Mexico City </option>
          <option value="America/Monterrey">(GMT-06:00) Monterrey </option>
          <option value="Canada/Saskatchewan">(GMT-06:00) Saskatchewan </option>
          <option value="US/Central">(GMT-06:00) Central Time (US &amp; Canada) </option>
          <option value="US/Eastern">(GMT-05:00) Eastern Time (US &amp; Canada) </option>
          <option value="US/East-Indiana">(GMT-05:00) Indiana (East) </option>
          <option value="America/Bogota">(GMT-05:00) Bogota </option>
          <option value="America/Lima">(GMT-05:00) Lima </option>
          <option value="America/Caracas">(GMT-04:30) Caracas </option>
          <option value="Canada/Atlantic">(GMT-04:00) Atlantic Time (Canada) </option>
          <option value="America/La_Paz">(GMT-04:00) La Paz </option>
          <option value="America/Santiago">(GMT-04:00) Santiago </option>
          <option value="Canada/Newfoundland">(GMT-03:30) Newfoundland </option>
          <option value="America/Buenos_Aires">(GMT-03:00) Buenos Aires </option>
          <option value="Greenland">(GMT-03:00) Greenland </option>
          <option value="Atlantic/Stanley">(GMT-02:00) Stanley </option>
          <option value="Atlantic/Azores">(GMT-01:00) Azores </option>
          <option value="Atlantic/Cape_Verde">(GMT-01:00) Cape Verde Is. </option>
          <option value="Africa/Casablanca">(GMT) Casablanca </option>
          <option value="Europe/Dublin">(GMT) Dublin </option>
          <option value="Europe/Lisbon">(GMT) Lisbon </option>
          <option value="Europe/London" selected="selected">(GMT) London </option>
          <option value="Africa/Monrovia">(GMT) Monrovia </option>
          <option value="Europe/Amsterdam">(GMT+01:00) Amsterdam </option>
          <option value="Europe/Belgrade">(GMT+01:00) Belgrade </option>
          <option value="Europe/Berlin">(GMT+01:00) Berlin </option>
          <option value="Europe/Bratislava">(GMT+01:00) Bratislava </option>
          <option value="Europe/Brussels">(GMT+01:00) Brussels </option>
          <option value="Europe/Budapest">(GMT+01:00) Budapest </option>
          <option value="Europe/Copenhagen">(GMT+01:00) Copenhagen </option>
          <option value="Europe/Ljubljana">(GMT+01:00) Ljubljana </option>
          <option value="Europe/Madrid">(GMT+01:00) Madrid </option>
          <option value="Europe/Paris">(GMT+01:00) Paris </option>
          <option value="Europe/Prague">(GMT+01:00) Prague </option>
          <option value="Europe/Rome">(GMT+01:00) Rome </option>
          <option value="Europe/Sarajevo">(GMT+01:00) Sarajevo </option>
          <option value="Europe/Skopje">(GMT+01:00) Skopje </option>
          <option value="Europe/Stockholm">(GMT+01:00) Stockholm </option>
          <option value="Europe/Vienna">(GMT+01:00) Vienna </option>
          <option value="Europe/Warsaw">(GMT+01:00) Warsaw </option>
          <option value="Europe/Zagreb">(GMT+01:00) Zagreb </option>
          <option value="Europe/Athens">(GMT+02:00) Athens </option>
          <option value="Europe/Bucharest">(GMT+02:00) Bucharest </option>
          <option value="Africa/Cairo">(GMT+02:00) Cairo </option>
          <option value="Africa/Harare">(GMT+02:00) Harare </option>
          <option value="Europe/Helsinki">(GMT+02:00) Helsinki </option>
          <option value="Europe/Istanbul">(GMT+02:00) Istanbul </option>
          <option value="Asia/Jerusalem">(GMT+02:00) Jerusalem </option>
          <option value="Europe/Kiev">(GMT+02:00) Kyiv </option>
          <option value="Europe/Minsk">(GMT+02:00) Minsk </option>
          <option value="Europe/Riga">(GMT+02:00) Riga </option>
          <option value="Europe/Sofia">(GMT+02:00) Sofia </option>
          <option value="Europe/Tallinn">(GMT+02:00) Tallinn </option>
          <option value="Europe/Vilnius">(GMT+02:00) Vilnius </option>
          <option value="Asia/Baghdad">(GMT+03:00) Baghdad </option>
          <option value="Asia/Kuwait">(GMT+03:00) Kuwait </option>
          <option value="Africa/Nairobi">(GMT+03:00) Nairobi </option>
          <option value="Asia/Riyadh">(GMT+03:00) Riyadh </option>
          <option value="Europe/Moscow">(GMT+03:00) Moscow </option>
          <option value="Asia/Tehran">(GMT+03:30) Tehran </option>
          <option value="Asia/Baku">(GMT+04:00) Baku </option>
          <option value="Europe/Volgograd">(GMT+04:00) Volgograd </option>
          <option value="Asia/Muscat">(GMT+04:00) Muscat </option>
          <option value="Asia/Tbilisi">(GMT+04:00) Tbilisi </option>
          <option value="Asia/Yerevan">(GMT+04:00) Yerevan </option>
          <option value="Asia/Kabul">(GMT+04:30) Kabul </option>
          <option value="Asia/Karachi">(GMT+05:00) Karachi </option>
          <option value="Asia/Tashkent">(GMT+05:00) Tashkent </option>
          <option value="Asia/Kolkata">(GMT+05:30) Kolkata </option>
          <option value="Asia/Kathmandu">(GMT+05:45) Kathmandu </option>
          <option value="Asia/Yekaterinburg">(GMT+06:00) Ekaterinburg </option>
          <option value="Asia/Almaty">(GMT+06:00) Almaty </option>
          <option value="Asia/Dhaka">(GMT+06:00) Dhaka </option>
          <option value="Asia/Novosibirsk">(GMT+07:00) Novosibirsk </option>
          <option value="Asia/Bangkok">(GMT+07:00) Bangkok </option>
          <option value="Asia/Jakarta">(GMT+07:00) Jakarta </option>
          <option value="Asia/Krasnoyarsk">(GMT+08:00) Krasnoyarsk </option>
          <option value="Asia/Chongqing">(GMT+08:00) Chongqing </option>
          <option value="Asia/Hong_Kong">(GMT+08:00) Hong Kong </option>
          <option value="Asia/Kuala_Lumpur">(GMT+08:00) Kuala Lumpur </option>
          <option value="Australia/Perth">(GMT+08:00) Perth </option>
          <option value="Asia/Singapore">(GMT+08:00) Singapore </option>
          <option value="Asia/Taipei">(GMT+08:00) Taipei </option>
          <option value="Asia/Ulaanbaatar">(GMT+08:00) Ulaan Bataar </option>
          <option value="Asia/Urumqi">(GMT+08:00) Urumqi </option>
          <option value="Asia/Irkutsk">(GMT+09:00) Irkutsk </option>
          <option value="Asia/Seoul">(GMT+09:00) Seoul </option>
          <option value="Asia/Tokyo">(GMT+09:00) Tokyo </option>
          <option value="Australia/Adelaide">(GMT+09:30) Adelaide </option>
          <option value="Australia/Darwin">(GMT+09:30) Darwin </option>
          <option value="Asia/Yakutsk">(GMT+10:00) Yakutsk </option>
          <option value="Australia/Brisbane">(GMT+10:00) Brisbane </option>
          <option value="Australia/Canberra">(GMT+10:00) Canberra </option>
          <option value="Pacific/Guam">(GMT+10:00) Guam </option>
          <option value="Australia/Hobart">(GMT+10:00) Hobart </option>
          <option value="Australia/Melbourne">(GMT+10:00) Melbourne </option>
          <option value="Pacific/Port_Moresby">(GMT+10:00) Port Moresby </option>
          <option value="Australia/Sydney">(GMT+10:00) Sydney </option>
          <option value="Asia/Vladivostok">(GMT+11:00) Vladivostok </option>
          <option value="Asia/Magadan">(GMT+12:00) Magadan </option>
          <option value="Pacific/Auckland">(GMT+12:00) Auckland </option>
          <option value="Pacific/Fiji">(GMT+12:00) Fiji </option>
        </select>
      </div>
      <div class="mb-3 col-md-6">
          <label for="language" name="language" class="form-label">Language</label>
          <select name="language" class="form-select" id="language" required>
            <option value="en">English</option>
            <option value="es">Español</option>
            <option value="fr">Français</option>
            <option value="de">Deutsch</option>
          </select>
        </div>
    </div>
      <div class="row">
        <div class="mb-3 col-md-6">
          <label for="app_name" class="form-label">Application Name</label>
          <input type="text" class="form-control" name="app_name" id="app_name" placeholder="Enter the Application Name" required>
        </div>
        <div class="mb-3 col-md-6">
          <label for="app_url" class="form-label">Application URL</label>
          <input type="text" class="form-control" value="<?php echo $app_url ?? ''?>" name="app_url" id="app_url" placeholder="Enter your Application URL" required>
        </div>
      </div>
      <div class="row">
        <div class="mb-3 col-md-6">
          <label for="email" class="form-label">Email</label>
          <input type="email" class="form-control" name="email" id="email" placeholder="Enter your Email" required>
        </div>
        <div class="col-md-6">
          <label for="password" class="form-label">Password</label>
          <div class="input-group mb-3">
            <input type="password" class="form-control" name="password" id="password" placeholder="Enter your Password" required>
            <button type="button" class="btn btn-outline-secondary toggle-password" data-target="#password">
              <i class="fas fa-eye"></i>
            </button>
          </div>
        </div>
      </div>

      <h4 class="mt-5" style="color: #FEC91E">Database Settings</h4>
      <div class="row">
        <div class="mb-3 col-md-6">
          <label for="db_host" class="form-label">Database Host</label>
          <input type="text" class="form-control" name="db_host" id="db_host" placeholder="Enter the Database Host" required>
        </div>
        <div class="mb-3 col-md-6">
          <label for="db_name" class="form-label">Database Name</label>
          <input type="text" class="form-control" name="db_name" id="db_name" placeholder="Enter the Database Name" required>
        </div>
      </div>
      <div class="row">
        <div class="mb-3 col-md-4">
          <label for="db_username" class="form-label">Database Username</label>
          <input type="text" class="form-control" name="db_username" id="db_username" placeholder="Enter the Database Username" required>
        </div>
        <div class="mb-3 col-md-4">
          <label for="db_password" class="form-label">Database Password</label>
          <div class="input-group">
            <input type="password" class="form-control" name="db_password" id="db_password" placeholder="Enter the Database Password">
            <button type="button" class="btn btn-outline-secondary toggle-password" data-target="#db_password">
              <i class="fas fa-eye"></i>
            </button>
          </div>
        </div>
        <div class="mb-3 col-md-4">
          <label for="tables_prefix" class="form-label">Table Prefix</label>
          <input type="text" class="form-control" value="rz_" name="tables_prefix" id="tables_prefix" placeholder="Enter the Table Prefix">
        </div>
      </div>

      <div class="row mx-1">
        <button type="submit" id="btn-continue" class="btn btn-warning mb-5 col-md-2 btn-loading"><i class=""></i> Proceed to install</button>
        <span id="msg" class="text-warning col-md-10 mt-2"></span>
      </div>
    </form>
  </div>
  <div class="container my-5 text-center" id="page2" style="display: none;">
    <div class="col-md-12">
      <h3>Relayzo has been successfully installed!</h3><br/>
      Next, please configure the following cron job to ensure optimal functionality:
      <div id="cronjob" class="text-warning"></div>
      <h4 class="mt-5"><a id="login" href="">Login to Application</a></h4>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
  <script src="install.js"></script>
</body>
</html>

