@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [5,6,9,10]}],
    "order": [[6, "DESC"]],
    "lengthMenu": [[50, 100, 500], [50, 100, 500]],
    "ajax": {
      "url" : "{{ route('stats.campaigns') }}"
    },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
    
    // Handle Add Segmentation button click with error handling
    $('#add-segmentation-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        
        // Show loading spinner
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        
        // Try to navigate to the create page
        $.ajax({
            url: href,
            type: 'GET',
            success: function() {
                // If successful, navigate to the page
                window.location.href = href;
            },
            error: function(xhr) {
                // Reset button
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                
                if (xhr.status === 401) {
                    alert('You do not have permission to create segmentations. Please contact your administrator.');
                } else if (xhr.status === 403) {
                    alert('Access forbidden. You do not have the required permissions.');
                } else {
                    alert('An error occurred while trying to access the create segmentation page. Please try again.');
                }
            }
        });
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    @if(\App\Http\Helper\Helper::checkPermissions('segmentation_campaign', false))
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('campaign_segmentations.index')}}" class="btn btn-primary btn-loading" id="add-segmentation-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.audience_filter')}}
                            </a>
                        </div>
                    </div>
                    @endif
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.opens') }}</th>
                                <th>{{ __('app.clicks') }}</th>
                                <th>{{ __('app.replies') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.detail') }}</th>
                                <th>{{ __('app.action') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('includes.modal')
@include('includes.datatables')
@endsection
