@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [5,6,8,9]}],
    "order": [[6, "DESC"]],
    "lengthMenu": [[50, 100, 500], [50, 100, 500]],
    "ajax": {
      "url" : "{{ route('stats.campaigns') }}"
    },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.opens') }}</th>
                                <th>{{ __('app.clicks') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.detail') }}</th>
                                <th>{{ __('app.action') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('includes.modal')
@include('includes.datatables')
@endsection
