<script>
$(function () {
  'use strict';
  var table = $('#data-logs').DataTable({
    "destroy": true, // Automatically destroy any previous instance before reinitializing.
    "order": [[6, "DESC"]],
    "lengthMenu": [[100, 500], [100, 500]],
    "ajax": {
      "url" : "{{ route('drip.logs') }}",
      "data" : {
        "stat_id" : "{{ $stat_id }}"
      }
    }
  });
  table.on('draw', function() {
    $('#data-logs_filter label').addClass('me-2 mb-1');
    $('#data-logs_paginate a').addClass('btn btn-primary me-1');
    $('#data-logs_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });
});
</script>
<div class="table-responsive">
<table id="data-logs" class="table table-bordered text-nowrap w-100">
  <thead>
  <tr>
    <th>{{ __('app.drip') }}</th>
    <th>{{ __('app.email') }}</th>
    <th>{{ __('app.list') }}</th>
    <th>{{ __('app.delivery_server') }}</th>
    <th>{{ __('app.message_id') }}</th>
    <th>{{ __('app.latest_activity') }}</th>
    <th>{{ __('app.datetime') }}</th>
  </tr>
  </thead>
  <tbody>
  </tbody>
</table>
</table>

