<script>
$(function () {
  'use strict';
  var table = $('#data-bounces').DataTable({
    "destroy": true, // Automatically destroy any previous instance before reinitializing.
    "order": [[7, "DESC"]],
    "lengthMenu": [[50, 100], [50, 100]],
    "ajax": {
      "url" : "{{ route('split_test.bounces') }}",
      "data" : {
        "stat_id" : "{{ $stat_id }}"
      }
    }
  });
  table.on('draw', function() {
    $('#data-bounces_filter label').addClass('me-2 mb-1');
    $('#data-bounces_paginate a').addClass('btn btn-primary me-1');
    $('#data-bounces_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });
});
</script>
<div class="table-responsive">
<table id="data-bounces" class="table table-bordered text-nowrap w-100">
  <thead>
  <tr>
    <th>{{ __('app.email') }}</th>
    <th>{{ __('app.list') }}</th>
    <th>{{ __('app.delivery_server') }}</th>
    <th>{{ __('app.message_id') }}</th>
    <th>{{ __('app.type') }}</th>
    <th>{{ __('app.code') }}</th>
    <th>{{ __('app.detail') }}</th>
    <th>{{ __('app.datetime') }}</th>
  </tr>
  </thead>
  <tbody>
  </tbody>
</table>
</div>

