@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0,2,3,4,5,6,7,8,9,10,12,13]}],
    "order": [[6, "DESC"]],
    "lengthMenu": [[100, 500], [100, 500]],
    "ajax": {
      "url" : "{{ route('stats.split_tests') }}"
    },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{{ __('app.winning_criteria') }}</th>
                                <th>{{ __('app.decision_percentage') }}</th>
                                <th>{{ __('app.action') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.opens') }}</th>
                                <th>{{ __('app.clicks') }}</th>
                                <th>{{ __('app.replies') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.detail') }}</th>
                                <th>{{ __('app.action') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('includes.modal')
@include('includes.datatables')
@endsection
