@php
$split_test = \App\Models\SplitTest::whereId($split_test_stat->split_test_id)->first();
$action_data = json_decode($split_test->action_data);
@endphp
<link rel="stylesheet" href="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.css')}}">
<script src="{{asset('components/Chart.js/dist/Chart.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-world-mill-en.js')}}"></script>
<script>
$(function () {
  'use strict';
  // get sent lists
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_sent_lists',
    beforeSend: function( xhr ) {  
      $('#div-sent-lists').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-sent-lists').html(data);
  });

  // get sent campaigns
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_sent_campaigns',
    beforeSend: function( xhr ) {  
      $('#div-sent-campaigns').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-sent-campaigns').html(data);
  });

  // get sent sending servers
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_sent_sending_servers',
    beforeSend: function( xhr ) {  
      $('#div-sent-sending-servers').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-sent-sending-servers').html(data);
  });

  // get opens
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_opens',
    beforeSend: function( xhr ) {  
      $('#div-opens').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-opens').html(data);
  });

  // get clicks
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_clicks',
    beforeSend: function( xhr ) {  
      $('#div-clicks').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-clicks').html(data);
  });

  // get replies
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_replies',
    beforeSend: function( xhr ) {  
      $('#div-replies').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-replies').html(data);
  });

  // get unsubscribed
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_unsubscribed',
    beforeSend: function( xhr ) {  
      $('#div-unsubscribed').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-unsubscribed').html(data);
  });

  // get bounces
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_bounces',
    beforeSend: function( xhr ) {  
      $('#div-bounces').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-bounces').html(data);
  });

  // get spam
  $.ajax({
    url: '/detail/stat/split_test/'+{{$split_test_stat->id}}+'/summary_spam',
    beforeSend: function( xhr ) {  
      $('#div-spam').html('<div class="spinner-border spinner-border-sm text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-spam').html(data);
  });

  // Pie Chart
  $.ajax({
    url: "{{ route('split_test.sent.data', ['id' => $split_test_stat->id]) }}",
    beforeSend: function( xhr ) {  
      $('#div-chart-pie').html('<div class="spinner-border text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    $('#div-chart-pie').html('<canvas id="canvas-chart-sent" style="height: 250px;"></canvas>');
    var canvas_chart_sent = $('#canvas-chart-sent').get(0).getContext('2d');
    var chart       = new Chart(canvas_chart_sent);
    var data        =  JSON.parse(data);
    var options     = {
      legend: {
        position: 'right',
        labels: {
          boxWidth: 20
        }
      },
    };

    var myPieChart = new Chart(chart, {
      type: 'pie',
      data: data,
      options: options
    });
  });

  // World Chart
  $.ajax({
    url: "{{ route('split_test.sent.data', ['id' => $split_test_stat->id, 'type' => 'country']) }}",
    beforeSend: function( xhr ) {  
      $('#world-map').html('<div class="spinner-border text-dark" role="status"><span class="visually-hidden"></span></div>');
    }
  })
  .done(function( data ) {
    var data = JSON.parse(data);
    // World map by jvectormap
    $('#world-map').html('');
    $('#world-map').vectorMap({
      map              : 'world_mill_en',
      backgroundColor  : 'transparent',
      regionStyle      : {
        initial: {
          fill            : '#e4e4e4',
          'fill-opacity'  : 1,
          stroke          : 'none',
          'stroke-width'  : 0,
          'stroke-opacity': 1
        },
        hover: {
          stroke: '#3D5A6B',
          "stroke-width": 2,
          cursor: 'pointer'
        }
      },
      series           : {
        regions: [
        {
          values           : data,
          scale            : ['#deeef7', '#096da5'],
          normalizeFunction: 'polynomial'
        }
        ]
      },
      onRegionTipShow: function(e, el, code){
        if (typeof data[code] != 'undefined')
          el.html(el.html() +" ({{__('app.opens')}}: "+data[code]+')');
      }
    });
  });
});
</script>
<div class="row">
<div class="col-md-6">
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.name') }}</label>
    <div class="col-md-9">{{ $split_test_stat->split_test_name }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.scheduled_by') }}</label>
    <div class="col-md-9">{{ $split_test_stat->schedule_by}}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.created') }}</label>
    <div class="col-md-9">{{ !empty($split_test_stat->created_at) ? \App\Http\Helper\Helper::datetimeDisplay($split_test_stat->created_at) : '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.started_at') }}</label>
    <div class="col-md-9">{{ !empty($split_test_stat->start_datetime) ? \App\Http\Helper\Helper::datetimeDisplay($split_test_stat->start_datetime) : '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.ended_at') }}</label>
    <div class="col-md-9">{{ !empty($split_test_stat->end_datetime) ? \App\Http\Helper\Helper::datetimeDisplay($split_test_stat->end_datetime) : '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.lists') }}</label>
    <div class="col-md-9" id="div-sent-lists"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.broadcast') }}</label>
    <div class="col-md-9" id="div-sent-campaigns"></div>
  </div>  
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.delivery_servers') }}</label>
    <div class="col-md-9" id="div-sent-sending-servers"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.limit') }} ({{ __('app.hourly') }})</label>
    <div class="col-md-9">{{ (json_decode($split_test_stat->sending_speed)->speed == 'unlimited') ? __('app.unlimited') : json_decode($split_test_stat->sending_speed)->limit }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.winning_campaign') }}</label>
    <div class="col-md-9">{{ $split_test->winning_campaign_name ?? '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.winning_criteria') }}</label>
    <div class="col-md-9">{{ !empty($split_test->winning_criteria) ? ucfirst($split_test->winning_criteria) : '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.decision_percentage') }}</label>
    <div class="col-md-9">{{ $split_test->decision_percentage ?? '---' }} %</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.action') }}</label>
    <div class="col-md-9">{{ !empty($split_test->action) ? ucwords(str_replace('_', ' ', $split_test->action)) : '---' }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.after') }}</label>
    <div class="col-md-9">{{ $action_data->send_remaining_after }} {{$action_data->send_remaining_after_duration}}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.scheduled') }}</label>
    <div class="col-md-9"><a href="javascript:;" onclick="viewModal('modal', '{{ route('scheduled.detail.campaign', ['id' => $split_test_stat->split_test_id, 'type' => 'split_test']) }}')">{{ $split_test_stat->scheduled }}</a></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.sent') }}</label>
    <div class="col-md-9">{{ $split_test_stat->sent }}</div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.opens') }}</label>
    <div class="col-md-9" id="div-opens"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.clicks') }}</label>
    <div class="col-md-9" id="div-clicks"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.replies') }}</label>
    <div class="col-md-9" id="div-replies"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.unsubscribed') }}</label>
    <div class="col-md-9" id="div-unsubscribed"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.bounces') }}</label>
    <div class="col-md-9" id="div-bounces"></div>
  </div>
  <div class="row mt-3">
    <label class="col-md-3 form-label text-dark">{{ __('app.spams') }}</label>
    <div class="col-md-9" id="div-spam"></div>
  </div>
</div>
<div class="col-md-6">
  <div class="col-md-12 text-center">
    <div class="chart">
      <div id="div-chart-pie"></div>
    </div>
  </div>
  <div class="col-md-12 mt-3 text-center">
    <div id="world-map" style="height: 280px; width: 100%; padding-top: 50px;"></div>
  </div>
</div>
</div>
