@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
window.onload = function() {
   detailStatsTriggers('{{ $schedule_stat->id }}', 'summary');
};
</script>
@endpush

@section('content')
@if(\App\Http\Helper\Helper::checkPermissions('analatics_triggers_export'))
<div class="row">
   <div class="offset-7 col-md-5">
      <button class="btn btn-success btn-sm btn-loading" id="stat-export" data-route="{{ route('stat.trigger.export', ['id' => $schedule_stat->id]) }}"><i class=""></i> {{ __('app.export_stats') }}</button>
      <span class="info" id="export-download" data-route="{{ route('stat.trigger.export.download', ['id' => $schedule_stat->id]) }}" data-value="{{ __('app.download') }}"></span>
   </div>
</div>
@endif

<ul class="nav nav-pills" id="pills-tab" role="tablist">
   <li class="nav-item" role="presentation">
      <button class="nav-link active" id="pills-summary-tab" data-bs-toggle="pill" data-bs-target="#pills-summary" type="button" role="tab" aria-controls="pills-summary" aria-selected="true"  onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'summary');">{{ __('app.summary') }}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-opens-tab" data-bs-toggle="pill" data-bs-target="#pills-opens" type="button" role="tab" aria-controls="pills-opens" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'opens');">{{__('app.opens')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-clicks-tab" data-bs-toggle="pill" data-bs-target="#pills-clicks" type="button" role="tab" aria-controls="pills-clicks" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'clicks');">{{__('app.clicks')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-replies-tab" data-bs-toggle="pill" data-bs-target="#pills-replies" type="button" role="tab" aria-controls="pills-replies" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'replies');">{{__('app.replies')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-unsubscribed-tab" data-bs-toggle="pill" data-bs-target="#pills-unsubscribed" type="button" role="tab" aria-controls="pills-unsubscribed" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'unsubscribed');">{{__('app.unsubscribed')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-bounces-tab" data-bs-toggle="pill" data-bs-target="#pills-bounces" type="button" role="tab" aria-controls="pills-bounces" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'bounces');">{{__('app.bounces')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-spam-tab" data-bs-toggle="pill" data-bs-target="#pills-spam" type="button" role="tab" aria-controls="pills-spam" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'spam');">{{__('app.spams')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-logs-tab" data-bs-toggle="pill" data-bs-target="#pills-logs" type="button" role="tab" aria-controls="pills-logs" aria-selected="false" onclick="detailStatsTriggers('{{ $schedule_stat->id }}', 'logs');">{{__('app.logs')}}</button>
   </li>
</ul>

<div class="tab-content" id="pills-tabContent">
  <div class="tab-pane fade show active" id="pills-summary" role="tabpanel" aria-labelledby="pills-summary-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_summary"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-opens" role="tabpanel" aria-labelledby="pills-opens-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_opens"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-clicks" role="tabpanel" aria-labelledby="pills-clicks-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_clicks"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-replies" role="tabpanel" aria-labelledby="pills-replies-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_replies"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-unsubscribed" role="tabpanel" aria-labelledby="pills-unsubscribed-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_unsubscribed"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-bounces" role="tabpanel" aria-labelledby="pills-bounces-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_bounces"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-spam" role="tabpanel" aria-labelledby="pills-spam-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_spam"></div>
        </div>
     </div>
  </div>
  <div class="tab-pane fade" id="pills-logs" role="tabpanel" aria-labelledby="pills-logs-tab">
     <div class="card custom-card">
        <div class="card-body">
           <div id="tab_stat_trigger_logs"></div>
        </div>
     </div>
  </div>
</div>
@include('includes.datatables')
@endsection
