@extends('layouts.login')

@section('content')
<p class="mb-4  op-7 fw-normal text-center">{{ __('app.welcome_back') }}</p>
<form method="POST" action="{{ route('login') }}" id="login-form">
    @csrf
    <div class="row gy-3">
        <div class="col-xl-12 mb-2">
            <label for="email" class="form-label text-default">{{ __('app.login_username') }}</label>
            <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{ __('app.login_username') }}">
            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
        <div class="col-xl-12 mb-2">
            <label for="password" class="form-label text-default d-block">{{ __('app.loing_password') }}<a tabindex="-1" href="{{ route('password.request') }}" class="float-end fw-normal text-decoration-none" style="color: #6c757d; transition: color 0.3s ease;" onmouseover="this.style.color='#007bff'" onmouseout="this.style.color='#6c757d'">{{ __('app.forgot_password') }}</a></label>
            <div class="position-relative">
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="current-password">
                @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <a tabindex="-1" href="javascript:void(0);" class="show-password-button " onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
            <div class="mt-2">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                    <label class="form-check-label  fw-normal" for="defaultCheck1">
                        {{ __('app.remember_me') }}
                    </label>
                </div>
            </div>
        </div>
    </div>                        
    <div class="d-grid mt-4">
        <button type="submit" class="btn btn-primary" id="signin-btn">
            <span id="signin-text">
                <i class="bi bi-box-arrow-in-right me-1"></i>{{ __('app.sign_in') }}
            </span>
            <span id="signin-loader" class="d-none">
                <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                {{ __('app.signing_in') }}...
            </span>
        </button>
    </div>
</form>
@endsection

<script>
function showLoader() {
    // Show loader and hide text
    document.getElementById('signin-text').classList.add('d-none');
    document.getElementById('signin-loader').classList.remove('d-none');
    
    // Disable the button to prevent multiple submissions
    document.getElementById('signin-btn').disabled = true;
}

// Listen for form submission
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('login-form');
    const button = document.getElementById('signin-btn');
    
    if (form && button) {
        form.addEventListener('submit', function(e) {
            // Show loader immediately
            showLoader();
            // Allow form to submit normally
            return true;
        });
    }
    
    // Reset loader if there are validation errors (page reloads)
    const hasErrors = document.querySelector('.is-invalid');
    if (hasErrors) {
        // Reset button state if there are errors
        document.getElementById('signin-text').classList.remove('d-none');
        document.getElementById('signin-loader').classList.add('d-none');
        document.getElementById('signin-btn').disabled = false;
    }
});
</script>
