@extends('layouts.login')

@section('content')
<div class="text-center mb-4">
    <h4 class="text-primary fw-bold mb-2">{{ __('app.reset_password') }}</h4>
</div>
@if (session('status'))
    <div class="alert alert-success" role="alert">
        {{ session('status') }}
    </div>
@endif

<form method="POST" action="{{ route('password.email') }}" id="forgot-password-form">
    @csrf
    <div class="row mb-3">
         <label for="email" class="form-label text-default">{{ __('app.login_username') }} <sup class="fs-12 text-danger">*</sup><a href="{{ route('login') }}" class="float-end btn btn-outline-primary btn-sm">{{ __('app.sign_in') }}</a></label>

        <div class="col-xl-12 mb-2">
            <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{ __('app.login_username') }}">

            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>

    <div class="d-grid mt-4">
        <button type="submit" class="btn btn-primary" id="reset-password-btn">
            <span id="reset-password-text">
                <i class="bi bi-envelope me-1"></i>{{ __('app.reset_password') }}
            </span>
            <span id="reset-password-loader" class="d-none">
                <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                {{ __('app.sending') }}...
            </span>
        </button>
    </div>
</form>
@endsection

<script>
function showResetPasswordLoader() {
    // Show loader and hide text
    document.getElementById('reset-password-text').classList.add('d-none');
    document.getElementById('reset-password-loader').classList.remove('d-none');
    
    // Disable the button to prevent multiple submissions
    document.getElementById('reset-password-btn').disabled = true;
}

// Listen for form submission
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('forgot-password-form');
    const button = document.getElementById('reset-password-btn');
    
    if (form && button) {
        form.addEventListener('submit', function(e) {
            // Show loader immediately
            showResetPasswordLoader();
            // Allow form to submit normally
            return true;
        });
    }
    
    // Reset loader if there are validation errors (page reloads)
    const hasErrors = document.querySelector('.is-invalid');
    if (hasErrors) {
        // Reset button state if there are errors
        document.getElementById('reset-password-text').classList.remove('d-none');
        document.getElementById('reset-password-loader').classList.add('d-none');
        document.getElementById('reset-password-btn').disabled = false;
    }
});
</script>
