<style>
.modal-body {
  overflow-y: scroll !important; /* Ensures scrolling */
  scrollbar-width: thin; /* For Firefox */
  scrollbar-color: #888 #f0f0f0; /* Scrollbar track and thumb color */
}

.modal-body::-webkit-scrollbar {
  width: 8px; /* Adjust width */
}

.modal-body::-webkit-scrollbar-thumb {
  background-color: #888; /* Scrollbar color */
  border-radius: 4px;
}

.modal-body::-webkit-scrollbar-track {
  background: #f0f0f0; /* Track color */
}

</style>

<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
<div class="modal-content">
  <div class="modal-header">
    <h6 class="modal-title">{{ __('app.blacklist_monitor') }} ({{$blacklisted->name}})</h6>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
  </div>
  <div class="modal-body">
    <div class="box-body col-md-12">
      <div class="border-top bg-light px-3 py-1">
        <div class="row">
        <label class="col-md-8 form-label text-dark">{{ __('app.domain') }}</label>
        <div class="col-md-4">
          <label class="form-label text-dark">{{ __('app.listed') }}</label>
        </div>
      </div>
      </div>
      @php
        $detail = json_decode($blacklisted->detail);
        // Separate entries into "Yes" and "No" categories
          $yesList = [];
          $noList = [];

          foreach ($detail as $domain => $pass) {
              if ($pass == 'Yes') {
                  $yesList[$domain] = $pass;
              } else {
                  $noList[$domain] = $pass;
              }
          }

          // Merge "Yes" entries first, then "No" entries
          $sortedDetail = array_merge($yesList, $noList);
      @endphp

      @foreach($sortedDetail as $domain => $pass)
          <div class="border-top bg-light px-3 py-1">
              <div class="row">
                  <label class="col-md-8 control-label text-dark">{{ $domain }}</label>
                  <div class="col-md-4">
                      <label class="control-label {{ $pass == 'No' ? 'text-success' : 'text-danger' }}">{{ $pass }}</label>
                  </div>
              </div>
          </div>
      @endforeach
    </div>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
  </div>
</div>
</div>
