@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [2]}],
    "order": [[ 1, "desc" ]],
    "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
    "ajax": $('#route-blacklisted-domains').data('route'),
    });
    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.domains') }}</th>
                                <th>{{ __('app.blacklisted') }}</th>
                                <th>{{ __('app.detail') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-blacklisted-domains" data-route="{{ route('get.blacklisted.domains') }}"></span>
@include('includes.datatables')
@endsection
