<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
  <div class="modal-content">
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
          <span class="avatar avatar-xs avatar-rounded bg-primary svg-white">
            <i class="bi bi-upload"></i>
          </span>
        </div>
        <div>
          <h6 class="modal-title text-primary fw-semibold mb-0">{{ __('app.system_bounced') }}</h6>
          <small>{{ __('app.import_system_bounced_description') }}</small>
        </div>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
      <form id="frm-group" enctype="multipart/form-data" class="needs-validation" novalidate>
       
        <div class="row mb-4">
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold">{{__('app.file')}} <span class="text-danger">*</span></label>
              <input class="form-control" name="file" type="file" id="file" required>
              <div class="form-text">
                <i class="bi bi-info-circle me-1"></i>
                <span class="fs-11">({!! \App\Http\Helper\Helper::getMaxFileSize(false, true) !!})</span>
              </div>
              <div class="invalid-feedback">{{__('app.file_required')}}</div>
            </div>
          </div>
        </div>

        <!-- Fields Mapping Section -->
        <div class="row mb-4" id="fields-mapping" style="display: none;">
          <div class="col-12">
            <div class="d-flex align-items-center mb-3">
              <div class="p-2 border border-success border-opacity-10 bg-success-transparent rounded-circle me-3">
                <span class="avatar avatar-xs avatar-rounded bg-success svg-white">
                  <i class="bi bi-diagram-3"></i>
                </span>
              </div>
              <h6 class="mb-0 text-success fw-semibold fs-14">{{ __('app.fields_mapping') }}</h6>
            </div>
            <div id="bounce-fields"></div>
          </div>
        </div>
        
        <div class="modal-footer">
          <div class="d-flex gap-2 w-100">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
              <i class="bi bi-x-circle me-1"></i>{{__('app.close')}}
            </button>
            <button type="button" class="btn btn-primary btn-loading" id="btn-proceed" onclick="bouncesImport(this.form, '{{ route('system.bounced.import') }}');">
              <i class="bi bi-check-circle me-1"></i>{{ __('app.proceed') }}
            </button>
            <button type="button" class="btn btn-success btn-loading" id="btn-import" style="display: none;" onclick="doBouncesImport(this.form, '{{ route('system.bounced.import') }}');">
              <i class="bi bi-arrow-right me-1"></i>{{ __('app.import') }}
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
