@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0, 6]}],
    "order": [[ 5, "desc" ]],
    "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
    "ajax": $('#route-system-bounced').data('route'),
    });
    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    // Handle Import Bounces button click with loading indicator
    $('#import-bounces-btn').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-upload').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: '{{route('system.bounced.import')}}', type: 'GET',
            success: function() {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-upload');
                viewModal('modal', '{{route('system.bounced.import')}}');
            },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-upload');
                if (xhr.status === 401) { alert('You do not have permission to import bounces. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the import bounces page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="d-flex gap-2">
                                <a href="javascript:;" class="btn btn-primary btn-loading" id="import-bounces-btn">
                                    <i class="bi bi-upload me-2"></i>{{__('app.import_system_bounced')}}
                                </a>
                                <a href="javascript:;" onclick="exportBounced('{{ route('system.bounced.export') }}', '{{__('app.export_system_bounced_alert')}}', '{{ __('app.msg_export_system_bounced') }}');" class="btn btn-success" data-no-loading="true">
                                    <i class="bi bi-download me-2"></i>{{__('app.export_system_bounced')}}
                                </a>
                            </div>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item text-danger" href="javascript:;" onclick="destroyMany('{{ route('system.bounced.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.email') }}</th>
                                  <th>{{ __('app.type') }}</th>
                                  <th>{{ __('app.code') }}</th>
                                  <th>{{ __('app.detail') }}</th>
                                  <th>{{ __('app.datetime') }}</th>
                                  <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-system-bounced" data-route="{{ route('get.system.bounced') }}"></span>
@include('includes.datatables')
@endsection
