<script src="{{asset('assets/js/app.js')}}"></script>
<style>
/* Override any conflicting CSS from schedule.css or smart_wizard CSS */
.modal-dialog.modal-lg {
  max-width: 800px !important;
  width: 90% !important;
  margin: 1.75rem auto !important;
}

.modal-content {
  border-radius: 0.5rem !important;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.modal-body {
  max-height: 70vh !important;
  overflow-y: auto !important;
  padding: 1rem !important;
}

/* Ensure cards display properly */
.custom-card {
  border: 1px solid rgba(0, 0, 0, 0.125) !important;
  border-radius: 0.375rem !important;
  margin-bottom: 1rem !important;
  height: auto !important;
  min-height: auto !important;
  max-height: none !important;
}

.custom-card .card-body {
  padding: 1rem !important;
  height: auto !important;
  min-height: auto !important;
  max-height: none !important;
}

/* Fix template card heights specifically */
.modal .custom-card.h-100 {
  height: auto !important;
  min-height: auto !important;
}

.modal .card-body.p-3 {
  padding: 0.75rem !important;
  height: auto !important;
  min-height: auto !important;
}

/* Reset any wizard or schedule CSS that might interfere */
.modal .row {
  margin: 0 !important;
}

.modal .col-md-4, .modal .col-lg-3 {
  padding: 0.5rem !important;
}

/* Force consistent template card heights with minimum height for 2 lines */
.modal .col-md-4 .custom-card,
.modal .col-lg-3 .custom-card {
  height: auto !important;
  min-height: 90px !important;
  max-height: none !important;
  display: flex !important;
  flex-direction: column !important;
}

.modal .col-md-4 .custom-card .card-body,
.modal .col-lg-3 .custom-card .card-body {
  height: auto !important;
  min-height: 70px !important;
  max-height: none !important;
  flex: 1 !important;
  display: flex !important;
  flex-direction: column !important;
  justify-content: space-between !important;
}

/* Override any smart wizard or schedule CSS that might affect heights */
.modal .card {
  height: auto !important;
  min-height: auto !important;
  max-height: none !important;
}

.modal .card-body {
  height: auto !important;
  min-height: auto !important;
  max-height: none !important;
}

/* Ensure template names can wrap to multiple lines */
.modal .fs-12.fw-semibold {
  line-height: 1.4 !important;
  word-wrap: break-word !important;
  white-space: normal !important;
  height: auto !important;
  min-height: 2.1em !important; /* Approximately 2 lines */
  display: block !important;
}
</style>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
  <div class="modal-content">
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="me-3">
          <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
            <i class="bi bi-broadcast"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{__('app.available_broadcasts')}}</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
    
    <div class="modal-body">
      <!-- Broadcasts Grid -->
      <div class="row">
        @forelse(\App\Models\Broadcast::app()->orderBy('id', 'DESC')->get() as $broadcast)
        <div class="col-md-4 col-lg-3 mb-3">
          <div class="card custom-card h-100">
            <div class="card-body p-3">
              <div class="d-flex align-items-center justify-content-between">
                <div>
                  <h6 class="mb-0 fs-12 fw-semibold">{{ $broadcast->name }}</h6>
                </div>
                <button class="btn btn-outline-primary btn-sm" onclick="insertCKEDITOR('{{ $broadcast->id }}', '/broadcast/html/', '{{addslashes($broadcast->email_subject)}}')" title="{{ __('app.insert') }}">
                  <i class="bi bi-arrow-down-circle"></i>
                </button>
              </div>
            </div>
          </div>
        </div>
        @empty
        <div class="col-12">
          <div class="text-center py-5">
            <div class="p-3 border border-info border-opacity-10 bg-info-transparent rounded-circle d-inline-block mb-3">
              <span class="avatar avatar-lg avatar-rounded bg-info svg-white">
                <i class="bi bi-broadcast"></i>
              </span>
            </div>
            <h5 class="">{{ __('app.no_broadcast_found') }}</h5>
            <p class="">{{ __('app.no_broadcast_found_description') }}</p>
          </div>
        </div>
        @endforelse
      </div>
    </div>
    
    <div class="modal-footer">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
      </button>
      <a href="{{ route('broadcasts.create') }}">
        <button class="btn btn-primary">
          <i class="bi bi-plus-circle me-1"></i>{{ __('app.add_new_campaign') }}
        </button>
      </a>
    </div>
  </div>
</div>
<span id="insert-template-msg" data-value="{{__('app.insert_broadcast_msg')}}"></span>
