@php
session_save_path(__DIR__ . '/sessions');
if (!is_dir(__DIR__ . '/sessions')) {
    mkdir(__DIR__ . '/sessions', 0777, true);
}
session_start();
$_SESSION['user_id'] = Auth::user()->id; // will be us in imageuploader
$_SESSION['lang'] = Auth::user()->language // will be us in imageuploader
@endphp
@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
<script>sessionStorage.setItem("user_id", "<?php echo $_SESSION['user_id']; ?>");</script>
<script>
$(document).ready(function() {
    // Initialize Select2 for group dropdown
    $('#group_id').select2({
        placeholder: '{{__("app.select_group")}}',
        allowClear: false,
        width: '100%',
        dropdownParent: $('body')
    });
});
</script>
@endpush

@section('styles')
<style type="text/css">
  .modal-body {
    overflow: scroll !important;
   }
   .select2-container {
    z-index: 1040 !important;
   }
   
   /* Group dropdown styling */
   .select2-container { z-index: 1040 !important; }
   .select2-dropdown { max-height: 300px; overflow-y: auto; z-index: 1040 !important; position: absolute !important; }
   .select2-results__options { max-height: 250px; overflow-y: auto; }
   .select2-results__option { padding: 8px 12px; font-size: 14px; }
   .select2-results__option--highlighted { background-color: #007bff; color: white; }
   .select2-container--default .select2-results > .select2-results__options { max-height: 250px; overflow-y: auto; }
   .select2-dropdown--below { z-index: 1040 !important; }
   .form-group { overflow: visible !important; }
   .col-md-6 { overflow: visible !important; }
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('broadcasts.update', $broadcast->id) }}" class="needs-validation" novalidate>
         @csrf
         @method('PUT')    
         
         <!-- Basic Information Section -->
         <div class="row mb-3">
            
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.group')}}
                     <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_campaigns')])}}');" class="text-primary ms-1">
                        <i class="bi bi-plus-circle"></i>
                     </a>
                  </label>
                  <select name="group_id" class="form-select" id="group_id" required>
                     <option value="">{{__('app.select_group')}}</option>
                     @foreach($groups as $id => $group_name)
                     <option value="{{ $id }}" {{ $broadcast->group_id == $id ? 'selected' : '' }}>{{$group_name}}</option>
                     @endforeach
                  </select>
                  <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
               </div>
            </div>
            
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ $broadcast->name }}" name="name" required>
                  <div class="invalid-feedback">{{__('app.name_required')}}</div>
               </div>
            </div>
         </div>
         
         <!-- Campaign Content Section -->
         <div class="row mb-3">
            <div class="col-12">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                     <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-envelope"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.campaign_content')}}</h6>
               </div>
            </div>
            
            <div class="col-12">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.subject')}}
                     <a tabindex="-1" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" data-bs-custom-class="header-primary" title="{{__('app.subject')}}" data-bs-content="{{__('app.subject_help')}}" class="text-primary ms-1">
                        <i class="bi bi-question-circle"></i>
                     </a>
                  </label>
                  <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ $broadcast->email_subject }}" name="email_subject" required>
                  <div class="invalid-feedback">{{__('app.subject_required')}}</div>
               </div>
            </div>
            
            <div class="col-12">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.content')}}</label>
                  {!! \App\Http\Helper\Helper::contentEditorButtons('content_html') !!}
                  <textarea class="form-control" id="content_html" name="content_html" rows="10">{{\App\Http\Helper\Helper::decodeString($broadcast->content_html) }}</textarea>
               </div>
            </div>
         </div>
         
         <!-- Action Buttons -->
         <div class="row">
            <div class="col-12">
               <div class="d-flex gap-2">
                  <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading">
                     <i class="bi bi-check-lg me-1"></i>{{__('app.save_exit')}}
                  </button>
                  <button type="submit" name="save_continue" value="1" class="btn btn-success btn-loading">
                     <i class="bi bi-save me-1"></i>{{__('app.save_continue_edit')}}
                  </button>
                  <button type="button" id="validate-imap" onclick="viewModal('modal', '{{route('send.email', [$broadcast->id, 0, 0])}}')" class="btn btn-info">
                     <i class="bi bi-send me-1"></i>{{__('app.send_test_email')}}
                  </button>
                  <a href="{{route('broadcasts.index')}}" class="btn btn-light">
                     <i class="bi bi-arrow-left me-1"></i>{{__('app.exit')}}
                  </a>
               </div>
            </div>
         </div>
      </form>
   </div>
</div>
@endsection
