@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script src="{{asset('assets/js/broadcast.js')}}"></script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('broadcasts.create')}}" class="btn btn-primary btn-loading" id="add-broadcast-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_campaign')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('broadcasts.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                  <th>{{ __('app.name') }}</th>
                                  <th>{{ __('app.group') }}</th>
                                  <th>{{ __('app.created') }}</th>
                                  <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="route-group" value="{{ route('group.delete', ['model' => 'broadcast']) }}">
<span id="route-broadcasts" data-route="{{ route('broadcasts') }}"></span>
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-broadcast" data-value="{{ __('app.tooltip_group_delete_broadcast') }}"></span>
<span id="msg-group-delete-broadcast" data-value="{{ __('app.msg_group_delete_broadcast') }}"></span>
<span id="tooltip-group-eraser-broadcast" data-value="{{ __('app.tooltip_group_eraser_broadcast') }}"></span>
<span id="route-group-eraser-broadcast" data-route="{{ route('group.delete', ['model' => 'broadcast']) }}"></span>
<span id="msg-group-erase-broadcast" data-value="{{ __('app.msg_group_eraser_broadcast') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
