@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
<script type="text/javascript">
$(function() {
	'use strict';
	$('.repeater-contact').repeater({
		show: function () {
			$(this).slideDown();
		},
		hide: function (deleteElement) {
			if(confirm("{{ __('app.msg_delete_repeater_element') }}")) {
				$(this).slideUp(deleteElement);
			}
		},
		isFirstItemUndeletable: true
	});
	$(".modal").on("hidden.bs.modal", function() {
		document.getElementById("shortcode").select();
		document.execCommand("copy");
		$('.btn-primary').focus();
	});
});
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card">
      <div class="card-header">
        <div class="d-flex align-items-center">
          <div class="me-3">
            <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
              <i class="bi bi-envelope-at"></i>
            </span>
          </div>
          <h6 class="mb-0 fw-semibold">{{__('app.mail_headers')}}</h6>
        </div>
        <div class="d-flex align-items-center gap-2">
          <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');">
            <i class="bi bi-code-slash me-1"></i>{{ __('app.shortcodes') }}
          </button>
          <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.mail_headers')}}"
            data-bs-content="{{__('app.mail_headers_help')}}" data-bs-custom-class="header-primary">
            <i class="bi bi-question-square text-primary"></i>
          </a>
        </div>
      </div>
      
      <div class="card-body">
        <form method="post" action="{{route('broadcast.mail.headers')}}" class="form-horizontal" id="frm-mail-headers">
          @csrf
          @method('PUT')
          
          <!-- Header Labels -->
          <div class="row mb-3">
            <div class="col-md-4">
              <label class="form-label fw-semibold">{{ __('app.header_name') }}</label>
            </div>
            <div class="col-md-1"></div>
            <div class="col-md-4">
              <label class="form-label fw-semibold">{{ __('app.header_value') }}</label>
            </div>
            <div class="col-md-3">
              <label class="form-label fw-semibold">{{ __('app.actions') }}</label>
            </div>
          </div>
          
          <!-- Repeater Container -->
          <div class="repeater-contact">
            <div data-repeater-list="mail_headers">
              @if(!empty($mail_headers))
              @foreach($mail_headers as $key => $value)
              <div data-repeater-item class="row mb-3">
                <div class="col-md-4">
                  <input type="text" class="form-control" name="key" value="{{ \App\Http\Helper\Helper::decodeString($key) }}" placeholder="{{ __('app.header_name') }}">
                </div>
                <div class="col-md-1 d-flex align-items-center justify-content-center">
                  <span class="">:</span>
                </div>
                <div class="col-md-4">
                  <input type="text" class="form-control" name="value" value="{{ \App\Http\Helper\Helper::decodeString($value) }}" placeholder="{{ __('app.header_value') }}">
                </div>
                <div class="col-md-3">
                  <button data-repeater-delete type="button" class="btn btn-outline-danger btn-sm">
                    <i class="bi bi-trash me-1"></i>{{ __('app.delete') }}
                  </button>
                </div>
              </div>
              @endforeach
              @else
              <div data-repeater-item class="row mb-3">
                <div class="col-md-4">
                  <input type="text" class="form-control" name="key" value="" placeholder="{{ __('app.header_name') }}">
                </div>
                <div class="col-md-1 d-flex align-items-center justify-content-center">
                  <span class="">:</span>
                </div>
                <div class="col-md-4">
                  <input type="text" class="form-control" name="value" value="" placeholder="{{ __('app.header_value') }}">
                </div>
                <div class="col-md-3">
                  <button data-repeater-delete type="button" class="btn btn-outline-danger btn-sm">
                    <i class="bi bi-trash me-1"></i>{{ __('app.delete') }}
                  </button>
                </div>
              </div>
              @endif
            </div>
            
            <!-- Add Button -->
            <div class="row mb-4">
              <div class="col-12">
                <button data-repeater-create type="button" class="btn btn-outline-primary btn-sm">
                  <i class="bi bi-plus-circle me-1"></i>{{ __('app.add') }}
                </button>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2">
                <button type="submit" name="save" class="btn btn-primary btn-loading">
                  <i class="bi bi-check-circle me-1"></i>{{__('app.save')}}
                </button>
                <a href="{{route('contacts.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.exit')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
