<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
  <div class="modal-content">
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="me-3">
          <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
            <i class="bi bi-shield-check"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{__('app.spam_score')}}</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
    
    <div class="modal-body">
      <!-- Help Information -->
      <div class="row mb-3">
        <div class="col-12">
          <div class="alert alert-info">
            <div class="d-flex align-items-center">
              <i class="bi bi-info-circle me-2"></i>
              <div>{!!__('app.spam_score_help') !!}</div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Spam Score Results -->
      <div class="row mb-3">
        <div class="col-12">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                <i class="bi bi-graph-up"></i>
              </span>
            </div>
            <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.spam_analysis_results')}}</h6>
          </div>
        </div>
        
        <div class="col-12 mt-3">
          <div class="card">
            <div class="card-body">
              <div class="row align-items-center">
                <div class="col-md-4">
                  <label class="form-label fw-semibold ">{{ __('app.total_spam_score') }}</label>
                </div>
                <div class="col-md-8">
                  <div class="d-flex align-items-center">
                    <span class="badge 
                      @if($spam_score['total_spam_score'] > 15 )
                        bg-danger
                      @elseif($spam_score['total_spam_score'] > 5 )
                        bg-warning
                      @else
                        bg-success
                      @endif
                      fs-6 px-3 py-2 me-2">
                      {{$spam_score['total_spam_score']}}
                    </span>
                    <span class=" fs-12">
                      @if($spam_score['total_spam_score'] > 15 )
                        {{__('app.high_risk')}}
                      @elseif($spam_score['total_spam_score'] > 5 )
                        {{__('app.medium_risk')}}
                      @else
                        {{__('app.low_risk')}}
                      @endif
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Detailed Analysis -->
      <div class="row">
        <div class="col-12">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                <i class="bi bi-list-ul"></i>
              </span>
            </div>
            <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.detailed_analysis')}}</h6>
          </div>
        </div>
        
        <div class="col-12 mt-3">
          <div class="card">
            <div class="card-body">
              <div class="row">
                <div class="col-12">
                  <div class="spam-details">
                    @foreach($spam_score['details'] as $score)
                    <div class="d-flex align-items-center mb-2">
                      <i class="bi bi-arrow-right  me-2"></i>
                      <span class="text-dark">{{$score}}</span>
                    </div>
                    @endforeach
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="modal-footer">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
      </button>
    </div>
  </div>
