{{-- Global DataTable Styling Component --}}
{{-- Include this in all templates that use DataTables --}}

@push('styles')
<link rel="stylesheet" href="{{ asset('css/datatable-global.css') }}">
<style>
    /* Additional per-template customizations can go here */
    @if(isset($customStyles))
        {!! $customStyles !!}
    @endif
</style>
@endpush

@push('scripts')
<script src="{{ asset('assets/js/datatable-global.js') }}"></script>
<script>
$(document).ready(function() {
    // Apply DataTable styling to current page
    if ($('#data').length) {
        // Apply styling immediately
        applyDataTableStyling($('#data'));
        
        // Apply styling on DataTable events
        $('#data').on('draw.dt', function() {
            applyDataTableStyling($(this));
        });
        
        // Apply styling on page load with delay
        setTimeout(function() {
            applyDataTableStyling($('#data'));
        }, 100);
        
        // Enhanced handling for dynamically loaded rows
        $('#data').on('DOMNodeInserted', function(e) {
            if ($(e.target).is('tr')) {
                setTimeout(function() {
                    applyDataTableStyling($('#data'));
                }, 50);
            }
        });
        
        // Handle AJAX-loaded content
        $(document).ajaxComplete(function() {
            setTimeout(function() {
                applyDataTableStyling($('#data'));
            }, 100);
        });
        
        // Apply styling when new rows are added
        $('#data tbody').on('DOMNodeInserted', 'tr', function() {
            setTimeout(function() {
                applyDataTableStyling($('#data'));
            }, 50);
        });
    }
    
    @if(isset($customScripts))
        {!! $customScripts !!}
    @endif
});
</script>
@endpush
