@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
(function () {
   'use strict';
   $("#list_ids").change(function () {
      var list_id = $('#list_ids').val();
      if(list_id == '') {
         $('#list_custom_fields').html('');
         return;
      }
      loadListCustomFields(list_id);
   });
})();
loadListCustomFieldsWithData();
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('contacts.update', $contact->id) }}" class="needs-validation" novalidate>
         <input type="hidden" name="list_id" id="list-id" value="{{ $contact->list_id }}">
         <input type="hidden" name="contact_id" id="contact-id" value="{{ $contact->id }}">
         @csrf       
         @method('PUT')
         
         <!-- General Information Section -->
         <div class="row mb-3">
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.list')}}</label>
                  <input type="text" disabled class="form-control" value="{{ $contact->list->name }}" />
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.email')}}</label>
                  <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $contact->email }}" name="email" required>
                  <div class="invalid-feedback">{{__('app.email_required')}}</div>
               </div>
            </div>
         </div>
         <!-- Contact Settings Section -->
         <div class="row mb-3">
            <div class="col-12">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                     <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-gear"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.contact_settings')}}</h6>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.active')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.active')}}"
                        data-bs-content="{{__('app.import_contact_active_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="is_active" class="form-select form-select-lg">
                     <option value="1" {{ $contact->is_active ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                     <option value="0" {{ $contact->is_active ? '' : 'selected' }}>{{ __('app.no')}}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.subscribed')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subscribed')}}"
                        data-bs-content="{{__('app.add_contact_subscribed_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="is_unsubscribed" class="form-select form-select-lg">
                     <option value="0" {{ $contact->is_unsubscribed ? '' : 'selected' }}>{{ __('app.yes') }}</option>
                     <option value="1" {{ $contact->is_unsubscribed ? 'selected' : '' }}>{{ __('app.no')}}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.confirmed')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.confirmed')}}"
                        data-bs-content="{{__('app.import_contact_confirmed_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="is_confirmed" class="form-select form-select-lg">
                     <option value="0" {{ $contact->is_confirmed ? '' : 'selected' }}>{{ __('app.no')}}</option>
                     <option value="1" {{ $contact->is_confirmed ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.verified')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.verified')}}"
                        data-bs-content="{{__('app.import_contact_verified_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="is_verified" class="form-select form-select-lg">
                     <option value="0" {{ $contact->is_verified ? '' : 'selected' }}>{{ __('app.no')}}</option>
                     <option value="1" {{ $contact->is_verified ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  </select>
               </div>
            </div>
         </div>

         <!-- Custom Fields Section -->
         <div class="row mb-3">
            <div class="col-12">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-list-ul"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.custom_fields')}}</h6>
               </div>
            </div>
            <div class="col-12" id="list_custom_fields">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{ __('app.no_custom_field') }}</label>
               </div>
            </div>
         </div>

         <!-- Action Buttons -->
         <div class="row">
            <div class="col-12">
               <div class="d-flex gap-2">
                  <button type="submit" name="update" value="update" class="btn btn-primary btn-loading">
                     <i class="bi bi-check-lg me-1"></i>{{__('app.update')}}
                  </button>
                  <a href="{{route('contacts.index')}}" class="btn btn-light">
                     <i class="bi bi-arrow-left me-1"></i>{{__('app.exit')}}
                  </a>
               </div>
            </div>
         </div>
      </form>
   </div>
</div>
@endsection
