<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
<div class="modal-content">
  <form method="POST" action="{{ route('contacts.export', [$list->id]) }}" class="needs-validation" novalidate>
    @csrf
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="me-3">
          <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
            <i class="bi bi-download"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{ __('app.export') }} {{ __('app.contacts') }} ({{ $list->name }})</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
    <div class="modal-body">
      <!-- List Information Section -->
      <div class="row mb-3">
        <div class="col-12">
          <div class="form-group">
            <label class="form-label fw-semibold">{{ __('app.list') }}</label>
            <div class="form-control-plaintext">{{ $list->name }}</div>
          </div>
        </div>
      </div>

      <!-- Export Filters Section -->
      <div class="row mb-3">
        <div class="col-12">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                <i class="bi bi-funnel"></i>
              </span>
            </div>
            <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.export_filters')}}</h6>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label class="form-label fw-semibold mt-2">{{__('app.active')}}</label>
            <select name="is_active" class="form-select form-select-lg">
              <option value="both">{{ __('app.both')}}</option>
              <option value="no">{{ __('app.no')}}</option>
              <option value="yes">{{ __('app.yes') }}</option>
            </select>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label class="form-label fw-semibold mt-2">{{__('app.subscribed')}}</label>
            <select name="is_subscribed" class="form-select form-select-lg">
              <option value="both">{{ __('app.both')}}</option>
              <option value="no">{{ __('app.no')}}</option>
              <option value="yes">{{ __('app.yes') }}</option>
            </select>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label class="form-label fw-semibold mt-2">{{__('app.verified')}}</label>
            <select name="is_verified" class="form-select form-select-lg">
              <option value="both">{{ __('app.both')}}</option>
              <option value="no">{{ __('app.no')}}</option>
              <option value="yes">{{ __('app.yes') }}</option>
            </select>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label class="form-label fw-semibold mt-2">{{__('app.confirmed')}}</label>
            <select name="is_confirmed" class="form-select form-select-lg">
              <option value="both">{{ __('app.both')}}</option>
              <option value="no">{{ __('app.no')}}</option>
              <option value="yes">{{ __('app.yes') }}</option>
            </select>
          </div>
        </div>
      </div>
    </div>
    <div class="modal-footer">
      <input type="hidden" name="list_id" value="{{$list->id}}">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
      </button>
      <button type="submit" class="btn btn-primary btn-loading">
        <i class="bi bi-upload me-1"></i>{{__('app.export')}}
      </button>
    </div>
  </form>
</div>
</div>
