@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function() {
   'use strict';
   $("#lists").change(function () {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      $('#btn-proceed').show();
   });

  const choices = new Choices(document.getElementById('lists'), {
    searchEnabled: true,
    itemSelectText: '',
    shouldSort: false,
    renderChoiceLimit: -1,
    placeholder: true
  });
});
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('contacts.store') }}" class="needs-validation" novalidate enctype="multipart/form-data">
         @csrf
         
         <!-- General Information Section -->
         <div class="row mb-3">
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.list')}}
                     <a href="{{ route('lists.create') }}" class="text-primary ms-1">
                        <i class="bi bi-plus-circle"></i>
                     </a>
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                        data-bs-content="{{__('app.import_contact_lists_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="list_id" class="form-control" id="lists" required>
                     <option value="">{{__('app.select_list')}}</option>
                     @foreach(\App\Models\Lists::groupLists() as $group)
                     <optgroup label="{{ $group->name }}">
                        @foreach($group->lists as $list)
                        <option value="{{ $list->id }}" {{ (isset($list_id) && $list->id == $list_id) ? 'selected="selected"' : '' }}>{{$list->name}} ({{$list->total_contacts ?? 0}})</option>
                        @endforeach
                     </optgroup>
                     @endforeach
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.file')}}
                     <small>({!! \App\Http\Helper\Helper::getMaxFileSize(false, true) !!})</small>
                  </label>
                  <input class="form-control" name="file" type="file" id="file" required>
               </div>
            </div>
         </div>

         <!-- Import Settings Section -->
         <div class="row mb-3">
            <div class="col-12">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                     <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-gear"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.import_settings')}}</h6>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.duplicates')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.duplicates')}}"
                        data-bs-content="{{__('app.import_contact_duplicates_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="duplicates" class="form-select form-select-lg" id="duplicates">
                     <option value="skip">{{ __('app.skip_exist') }}</option>
                     <option value="skip_global">{{ __('app.skip_already_exist') }}</option>
                     <option value="overwrite">{{ __('app.overwrite')}}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.active')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.active')}}"
                        data-bs-content="{{__('app.import_contact_active_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="active" class="form-select form-select-lg" id="active">
                     <option value="1">{{ __('app.yes') }}</option>
                     <option value="0">{{ __('app.no')}}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.confirmed')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.confirmed')}}"
                        data-bs-content="{{__('app.import_contact_confirmed_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="confirmed" class="form-select form-select-lg" id="confirmed">
                     <option value="0">{{ __('app.no')}}</option>
                     <option value="1">{{ __('app.yes') }}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.verified')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.verified')}}"
                        data-bs-content="{{__('app.import_contact_verified_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="verified" class="form-select form-select-lg" id="verified">
                     <option value="0">{{ __('app.no')}}</option>
                     <option value="1">{{ __('app.yes') }}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.bounced')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.bounced')}}"
                        data-bs-content="{{__('app.import_contact_bounced_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="bounced" class="form-select form-select-lg" id="bounced">
                     <option value="allow">{{ __('app.allow') }}</option>
                     <option value="skip">{{ __('app.skip')}}</option>
                  </select>
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.suppressed')}}
                     <a tabindex="-1" role="button"
                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.suppressed')}}"
                        data-bs-content="{{__('app.import_contact_suppressed_help')}}" data-bs-custom-class="header-primary">
                        <i class="bi bi-question-circle text-primary ms-1"></i>
                     </a>
                  </label>
                  <select name="suppressed" class="form-select form-select-lg" id="suppressed">
                     <option value="allow">{{ __('app.allow') }}</option>
                     <option value="skip">{{ __('app.skip')}}</option>
                  </select>
               </div>
            </div>
         </div>

         <!-- Custom Fields Section -->
         <div id="fields-mapping" style="display: none;" class="row mb-3">
            <div class="col-12">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-list-ul"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.custom_fields')}}</h6>
               </div>
            </div>
            <div class="col-12" id="list-custom-fields">
               <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{ __('app.no_custom_field') }}</label>
               </div>
            </div>
         </div>

         <!-- Import Progress Section -->
         <div class="box box-default" id="import-contacts" style="display: none;">
            <div class="box-header">
               <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-upload"></i>
                     </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.import')}}</h6>
               </div>
            </div>
            <div class="box-body" id="processing">
               <h6 class="text-info">{{ __('app.contact_import_msg') }}</h6>

               <div class="progress mb-3 progress-xl" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                  <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width:0%">0%</div>
               </div>

               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.total') }}</label>
                  <div id="total" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.processed') }}</label>
                  <div id="processed" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.duplicates') }}</label>
                  <div id="duplicates-data" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.invalids') }}</label>
                  <div id="invalids" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.suppressed') }}</label>
                  <div id="suppressed-data" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.bounced') }}</label>
                  <div id="bounced-data" class="col-md-10">0</div>
               </div>
            </div>
         </div>

         <!-- Action Buttons -->
         <div class="row">
            <div class="col-12">
               <div class="d-flex gap-2">
                  <button type="button" class="btn btn-primary btn-loading" id="btn-proceed" onclick="contactsImport(this.form, '{{ route('contacts.import', ['id' => $list_id]) }}');">
                     <i class="bi bi-arrow-right me-1"></i>{{ __('app.proceed') }}
                  </button>
                  <button type="button" class="btn btn-success btn-loading" id="btn-import" style="display: none;" onclick="doContactsImport(this.form, '{{ route('contacts.import', ['id' => $list_id]) }}')">
                     <i class="bi bi-upload me-1"></i>{{ __('app.import') }}
                  </button>
                  <a href="{{route('contacts.index')}}" class="btn btn-light">
                     <i class="bi bi-arrow-left me-1"></i>{{__('app.exit')}}
                  </a>
               </div>
            </div>
         </div>
      </form>
   </div>
</div>
@endsection
