@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';

    // Get the total number of columns from the table header
    let totalColumns = $('#data thead th').length;

    // Default: make all columns sortable
    let columnDefs = [];

    // Define non-sortable columns by index
    // Always disable sort for checkbox (0) and actions (last column)
    let nonSortableIndexes = [0, totalColumns - 1];

    // If you want to disable others too, like list name, status, etc.
    // Add by checking if those columns exist (e.g., assume fixed positions if present)
    if (totalColumns >= 9) {
        nonSortableIndexes.push(3, 4, 5, 6, 7, 8); // adjust if needed
    }

    columnDefs.push({ orderable: false, targets: nonSortableIndexes });

    var table = $('#data').DataTable({
        "columnDefs": columnDefs,
        "order": [[1, "desc"]],
        "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
        "ajax": {
            "url": $('#route-contacts').data('route'),
            "data": {
                "list_id": $('#list-id').data('value')
            }
        }
    });

    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    // Initialize Select2 for list dropdown
    $('#list_id').select2({
        placeholder: '{{__("app.all_contacts")}}',
        allowClear: true,
        width: '100%',
        dropdownParent: $('body')
    });

    // Handle list dropdown change
    $('#list_id').on('change', function() {
        var selectedValue = $(this).val();
        var url = '{{ route("contacts.index") }}';
        if (selectedValue) {
            url += '?list_id=' + selectedValue;
        }
        window.location.href = url;
    });
    
    // Handle Add Contact button click with error handling
    $('#add-contact-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        
        // Show loading spinner
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        
        // Try to navigate to the create page
        $.ajax({
            url: href,
            type: 'GET',
            success: function() {
                // If successful, navigate to the page
                window.location.href = href;
            },
            error: function(xhr) {
                // Reset button
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                
                if (xhr.status === 401) {
                    alert('You do not have permission to create contacts. Please contact your administrator.');
                } else if (xhr.status === 403) {
                    alert('Access forbidden. You do not have the required permissions.');
                } else {
                    alert('An error occurred while trying to access the create contact page. Please try again.');
                }
            }
        });
    });

    // Handle Import Contacts button click with error handling
    $('#import-contacts-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        
        // Show loading spinner
        $icon.removeClass('bi-download').addClass('spinner-border spinner-border-sm');
        
        // Try to navigate to the import page
        $.ajax({
            url: href,
            type: 'GET',
            success: function() {
                // If successful, navigate to the page
                window.location.href = href;
            },
            error: function(xhr) {
                // Reset button
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-download');
                
                if (xhr.status === 401) {
                    alert('You do not have permission to import contacts. Please contact your administrator.');
                } else if (xhr.status === 403) {
                    alert('Access forbidden. You do not have the required permissions.');
                } else {
                    alert('An error occurred while trying to access the import contacts page. Please try again.');
                }
            }
        });
    });
});
</script>

@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <select class="form-select" id="list_id" name="list_id">
            <option value="">{{__('app.all_contacts')}}</option>
            @foreach(\App\Models\Lists::groupLists() as $group)
              <optgroup label="{{ $group->name }}">
              @foreach($group->lists as $list)
                <option value="{{$list->id}}" {{$list->id == $list_id ? 'selected' : ''}}>{{$list->name}}</option>
              @endforeach
            @endforeach
          </select>
        <div class="card custom-card">
            
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <a href="{{route('contacts.create')}}" class="btn btn-primary btn-loading me-2" id="add-contact-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_contact')}}
                            </a>
                            <a href="{{ route('contacts.import') }}" class="btn btn-outline-primary btn-loading me-2" id="import-contacts-btn">
                                <i class="bi bi-download me-2"></i>{{__('app.import')}}
                            </a>
                            <a href="javascript:;" onclick="viewModal('modal', '{{route('contacts.customize.listing')}}');" class="btn btn-outline-info">
                                <i class="bi bi-gear me-2"></i>{{__('app.contact_customize_listing')}}
                            </a>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('contacts.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.email') }}</th>
                                <th>{{ __('app.list') }}</th>
                                @if(!empty($custom_field_names))
                                    @foreach($custom_field_names as $name)
                                    <th>{{ $name }}</th>
                                    @endforeach
                                @endif
                                <th>{{ __('app.active') }}</th>
                                <th>{{ __('app.unsub') }}</th>
                                <th>{{ __('app.confirmed') }}</th>
                                <th>{{ __('app.verified') }}</th>                                
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-contacts" data-route="{{ route('get.contacts') }}"></span>
<span id="list-id" data-value="{{ $list_id }}"></span>
@include('includes.datatables')
@endsection
