<style>
.modal-body {
  overflow-y: scroll !important; /* Ensures scrolling */
  scrollbar-width: thin; /* For Firefox */
  scrollbar-color: #888 #f0f0f0; /* Scrollbar track and thumb color */
}
</style>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
  <div class="modal-content">
    <div class="modal-header">
      <h6 class="modal-title">{{__('app.detail')}}
      </h6>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
      <div class="box-body">
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.list') }}</label>
          <div class="col-md-9">{{ $contact->list->name }}</div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.email') }}</label>
          <div class="col-md-9">{{ $contact->email }}</div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.active') }}</label>
          <div class="col-md-9"><span class="badge {{ $contact->is_active ? 'bg-success-gradient' : 'bg-danger-gradient'}}">{{ $contact->is_active ? __('app.yes') : __('app.no') }}</span></div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.unsubscribed') }}</label>
          <div class="col-md-9"><span class="badge {{ $contact->is_unsubscribed ? 'bg-success-gradient' : 'bg-danger-gradient'}}">{{ $contact->is_unsubscribed ? __('app.yes') : __('app.no') }}</span></div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.confirmed') }}</label>
          <div class="col-md-9"><span class="badge {{ $contact->is_confirmed ? 'bg-success-gradient' : 'bg-danger-gradient'}}">{{ $contact->is_confirmed ? __('app.yes') : __('app.no') }}</span></div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.verified') }}</label>
          <div class="col-md-9"><span class="badge {{ $contact->is_verified ? 'bg-success-gradient' : 'bg-danger-gradient'}}">{{ $contact->is_verified ? __('app.yes') : __('app.no') }}</span></div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.bounced') }}</label>
          <div class="col-md-9"><span class="badge {{ $contact->is_bounced ? 'bg-danger-gradient' : 'bg-success-gradient'}}">{{ $contact->is_bounced ? __('app.yes') : __('app.no') }}</span></div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.source') }}</label>
          <div class="col-md-9">{{ ucfirst($contact->source) }}</div>
        </div>
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ __('app.created') }}</label>
          <div class="col-md-9">{{ \App\Http\Helper\Helper::datetimeDisplay($contact->created_at) }}</div>
        </div>
    <div class="row mb-3">
      <h6 class="modal-title">{{ __('app.custom_fields') }}</h6>
    </div>
        @forelse($contact->customFields as $custom_field)
        <div class="row mb-3">
          <label class="col-md-3 form-label">{{ $custom_field->name }}</label>
          <div class="col-md-9">{{ str_replace('||', ', ', $custom_field->pivot->data) }}</div>
        </div>
        @empty
        <label class="form-label col-md-12 text-center">{{ __('app.no_record_found') }}</label>
        @endforelse
      </div>
    </div>
    <div class="modal-footer">
      <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
      <a href="{{ route('contacts.edit', [$contact->id]) }}"><button type="button" class="btn btn-primary">{{ __('app.edit') }}</button></a>      
    </div>
  </div>
</div>
