<style>
.choices__list--dropdown, .choices__list[aria-expanded] {
   z-index: 1060 !important; /* Above Bootstrap modals (1050) */
}
.select2-container--open {
   z-index: 1060 !important; /* Above Bootstrap modals (1050) */
}
.select2-dropdown {
   z-index: 1060 !important; /* Above Bootstrap modals (1050) */
}
</style>
<script src="{{asset('assets/js/app.js')}}"></script>
<script>
$('[data-bs-toggle="popover"]').popover({
    container: 'body'
});

// Initialize Select2 for type dropdown when modal is shown
$(document).ready(function() {
  // Wait for modal to be shown
  $('#modal').on('shown.bs.modal', function() {
    var $typeSelect = $('#type');
    
    // Destroy existing Select2 instance if it exists
    if ($typeSelect.hasClass('select2-hidden-accessible')) {
      $typeSelect.select2('destroy');
    }
    
    // Initialize Select2 with dropdownParent set to modal content
    if (typeof $.fn.select2 !== 'undefined' && $typeSelect.length > 0) {
      $typeSelect.select2({
        dir: "ltr",
        minimumResultsForSearch: Infinity,
        dropdownParent: $('.modal-content'),
        width: '100%'
      });
    }
  });
  
  // Also try to initialize immediately if modal is already shown
  setTimeout(function() {
    var $typeSelect = $('#type');
    if ($typeSelect.length > 0 && !$typeSelect.hasClass('select2-hidden-accessible')) {
      if (typeof $.fn.select2 !== 'undefined') {
        $typeSelect.select2({
          dir: "ltr",
          minimumResultsForSearch: Infinity,
          dropdownParent: $('.modal-content').length > 0 ? $('.modal-content') : $('body'),
          width: '100%'
        });
      }
    }
  }, 300);
  
  // Handle type change to show/hide values field
  $(document).on('change', '#type', function() {
    var type = $(this).val();
    (type == 'radio' || type == 'checkbox' || type == 'dropdown') ? $('#values').show() : $('#values').hide();
  });
});
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('custom_fields.store')}}" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-plus-circle"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_new_custom_field')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            <!-- Basic Information Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.name')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="" name="name" required>
                  <div class="invalid-feedback">{{__('app.name_required')}}</div>
                </div>
              </div>
              <div class="col-12">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.default')}}
                    <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                       title="{{__('app.default')}}" data-bs-content="{{__('app.custom_field_default_help')}}" 
                       data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <input type="text" class="form-control" placeholder="{{__('app.default')}}" value="" name="default">
                </div>
              </div>
            </div>

            <!-- Field Configuration Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-gear"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.field_configuration')}}</h6>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.required')}}
                    <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                       title="{{__('app.required')}}" data-bs-content="{{__('app.custom_field_required_help')}}" 
                       data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <select name="is_required" class="form-select form-select-lg">
                    <option value="0">{{ __('app.no')}}</option>
                    <option value="1">{{ __('app.yes') }}</option>                 
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.type')}}
                    <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                       title="{{__('app.type')}}" data-bs-content="{{__('app.custom_field_type_help')}}" 
                       data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <select name="type" id="type" class="single-select form-select form-select-lg">
                    @foreach($custom_field_type as $type => $name)
                    <option value="{{ $type }}">{{ $name }}</option>
                    @endforeach
                  </select>
                </div>
              </div>
              <div class="col-12" id="values" style="display:none;">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.values')}}</label>
                  <textarea class="form-control" name="values" rows="4" placeholder="{{ __('app.custom_field_values_placeholder') }}"></textarea>
                </div>
              </div>
            </div>

            <!-- List Assignment Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center">
                    <div class="me-3">
                      <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-list-ul"></i>
                      </span>
                    </div>
                    <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.list_assignment')}}</h6>
                  </div>
                  <div class="d-flex align-items-center">
                    <a href="{{route('lists.create')}}" class="text-primary me-2">
                      <i class="bi bi-plus-circle"></i>
                    </a>
                    <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                       title="{{__('app.lists')}}" data-bs-content="{{__('app.custom_field_lists_help')}}" 
                       data-bs-custom-class="header-primary" class="text-primary">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="col-12">
                <div class="form-group">
                  <label class="form-label fw-semibold"></label>
                  @php $list_ids = []; @endphp
                  @include('includes.dropdown_lists', ['popup' => 1, 'multiple' => 1])
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-x-lg me-1"></i>{{__('app.close')}}
          </button>
          <button type="submit" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.create')}}
          </button>
        </div>
      </form>
    </div>
</div>
