@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@section('styles')
<link rel="stylesheet" href="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.css')}}">
<link rel="stylesheet" href="{{asset('components/bootstrap-daterangepicker/daterangepicker.css')}}">
<style>
    .dashboard-world-map{
        height: 280px; width: 100%; text-align: center;
    }
    #div-chart-domain{
        height: 250px; text-align: center;
    }
    #calendar {
        max-width: 100%;
    }
    .fc-event {
        cursor: pointer; /* Change cursor to a hand on hover */
    }
    #fc-dom-1 {
        font-size: 1.25rem; /* Matches the size of an h5 */
    }
    
    /* Professional Activity Timeline */
    .activity-timeline {
        position: relative;
        padding-left: 0;
    }
    
    .activity-timeline::before {
        content: '';
        position: absolute;
        left: 12px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: var(--bs-border-color) !important;
    }
    
    .activity-item {
        position: relative;
        margin-bottom: 1rem;
        padding-left: 2.5rem;
    }
    
    .activity-item:last-child {
        margin-bottom: 0;
    }
    
    .activity-dot {
        position: absolute;
        left: 6px;
        top: 6px;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 2px solid var(--bs-body-bg);
        z-index: 1;
    }
    
    .activity-content {
        border: 1px solid var(--bs-border-color) !important;
        border-radius: 8px;
        padding: 0.75rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    
    .activity-content:hover {
        box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        transform: translateY(-1px);
    }
    
    /* Dark mode specific styling */
    [data-bs-theme="dark"] .activity-content {
        background: #202025 !important;
        border-color: #333 !important;
        color: #ffffff !important;
    }
    
    [data-bs-theme="dark"] .activity-content:hover {
        background: #202025 !important;
        box-shadow: 0 2px 8px rgba(255,255,255,0.1);
    }
    
    /* Additional dark mode overrides */
    .dark-mode .activity-content,
    body.dark .activity-content,
    .theme-dark .activity-content {
        background: #202025 !important;
        border-color: #333 !important;
        color: #ffffff !important;
    }
    
    .dark-mode .activity-content:hover,
    body.dark .activity-content:hover,
    .theme-dark .activity-content:hover {
        background: #202025 !important;
        box-shadow: 0 2px 8px rgba(255,255,255,0.1);
    }
    
    /* Force dark mode styling with higher specificity */
    [data-bs-theme="dark"] .activity-timeline .activity-item .activity-content {
        background: #202025 !important;
        color: #ffffff !important;
    }
    
    .activity-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 0.5rem;
    }
    
    
    /* Force white text in dark mode for all activity content */
    [data-bs-theme="dark"] .activity-content,
    [data-bs-theme="dark"] .activity-content * {
        color: #ffffff !important;
    }
    
    .dark-mode .activity-content,
    .dark-mode .activity-content *,
    body.dark .activity-content,
    body.dark .activity-content *,
    .theme-dark .activity-content,
    .theme-dark .activity-content * {
        color: #ffffff !important;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .activity-timeline::before {
            left: 8px;
        }
        
        .activity-item {
            padding-left: 2rem;
        }
        
        .activity-dot {
            left: 2px;
            width: 10px;
            height: 10px;
        }
        
        .activity-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 0.25rem;
        }
        
        .activity-content {
            padding: 0.5rem;
        }
    }
</style>
@endsection

@push('scripts')
<script src="{{asset('components/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<script src="{{asset('components/Chart.js/dist/Chart.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-world-mill-en.js')}}"></script>
<script src="{{asset('assets/js/fullcalander.min.js')}}"></script>
<script src="{{asset('assets/js/dashboard-calander.js')}}"></script>
<script src="{{asset('assets/js/dashboard.js')}}"></script>
<script>
    domiansChart(moment().subtract(7, 'days'), moment());
    countryChart(moment().subtract(7, 'days'), moment());
    campaignsChart(moment().subtract(7, 'days'), moment());
</script>
<script>
    $(function () {

    });
</script>
@endpush

@section('content')
<div id="domain" data-route="{{ route('campaigns.sent.data', ['type' => 'domain']) }}"></div>
<div id="recipients-summary" data-route="{{ route('campaigns.sent.data', ['type' => 'recipients_summary']) }}"></div>
<div id="country" data-route="{{ route('campaigns.sent.data', ['type' => 'country']) }}"></div>
<div id="campaign" data-route="{{ route('campaigns.sent.data', ['type' => 'campaigns']) }}"></div>
<div id="no-found" data-value="{{ __('app.no_record_found') }}"></div>
<div id="opens" data-value="{{ __('app.opens')}}"></div>
<div id="data-campaigns-route" data-value="{{ route('stats.campaigns') }}"></div>
<div id="data-triggers-route" data-value="{{ route('stats.triggers') }}"></div>
<div id="data-split-tests-route" data-value="{{ route('stats.split_tests') }}"></div>
<div id="schedule-campaigns-msg" data-value="{{ __('app.schedule_campaigns_msg') }}"></div>
<div id="msg-yes" data-value="{{ __('app.yes') }}"></div>
<div id="msg-cancel" data-value="{{ __('app.cancel') }}"></div>
<div id="user-lang" data-value="{{ Auth::user()->language }}"></div>

@if(Auth::user()->id == config('custom.app_id'))
@if(file_exists(public_path().DIRECTORY_SEPARATOR.'install'))
<div class="row my-2">
    <div class="col-md-12 col-sm-12 col-xs-12 text-center">
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-triangle"></i>
            {!! __('app.msg_remove_install_folder') !!}
            "{{public_path().DIRECTORY_SEPARATOR.'install'}}"
        </div>
    </div>
</div>
@endif
<!-- Display warning if cron executed more than 10 minutes -->
@if(\App\Http\Helper\Helper::getCronLatExecutedMinutes() > 10)
<div class="row my-2">
    <div class="col-md-12 col-sm-12 col-xs-12 text-center">
        <div class="alert alert-danger" role="alert">
            <i class="bi bi-exclamation-triangle"></i>
            {!! __('app.msg_cron_setup') !!}:<strong><br>
            {{ \App\Http\Helper\Helper::getCronCommand() }}</strong>
        </div>
    </div>
</div>
@endif
@if(empty($settings->from_email))
<div class="row my-2">
    <div class="col-md-12 col-sm-12 col-xs-12 text-center">
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-triangle"></i>
            {!! __('app.msg_configure_mail_setting') !!}
        </div>
    </div>
</div>
@endif
@endif


@foreach($notes as $note)
<div class="row my-2">
<div class="col-md-12 col-sm-12 col-xs-12">
    <div class="card custom-card shadow-none mb-0 shadow-none border">
        <div class="card-body p-3" style="background-color: #FFF9C4;">
            <div class="ribbon-6 ribbon-left ribbon-success" style="color: #000000 !important;">{{$note->title}}</div>
            <div class="card-subtitle fw-semibold mb-2 text-end" style="color: #000000 !important;">{{\App\Http\Helper\Helper::datetimeDisplay($note->created_at)}}</div>
            <span class="pt-4" style="color: #000000 !important;">{{$note->content}}</span>
            <div class="mt-1 text-end">
                <button class="btn btn-outline-info btn-sm" onclick="pinNote('{{route('note.pin', [$note->id])}}', '{{$note->title}}', 0)" style="{{$note->is_pinned ? '' : 'display:none'}}">
                    <i class="bi bi-pin-angle me-1"></i>{{__('app.unpin')}}
                </button>
                <button class="btn btn-outline-secondary btn-sm" onclick="pinNote('{{route('note.pin', [$note->id])}}', '{{$note->title}}', 1)" style="{{$note->is_pinned ? 'display:none' : ''}}">
                    <i class="bi bi-pin me-1"></i>{{__('app.pin_to_dashboard')}}
                </button>
                <button class="btn btn-outline-danger btn-sm" onclick="deleteNote('{{route('notes.destroy', [$note->id])}}', '{{__('app.note_delete_confirm_msg')}}')">
                    <i class="bi bi-trash me-1"></i>{{__('app.delete')}}
                </button>
            </div>
        </div>
    </div>
</div>
</div>
@endforeach

@if(\App\Http\Helper\Helper::checkPermissions('dashboard_cards', false))
<div class="row mt-2">
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body p-2">
                <div class="">
                    <div class="d-flex justify-content-between mb-1">
                        <div class="p-1 border border-primary border-opacity-10 bg-primary-transparent rounded-pill">
                            <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
                                <i class="bi bi-list-task"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-12 mb-0">{{__('app.total_lists')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h5 class="mb-0 d-flex align-items-center"><a href="{{route('lists.index')}}">{{ \App\Models\Lists::app()->count() }}</a></h5>
                    <span class="text-primary badge bg-primary-transparent rounded-pill d-flex align-items-center fs-10 me-0 ms-2 mb-0"> <a class="text-primary" href="{{route('lists.create')}}">{{__('app.add_new_list')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body p-2">
                <div class="">
                    <div class="d-flex justify-content-between mb-1">
                        <div class="p-1 border border-primary1 border-opacity-10 bg-primary1-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-sm bg-primary1 svg-white">
                                <i class="bi bi-people"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-12 mb-0">{{__('app.total_contacts')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h5 class="mb-0 d-flex align-items-center"><a href="{{route('contacts.index')}}">{{ \App\Models\Contact::app()->count() }}</a></h5>
                    <span class="text-primary1 badge bg-primary1-transparent rounded-pill d-flex align-items-center fs-10 me-0 ms-2 mb-0"><a class="text-primary1" href="{{route('contacts.create')}}">{{__('app.add_new_contact')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body p-2">
                <div class="">
                    <div class="d-flex justify-content-between mb-1">
                        <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-sm bg-info svg-white">
                                <i class="bi bi-send"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-12 mb-0">{{__('app.running_campaigns')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h5 class="mb-0 d-flex align-items-center"><a href="{{route('schedule_campaigns.index')}}">{{ \App\Models\ScheduleCampaign::getRunningCampaing() }}</a></h5>
                    <span class="text-info badge bg-info-transparent rounded-pill d-flex align-items-center fs-10 me-0 ms-2 mb-0"><a class="text-info" href="{{route('schedule_campaigns.create')}}">{{__('app.schedule_campaign')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body p-2">
                <div class="">
                    <div class="d-flex justify-content-between mb-1">
                        <div class="p-1 border border-primary3 border-opacity-10 bg-primary3-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-sm bg-primary3 svg-white">
                                <i class="bi bi-rocket-takeoff"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-12 mb-0">{{__('app.active_delivery_servers')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between">
                    <div class="fs-18 fw-medium mb-0 d-flex align-items-center"><a href="{{route('sending_servers.index')}}">{{ \App\Models\SendingServer::whereStatus('Active')->app()->count() }}</a></div>
                    <span class="text-primary3 badge bg-primary3-transparent rounded-pill d-flex align-items-center fs-10 me-0 ms-2 mb-0"><a class="text-primary3" href="{{route('sending_servers.create')}}">{{__('app.add_new_delivery_server')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12 col-lg-6 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body p-2">
                <div class="">
                    <div class="d-flex justify-content-between mb-1">
                        <div class="p-1 border border-secondary border-opacity-10 bg-secondary-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-sm bg-secondary svg-white">
                                <i class="bi bi-globe"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-12 mb-0">{{__('app.active_sending_domains')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h5 class="mb-0 d-flex align-items-center"><a href="{{route('sending_domains.index')}}">{{ \App\Models\SendingDomain::whereIsActive(true)->app()->count() }}</a></h5>
                    <span class="text-secondary badge bg-secondary-transparent rounded-pill d-flex align-items-center fs-10 me-0 ms-2 mb-0"><a class="text-secondary" href="javascript:;" onclick="viewModal('modal', '{{route('sending_domains.create')}}');">{{__('app.add_new_sending_domain')}}</a></span>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
<div class="card custom-card">
    <div class="card-body">
        <div class="row">
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_calander', false))
            <div class="col-md-5">
                <div id="calendar" class="shadow p-3 rounded"></div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_campaigns_stats', false))
            <div class="col-md-7 p-3">                
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5>{{ __('app.campaigns') }}</h5>
                                <button type="button" class="btn btn-primary btn-sm daterange-campaigns" data-toggle="tooltip" title="Date range">
                                    <i class="bi bi-calendar"></i>
                                </button>
                                <small id="campaigns-range"></small>

                                <div class="chart">
                                    <div id="div-chart-campaigns"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@if(\App\Http\Helper\Helper::checkPermissions('analatics_campaigns', false) || 
\App\Http\Helper\Helper::checkPermissions('analatics_triggers', false) || 
\App\Http\Helper\Helper::checkPermissions('analatics_split_tests', false))
<div class="card custom-card">
    <div class="card-body">
        <h5>{{ __('app.analatics') }}</h5>
        <ul class="nav nav-pills" id="pills-tab" role="tablist">
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_campaigns', false))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="pills-campaign-tab" data-bs-toggle="pill" data-bs-target="#pills-campaign" type="button" role="tab" aria-controls="pills-campaign" aria-selected="true"  >{{ __('app.campaigns') }}</button>
            </li>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_triggers', false))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-triggers-tab" data-bs-toggle="pill" data-bs-target="#pills-triggers" type="button" role="tab" aria-controls="pills-triggers" aria-selected="false">{{__('app.triggers')}}</button>
            </li>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_split_tests', false))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-split-tests-tab" data-bs-toggle="pill" data-bs-target="#pills-split-tests" type="button" role="tab" aria-controls="pills-split-tests" aria-selected="false">{{__('app.split_test')}}</button>
            </li>
            @endif
        </ul>


        <div class="tab-content" id="pills-tabContent">
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_campaigns', false))
            <div class="tab-pane fade show active" id="pills-campaign" role="tabpanel" aria-labelledby="pills-campaign-tab">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.opens') }}</th>
                                <th>{{ __('app.clicks') }}</th>
                                <th>{{ __('app.replies') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.detail') }}</th>
                                <th>{{ __('app.action') }}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_triggers', false))
            <div class="tab-pane fade" id="pills-triggers" role="tabpanel" aria-labelledby="pills-triggers-tab">
                <div class="table-responsive">
                        <table id="data-triggers" class="table table-bordered text-nowrap w-100">
                            <thead>
                                <tr>
                                    <th>{{ __('app.name') }}</th>
                                    <th>{{ __('app.based_on') }}</th>
                                    <th>{{ __('app.action') }}</th>
                                    <th>{{ __('app.scheduled_by') }}</th>
                                    <th>{{ __('app.created') }}</th>
                                    <th>{{ __('app.detail') }}</th>
                                </tr>
                            </thead>
                             <tbody></tbody>
                        </table>
                    </div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('analatics_split_tests', false))
            <div class="tab-pane fade" id="pills-split-tests" role="tabpanel" aria-labelledby="pills-split-tests-tab">
                <div class="table-responsive">
                    <table id="data-split-tests" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{{ __('app.winning_criteria') }}</th>
                                <th>{{ __('app.decision_percentage') }}</th>
                                <th>{{ __('app.action') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.opens') }}</th>
                                <th>{{ __('app.clicks') }}</th>
                                <th>{{ __('app.replies') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.detail') }}</th>
                                <th>{{ __('app.action') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endif

@if(\App\Http\Helper\Helper::checkPermissions('activity_logs', false))
<!-- Start:: row-3 -->
<div class="row">
    <div class="col-md-12">
        <div class="card custom-card">
            <div class="card-header">
                <div class="card-title"><h5>{{__('app.activities')}}</h5></div>
            </div>
            <div class="card-body p-3">
                <div class="activity-timeline">
                    @foreach($activities as $index => $activity)
                    @php
                    $description = !empty($activity->description) ? $activity->description : '---'; 
                    $values = ['primary', 'warning', 'success', 'primary1', 'primary2', 'primary3'];
                    $random = Arr::random($values);
                    @endphp
                    <div class="activity-item">
                        <div class="activity-dot bg-{{$random}}"></div>
                        <div class="activity-content">
                            <div class="activity-header">
                                <span class="activity-user fw-semibold fs-12">{{$activity->causer['name'] ?? 'System'}}</span>
                                <span class="activity-time fs-11 ">{{\App\Http\Helper\Helper::datetimeDisplay($activity->created_at)}}</span>
                            </div>
                            <div class="activity-description fs-12 mb-0">{{$description}}</div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End:: row-3 -->
@endif



<div class="card custom-card">
    <div class="card-body">
        <div class="row">
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_country_stats', false))
            <div class="col-md-8" >
                <h5>{{ __('app.open_by_countries') }}</h5>
                <button type="button" class="btn btn-primary btn-sm daterange-country" data-toggle="tooltip" title="Date range">
                    <i class="bi bi-calendar"></i>
                </button>
                <small id="country-range"></small>
                <div id="world-map" class="dashboard-world-map"></div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_domain_stats', false))
            <div class="col-md-4">
                <h5>{!! __('app.top_5_domains') !!} </h5>
                <button type="button" class="btn btn-primary btn-sm daterange-domain pull-right" data-toggle="tooltip" title="Date range">
                    <i class="bi bi-calendar"></i>
                </button>
                <small id="domain-range"></small>
                <div class="chart dashboard-world-map">
                    <div id="div-chart-domain"></div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@include('includes.datatables')
@endsection
