@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<style type="text/css">
  #group_id + .select2-container {
    z-index: 0 !important;
  }
</style>
@endsection

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
@endpush


@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <form method="POST" action="{{ route('drips.update', $drip->id) }}" class="needs-validation" novalidate>
                    @csrf       
                    @method('PUT')
                    
                    <!-- General Information Section -->
                    
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">{{__('app.drip_group')}}
                                <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_drips')])}}');">
                                    <i class="bi bi-plus-circle text-primary"></i>
                                </a>
                                <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.drip_group')}}"
                                    data-bs-content="{{__('app.drip_group_help')}}" data-bs-custom-class="header-primary">
                                    <i class="bi bi-question-square text-primary"></i>
                                </a>
                            </label>
                            <select name="group_id" class="form-select" id="group_id" required>
                                <option value="">{{__('app.select_drip_group')}}</option>
                                @foreach($groups as $id => $group_name)
                                    <option value="{{ $id }}" {{ $drip->group_id == $id ? 'selected' : '' }}>{{$group_name}}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">{{__('app.active')}}</label>
                            <select name="is_active" class="form-select">
                                <option value="1" {{ $drip->is_active ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                                <option value="0" {{ $drip->is_active ? '' : 'selected' }}>{{ __('app.no')}}</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                            <input type="name" class="form-control" placeholder="{{__('app.name')}}" value="{{ $drip->name ?? '' }}" name="name" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label class="form-label fw-semibold mt-2">{{ __('app.send') }}
                                <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.send')}}"
                                    data-bs-content="{{__('app.drip_sending_speed_help')}}" data-bs-custom-class="header-primary">
                                    <i class="bi bi-question-square text-primary"></i>
                                </a>
                            </label>
                            <select name="send" id="send" class="form-select">
                                <option value="Instant" {{ $drip->send == 'Instant' ? 'selected' : '' }}>{{ __('app.drip_instant') }}</option>
                                <option value="After" {{ $drip->send == 'After' ? 'selected' : '' }}>{{ __('app.drip_after') }}</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="row mb-3" id="send-datetime" style="{{ $drip->send == 'After' ? '' : 'display: none;' }}">
                        <div class="col-md-6">
                            <input type="number" min="0" class="form-control" name="time" value="{{ json_decode($drip->send_attributes)->time }}" placeholder="{{__('app.delay')}}">
                        </div>
                        <div class="col-md-6">
                            <select name="duration" id="duration" class="form-select">
                                <option value="minutes" {{ json_decode($drip->send_attributes)->duration == 'minutes' ? 'selected="selected"' : '' }}>{{ __('app.minutes') }}</option>
                                <option value="hours" {{ json_decode($drip->send_attributes)->duration == 'hours' ? 'selected="selected"' : '' }}>{{ __('app.hours') }}</option>
                                <option value="days" {{ json_decode($drip->send_attributes)->duration == 'days' ? 'selected="selected"' : '' }}>{{ __('app.days') }}</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Content Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                                        <i class="bi bi-file-text"></i>
                                    </span>
                                </div>
                                <h6 class="mb-0 fw-semibold">{{__('app.content')}}</h6>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label class="form-label fw-semibold mt-2">{{__('app.subject')}}
                                <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subject')}}"
                                    data-bs-content="{{__('app.subject_help')}}" data-bs-custom-class="header-primary">
                                    <i class="bi bi-question-square text-primary"></i>
                                </a>
                            </label>
                            <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ $drip->email_subject ?? '' }}" name="email_subject" id="email_subject" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            {!! \App\Http\Helper\Helper::contentEditorButtons('content_html', true, true, true, true, true) !!}
                            <textarea class="form-control" id="content_html" name="content" rows="10">{{ $drip->content ?? '' }}</textarea>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" name="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.update')}}
                                </button>
                                <a href="{{route('drips.index')}}" class="btn btn-light">
                                    <i class="bi bi-arrow-left me-1"></i>{{__('app.exit')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
