@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
    $(function () {
    'use strict';
    $('[data-toggle="tooltip"]').tooltip();
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 7]}],
        "order": [[5, "asc"], [0, "desc"]],
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": $('#route-drips').data('route'),
        "drawCallback": function ( settings, data ) {
            var api = this.api();
            var rows = api.rows( {page:'current'} ).nodes();
            var last=null;
            var groupColumn=2;
            api.column(groupColumn, {page:'current'} ).data().each( function ( group, i ) {
                var spanElement = $(group);
                var group_id = spanElement.attr('id');

                let url = $('#route-group-edit').data('route');
                let route_url = url.replace("group-id", group_id);

                if ( last !== group ) {
                    $(rows).eq( i ).before(
                        '<tr class="dt_group"><td colspan="7" class="fw-bold">'+group+'</td>'+
                        '<td>'+
                        '&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="top" class="bi bi-pencil-square" style="cursor: pointer;" title="'+$('#tooltip-group-edit').data('value')+'" onclick="viewModal(\'modal\', \''+route_url+'\')"></i>'+
                        '&nbsp;&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="top" class="bi bi-trash" style="cursor: pointer;" title="'+$('#tooltip-group-delete-drip').data('value')+'" onclick="deleteGroup(this, \''+$('#msg-group-delete-drip').data('value')+'\')"></i>'+
                        '&nbsp;&nbsp;<i data-bs-toggle="tooltip" data-bs-placement="top" class="bi bi-eraser" style="cursor: pointer;" title="'+$('#tooltip-group-eraser-drip').data('value')+'" onclick="eraseGroup(this, \''+$('#route-group-eraser-drip').data('route')+'\', \''+$('#msg-group-erase-drip').data('value')+'\')"></i>'+
                        '</td></tr>'
                        );
                    last = group;
                }
            });
            // Reinitialize Bootstrap tooltips after DataTable redraw
            $('[data-bs-toggle="tooltip"]').tooltip();
        },
    });

    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    // Handle Add Drip button click with error handling
    $('#add-drip-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: href, type: 'GET',
            success: function() { window.location.href = href; },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create drips. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create drip page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('drips.create')}}" class="btn btn-primary btn-loading" id="add-drip-btn" style="margin: 0px; display: none;">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_drip')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('drips.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.drip_group') }}</th>
                                <th>{{ __('app.name') }}</th>                                
                                <th>{{ __('app.subject') }}</th>
                                <th>{{ __('app.send') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="route-group" value="{{ route('group.delete', ['model' => 'drip']) }}">
<span id="route-drips" data-route="{{ route('get.drips') }}"></span>
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-drip" data-value="{{ __('app.tooltip_group_delete_drip') }}"></span>
<span id="msg-group-delete-drip" data-value="{{ __('app.msg_group_delete_drip') }}"></span>
<span id="tooltip-group-eraser-drip" data-value="{{ __('app.tooltip_group_eraser_drip') }}"></span>
<span id="route-group-eraser-drip" data-route="{{ route('group.delete', ['model' => 'drip']) }}"></span>
<span id="msg-group-erase-drip" data-value="{{ __('app.msg_group_eraser_drip') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
